package com.threerings.protobuf.io;

import com.threerings.admin.data.AdminMarshaller;
import com.threerings.crowd.chat.data.ChannelSpeakMarshaller;
import com.threerings.crowd.chat.data.ChatMarshaller;
import com.threerings.crowd.chat.data.ChatMarshaller.TellMarshaller;
import com.threerings.crowd.chat.data.SpeakMarshaller;
import com.threerings.crowd.data.BodyMarshaller;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.LocationMarshaller;
import com.threerings.crowd.data.LocationMarshaller.MoveMarshaller;
import com.threerings.crowd.data.OccupantInfo;
import com.threerings.crowd.data.Place;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.io.ArrayMask;
import com.threerings.presents.client.InvocationReceiver.Registration;
import com.threerings.presents.data.InvocationMarshaller;
import com.threerings.presents.data.InvocationMarshaller.ConfirmMarshaller;
import com.threerings.presents.data.InvocationMarshaller.ListenerMarshaller;
import com.threerings.presents.data.InvocationMarshaller.ResultMarshaller;
import com.threerings.presents.data.TimeBaseMarshaller;
import com.threerings.presents.data.TimeBaseMarshaller.GotTimeBaseMarshaller;
import com.threerings.presents.dobj.AttributeChangedEvent;
import com.threerings.presents.dobj.CompoundEvent;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.ElementUpdatedEvent;
import com.threerings.presents.dobj.EntryAddedEvent;
import com.threerings.presents.dobj.EntryRemovedEvent;
import com.threerings.presents.dobj.EntryUpdatedEvent;
import com.threerings.presents.dobj.InvocationNotificationEvent;
import com.threerings.presents.dobj.InvocationRequestEvent;
import com.threerings.presents.dobj.InvocationResponseEvent;
import com.threerings.presents.dobj.ObjectAddedEvent;
import com.threerings.presents.dobj.ObjectDestroyedEvent;
import com.threerings.presents.dobj.ObjectRemovedEvent;
import com.threerings.presents.net.AuthRequest;
import com.threerings.presents.net.AuthResponse;
import com.threerings.presents.net.AuthResponseData;
import com.threerings.presents.net.BootstrapData;
import com.threerings.presents.net.BootstrapNotification;
import com.threerings.presents.net.CompoundDownstreamMessage;
import com.threerings.presents.net.CompoundUpstreamMessage;
import com.threerings.presents.net.EventNotification;
import com.threerings.presents.net.FailureResponse;
import com.threerings.presents.net.ForwardEventRequest;
import com.threerings.presents.net.LogoffRequest;
import com.threerings.presents.net.LogoffResponse;
import com.threerings.presents.net.ObjectResponse;
import com.threerings.presents.net.PingRequest;
import com.threerings.presents.net.PongResponse;
import com.threerings.presents.net.SessionCredentials;
import com.threerings.presents.net.SubscribeRequest;
import com.threerings.presents.net.UnsubscribeRequest;
import com.threerings.presents.net.UnsubscribeResponse;
import com.threerings.presents.net.UsernamePasswordCreds;
import com.threerings.util.Name;

public class ProtobufHelper {
	private static boolean registed = false;
	public static void registType() {
		if(registed) return;
		registed = true;	
		
		ProtobufRegistry.regist(51, Name.class,com.hexnova.narya.util.Name.class);
		ProtobufRegistry.regist(53, ArrayMask.class,com.hexnova.narya.util.ArrayMask.class);
		//1.由客户端发起的数据包：
		ProtobufRegistry.regist(101, CompoundUpstreamMessage.class,com.hexnova.narya.net.CompoundUpstreamMessage.class);
		ProtobufRegistry.regist(102, ForwardEventRequest.class,com.hexnova.narya.net.ForwardEventRequest.class);
		ProtobufRegistry.regist(103, LogoffRequest.class,com.hexnova.narya.net.LogoffRequest.class);
		ProtobufRegistry.regist(104, AuthRequest.class,com.hexnova.narya.net.AuthRequest.class);
		ProtobufRegistry.regist(105, PingRequest.class,com.hexnova.narya.net.PingRequest.class);
		ProtobufRegistry.regist(106, SubscribeRequest.class,com.hexnova.narya.net.SubscribeRequest.class);
		ProtobufRegistry.regist(107, UnsubscribeRequest.class,com.hexnova.narya.net.UnsubscribeRequest.class);
		
		
		//2.由服务端反馈的数据包：
		ProtobufRegistry.regist(201, AuthResponse.class,com.hexnova.narya.net.AuthResponse.class);
		ProtobufRegistry.regist(202, BootstrapNotification.class,com.hexnova.narya.net.BootstrapNotification.class);
		ProtobufRegistry.regist(203, CompoundDownstreamMessage.class,com.hexnova.narya.net.CompoundDownstreamMessage.class);
		ProtobufRegistry.regist(204, EventNotification.class,com.hexnova.narya.net.EventNotification.class);
		ProtobufRegistry.regist(205, LogoffResponse.class,com.hexnova.narya.net.LogoffResponse.class);
		ProtobufRegistry.regist(206, FailureResponse.class,com.hexnova.narya.net.FailureResponse.class);
		ProtobufRegistry.regist(207, ObjectResponse.class,com.hexnova.narya.net.ObjectResponse.class);
		ProtobufRegistry.regist(208, PongResponse.class,com.hexnova.narya.net.PongResponse.class);
		ProtobufRegistry.regist(209, UnsubscribeResponse.class,com.hexnova.narya.net.UnsubscribeResponse.class);
		ProtobufRegistry.regist(210, AuthResponseData.class,com.hexnova.narya.net.AuthResponseData.class);
		
		
		//3.其他公共数据结构
		ProtobufRegistry.regist(301, BootstrapData.class,com.hexnova.narya.net.BootstrapData.class);
		ProtobufRegistry.regist(303, BodyObject.class,com.hexnova.narya.data.BodyObject.class);
		ProtobufRegistry.regist(304, SessionCredentials.class,com.hexnova.narya.net.SessionCredentials.class);
		ProtobufRegistry.regist(305, UsernamePasswordCreds.class, com.hexnova.narya.net.UsernamePasswordCredentials.class);
		ProtobufRegistry.regist(306, Registration.class, com.hexnova.narya.data.InvocationReceiverRegistration.class);
		
		//注册基础数据类型
		ProtobufRegistry.regist(307, DSet.class,com.hexnova.narya.util.DSet.class);
		ProtobufRegistry.regist(308, OccupantInfo.class,com.hexnova.narya.data.OccupantInfo.class);
		ProtobufRegistry.regist(309, Place.class, com.hexnova.narya.data.Place.class);
		ProtobufRegistry.regist(310, PlaceObject.class, com.hexnova.narya.data.PlaceObject.class);
		//4.Event数据结构
		ProtobufRegistry.regist(401, CompoundEvent.class,com.hexnova.narya.event.data.CompoundEvent.class);
		ProtobufRegistry.regist(402, AttributeChangedEvent.class,com.hexnova.narya.event.data.AttributeChangedEvent.class);
		
		
		ProtobufRegistry.regist(403, EntryAddedEvent.class,com.hexnova.narya.event.data.EntryAddedEvent.class);
		ProtobufRegistry.regist(404, EntryUpdatedEvent.class,com.hexnova.narya.event.data.EntryUpdatedEvent.class);
		ProtobufRegistry.regist(405, EntryRemovedEvent.class,com.hexnova.narya.event.data.EntryRemovedEvent.class);
		ProtobufRegistry.regist(406, ObjectDestroyedEvent.class,com.hexnova.narya.event.data.ObjectDestroyedEvent.class);
		ProtobufRegistry.regist(407, ObjectRemovedEvent.class,com.hexnova.narya.event.data.ObjectRemovedEvent.class);
		ProtobufRegistry.regist(408, InvocationRequestEvent.class,com.hexnova.narya.event.data.InvocationRequestEvent.class);
		ProtobufRegistry.regist(409, InvocationResponseEvent.class,com.hexnova.narya.event.data.InvocationResponseEvent.class);
		ProtobufRegistry.regist(410, InvocationNotificationEvent.class,com.hexnova.narya.event.data.InvocationNotificationEvent.class);
		
		ProtobufRegistry.regist(412, ElementUpdatedEvent.class,com.hexnova.narya.event.data.ElementUpdatedEvent.class);
		ProtobufRegistry.regist(413, ObjectAddedEvent.class,com.hexnova.narya.event.data.ObjectAddedEvent.class);
		
		
		//5.场景相关的数据结构
		//ProtocolMessageRegistry.regist(501, SceneDeltaEvent.class);
		//ProtocolMessageRegistry.regist(502, DamageEvent.class);
		
		//6.注册服务类型
		ProtobufRegistry.regist(601, InvocationMarshaller.class,com.hexnova.narya.net.InvocationMarshaller.class);
		ProtobufRegistry.regist(602, AdminMarshaller.class,com.hexnova.narya.net.AdminMarshaller.class);
		ProtobufRegistry.regist(603, BodyMarshaller.class,com.hexnova.narya.net.BodyMarshaller.class);
		ProtobufRegistry.regist(604, ChannelSpeakMarshaller.class,com.hexnova.narya.net.ChannelSpeakMarshaller.class);
		ProtobufRegistry.regist(605, ChatMarshaller.class,com.hexnova.narya.net.ChatMarshaller.class);
		ProtobufRegistry.regist(606, SpeakMarshaller.class,com.hexnova.narya.net.SpeakMarshaller.class);
		ProtobufRegistry.regist(607, TimeBaseMarshaller.class,com.hexnova.narya.net.TimeBaseMarshaller.class);
		ProtobufRegistry.regist(608, LocationMarshaller.class,com.hexnova.narya.net.LocationMarshaller.class);
		
		ProtobufRegistry.regist(1601, ListenerMarshaller.class,com.hexnova.narya.net.ListenerMarshaller.class);
		ProtobufRegistry.regist(1602, ConfirmMarshaller.class,com.hexnova.narya.net.ListenerMarshaller.class);
		ProtobufRegistry.regist(1603, ResultMarshaller.class,com.hexnova.narya.net.ListenerMarshaller.class);
		ProtobufRegistry.regist(1604, MoveMarshaller.class,com.hexnova.narya.net.ListenerMarshaller.class);
		ProtobufRegistry.regist(1605, GotTimeBaseMarshaller.class,com.hexnova.narya.net.ListenerMarshaller.class);
		ProtobufRegistry.regist(1606, TellMarshaller.class,com.hexnova.narya.net.ListenerMarshaller.class);
		
		
	}
	
	private ProtobufHelper() {}
}
