package com.threerings.protobuf.io;

public class ByteArrayInputStream extends java.io.ByteArrayInputStream {

	protected ByteArrayInputStream(byte[] array) {
		super(array);
	}
	
	public ByteArrayInputStream(byte buf[], int offset, int length) {
		super(buf,offset,length);
	}
	
	public void setInput(byte[] array) {
		this.buf = array;
		this.pos = 0;
		this.mark = 0;
        this.count = buf.length;
	}
	
	public void setInput(byte[] array,int offset, int length) {
		this.buf = array;
		this.pos = offset;
        this.count = Math.min(offset + length, buf.length);
        this.mark = offset;
	}
}
