//
// $Id$
//
// Narya library - tools for developing networked games
// Copyright (C) 2002-2012 Three Rings Design, Inc., All Rights Reserved
// http://code.google.com/p/narya/
//
// This library is free software; you can redistribute it and/or modify it
// under the terms of the GNU Lesser General Public License as published
// by the Free Software Foundation; either version 2.1 of the License, or
// (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Lesser General Public License for more details.
//
// You should have received a copy of the GNU Lesser General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA

package com.threerings.presents.net;

import java.io.IOException;
import java.util.List;

import com.google.common.collect.Lists;
import com.google.protobuf.Message.Builder;
import com.hexnova.narya.util.AnyMessage;
import com.threerings.io.SimpleStreamableObject;

import com.threerings.presents.data.InvocationMarshaller;
import com.threerings.protobuf.io.ProtobufProvider;
import com.threerings.protobuf.io.ProtobufRegistry;

/**
 * A <code>BootstrapData</code> object is communicated back to the client after authentication has
 * succeeded and after the server is fully prepared to deal with the client. It contains
 * information the client will need to interact with the server.
 */
public class BootstrapData extends SimpleStreamableObject implements ProtobufProvider<com.hexnova.narya.net.BootstrapData>
{
    /** The unique id of the client's connection (used to address datagrams). */
    public int connectionId;

    /** The oid of this client's associated distributed object. */
    public int clientOid;

    /** server side time zone ID */
    public String timeZoneID;
    
    /** A list of handles to invocation services. */
    public List<InvocationMarshaller<?>> services;

	@Override
	public void populate(com.hexnova.narya.net.BootstrapData message) throws IOException {
		this.connectionId = message.getConnectionId();
		this.clientOid = message.getClientOid();
		this.timeZoneID = message.getTimeZoneID();
		if(message.getServicesCount()>0) {
			services = Lists.newArrayList();
			for(AnyMessage any : message.getServicesList()) {
				services.add((InvocationMarshaller<?>)ProtobufRegistry.fromAnyMessage(any));
			}
		}
	}

	@Override
	public com.hexnova.narya.net.BootstrapData transform() throws IOException {
		com.hexnova.narya.net.BootstrapData.Builder builder = getBuilder();
		builder.setConnectionId(connectionId);
		builder.setClientOid(clientOid);
		builder.setTimeZoneID(timeZoneID);
		if(services != null) {
			for(InvocationMarshaller marshaller : services) {
				builder.addServices(ProtobufRegistry.toAnyMessage(marshaller));
			}
		}
		return builder.build();
	}

	@Override
	public  com.hexnova.narya.net.BootstrapData.Builder getBuilder() {
		if(builder == null) {
			builder = com.hexnova.narya.net.BootstrapData.newBuilder();
		}
		return builder;
	}
	
	private transient com.hexnova.narya.net.BootstrapData.Builder builder = null;
}
