/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.util;

import com.samskivert.util.ArrayUtil;
import com.samskivert.util.Invoker;
import com.threerings.presents.Log;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.data.InvocationException;

public abstract class PersistingUnit
extends Invoker.Unit {
    protected InvocationService.InvocationListener _listener;
    protected Exception _error;
    protected Object[] _args;
    protected boolean _resultSet;
    protected Object _result;

    public PersistingUnit(InvocationService.InvocationListener listener) {
        this("UnknownPersistingUnit", listener);
    }

    public PersistingUnit(String name, InvocationService.InvocationListener listener) {
        super(name);
        this._listener = listener;
    }

    public PersistingUnit(String name, InvocationService.InvocationListener listener, Object ... args) {
        super(name);
        if (args != null && args.length % 2 == 1) {
            throw new IllegalArgumentException("Missing key or value in key/value pair arguments.");
        }
        this._listener = listener;
        this._args = args;
    }

    public abstract void invokePersistent() throws Exception;

    public void handleSuccess() {
        if (this._listener instanceof InvocationService.ConfirmListener) {
            this.reportRequestProcessed();
        } else if (this._listener instanceof InvocationService.ResultListener && this._resultSet) {
            this.reportRequestProcessed(this._result);
        }
    }

    public void handleFailure(Exception error) {
        if (error instanceof InvocationException) {
            this._listener.requestFailed(error.getMessage());
        } else {
            if (this._args != null) {
                Log.log.warning((Object)this.getFailureMessage(), ArrayUtil.append((Object[])this._args, (Object)error));
            } else {
                Log.log.warning((Object)this.getFailureMessage(), new Object[]{error});
            }
            this._listener.requestFailed("m.internal_error");
        }
    }

    public boolean invoke() {
        try {
            this.invokePersistent();
        }
        catch (Exception pe) {
            this._error = pe;
        }
        return true;
    }

    public void handleResult() {
        if (this._error != null) {
            this.handleFailure(this._error);
        } else {
            this.handleSuccess();
        }
    }

    protected void reportRequestProcessed() {
        ((InvocationService.ConfirmListener)this._listener).requestProcessed();
    }

    protected void reportRequestProcessed(Object result) {
        ((InvocationService.ResultListener)this._listener).requestProcessed(result);
    }

    protected String getFailureMessage() {
        return (Object)((Object)this) + " failed.";
    }

    protected void setResult(Object result) {
        this._resultSet = true;
        this._result = result;
    }
}

