/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.net;

import com.samskivert.util.HashIntMap;

public class Transport {
    public static final Transport UNRELIABLE_UNORDERED = Transport.getInstance(Type.UNRELIABLE_UNORDERED);
    public static final Transport UNRELIABLE_ORDERED = Transport.getInstance(Type.UNRELIABLE_ORDERED, 0);
    public static final Transport RELIABLE_UNORDERED = Transport.getInstance(Type.RELIABLE_UNORDERED);
    public static final Transport RELIABLE_ORDERED;
    public static final Transport DEFAULT;
    protected Type _type;
    protected int _channel;
    protected static Transport[] _unordered;
    protected static HashIntMap<Transport>[] _ordered;

    public static Transport getInstance(Type type) {
        return Transport.getInstance(type, 0);
    }

    public static Transport getInstance(Type type, int channel) {
        Transport instance;
        if (_unordered == null) {
            int length = Type.values().length;
            _unordered = new Transport[length];
            HashIntMap[] ordered = new HashIntMap[length];
            _ordered = ordered;
        }
        int idx = type.ordinal();
        if (!type.isOrdered()) {
            Transport instance2 = _unordered[idx];
            if (instance2 == null) {
                Transport._unordered[idx] = instance2 = new Transport(type);
            }
            return instance2;
        }
        HashIntMap instances = _ordered[idx];
        if (instances == null) {
            Transport._ordered[idx] = instances = new HashIntMap();
        }
        if ((instance = (Transport)instances.get(channel)) == null) {
            instance = new Transport(type, channel);
            instances.put(channel, (Object)instance);
        }
        return instance;
    }

    public Type getType() {
        return this._type;
    }

    public int getChannel() {
        return this._channel;
    }

    public boolean isReliable() {
        return this._type.isReliable();
    }

    public boolean isOrdered() {
        return this._type.isOrdered();
    }

    public Transport combine(Transport other) {
        return Transport.getInstance(this._type.combine(other._type), this._channel == other._channel ? this._channel : 0);
    }

    public int hashCode() {
        return 31 * this._type.hashCode() + this._channel;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (!(other instanceof Transport)) return false;
        Transport otrans = (Transport)other;
        if (otrans._type != this._type) return false;
        if (otrans._channel != this._channel) return false;
        return true;
    }

    public String toString() {
        return "[type=" + (Object)((Object)this._type) + ", channel=" + this._channel + "]";
    }

    protected Transport(Type type) {
        this(type, 0);
    }

    protected Transport(Type type, int channel) {
        this._type = type;
        this._channel = channel;
    }

    static {
        DEFAULT = RELIABLE_ORDERED = Transport.getInstance(Type.RELIABLE_ORDERED, 0);
    }

    public static enum Type {
        UNRELIABLE_UNORDERED(false, false){

            @Override
            public Type combine(Type other) {
                return other;
            }
        }
        ,
        UNRELIABLE_ORDERED(false, true){

            @Override
            public Type combine(Type other) {
                return other.isReliable() ? RELIABLE_ORDERED : this;
            }
        }
        ,
        RELIABLE_UNORDERED(true, false){

            @Override
            public Type combine(Type other) {
                return other.isOrdered() ? RELIABLE_ORDERED : this;
            }
        }
        ,
        RELIABLE_ORDERED(true, true){

            @Override
            public Type combine(Type other) {
                return this;
            }
        };

        protected boolean _reliable;
        protected boolean _ordered;

        public boolean isReliable() {
            return this._reliable;
        }

        public boolean isOrdered() {
            return this._ordered;
        }

        public abstract Type combine(Type var1);

        private Type(boolean reliable, boolean ordered) {
            this._reliable = reliable;
            this._ordered = ordered;
        }
    }
}

