/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.net;

import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.presents.Log;
import com.threerings.presents.net.DownstreamMessage;
import com.threerings.presents.net.Transport;
import java.io.IOException;

public class PongResponse
extends DownstreamMessage {
    protected transient long _pingStamp;
    protected long _packStamp;
    protected int _processDelay;
    protected transient long _unpackStamp;
    protected transient Transport _transport = Transport.DEFAULT;

    public PongResponse() {
    }

    public PongResponse(long pingStamp, Transport transport) {
        this._pingStamp = pingStamp;
        this._transport = transport;
    }

    public long getPackStamp() {
        return this._packStamp;
    }

    public int getProcessDelay() {
        return this._processDelay;
    }

    public long getUnpackStamp() {
        return this._unpackStamp;
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        this._packStamp = System.currentTimeMillis();
        if (this._pingStamp == 0L) {
            Log.log.warning((Object)"Pong response written that was not constructed with a valid ping stamp", new Object[]{"rsp", this});
            this._processDelay = 0;
        } else {
            this._processDelay = (int)(this._packStamp - this._pingStamp);
        }
        out.defaultWriteObject();
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this._unpackStamp = System.currentTimeMillis();
        in.defaultReadObject();
    }

    @Override
    public void setTransport(Transport transport) {
        this._transport = transport;
    }

    @Override
    public Transport getTransport() {
        return this._transport;
    }

    @Override
    public String toString() {
        return "[type=PONG, msgid=" + this.messageId + ", transport=" + this._transport + "]";
    }
}

