/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.threerings.crowd.Log;
import com.threerings.crowd.client.LocationService;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.LocationCodes;
import com.threerings.crowd.data.LocationMarshaller;
import com.threerings.crowd.data.Place;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.server.BodyLocator;
import com.threerings.crowd.server.LocationProvider;
import com.threerings.crowd.server.LocationSender;
import com.threerings.crowd.server.PlaceManager;
import com.threerings.crowd.server.PlaceRegistry;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.data.InvocationException;
import com.threerings.presents.dobj.RootDObjectManager;
import com.threerings.presents.server.ClientManager;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.PresentsSession;

@Singleton
public class LocationManager
implements LocationProvider,
LocationCodes {
    @Inject
    protected RootDObjectManager _omgr;
    @Inject
    protected BodyLocator _locator;
    @Inject
    protected ClientManager _clmgr;
    @Inject
    protected PlaceRegistry _plreg;

    @Inject
    public LocationManager(InvocationManager invmgr) {
        invmgr.registerProvider(this, LocationMarshaller.class, "crowd");
    }

    @Override
    public void moveTo(ClientObject caller, int placeOid, LocationService.MoveListener listener) throws InvocationException {
        BodyObject body = this._locator.forClient(caller);
        listener.moveSucceeded(this.moveTo(body, placeOid));
    }

    @Override
    public void leavePlace(ClientObject caller) {
        BodyObject body = this._locator.forClient(caller);
        this.leaveOccupiedPlace(body);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PlaceConfig moveTo(BodyObject source, int placeOid) throws InvocationException {
        PlaceManager pmgr = this._plreg.getPlaceManager(placeOid);
        if (pmgr == null) {
            Log.log.info((Object)"Requested to move to non-existent place", new Object[]{"who", source.who(), "placeOid", placeOid});
            throw new InvocationException("m.no_such_place");
        }
        Place place = pmgr.getLocation();
        if (place.equals(source.location)) {
            Log.log.debug((Object)"Going along with client request to move to where they already are", new Object[]{"source", source.who(), "place", place});
            return pmgr.getConfig();
        }
        String errmsg = pmgr.ratifyBodyEntry(source);
        if (errmsg != null) {
            throw new InvocationException(errmsg);
        }
        if (!source.acquireLock("moveToLock")) {
            throw new InvocationException("m.move_in_progress");
        }
        PresentsSession client = this._clmgr.getClient(source.username);
        if (client != null) {
            client.setClassLoader(pmgr.getClass().getClassLoader());
        }
        try {
            source.startTransaction();
            try {
                this.leaveOccupiedPlace(source);
                pmgr.bodyWillEnter(source);
                source.willEnterPlace(place, pmgr.getPlaceObject());
            }
            finally {
                source.commitTransaction();
            }
        }
        finally {
            source.releaseLock("moveToLock");
        }
        return pmgr.getConfig();
    }

    public void leaveOccupiedPlace(BodyObject source) {
        Place oldloc = source.location;
        if (oldloc == null) {
            return;
        }
        PlaceManager pmgr = this._plreg.getPlaceManager(oldloc.placeOid);
        if (pmgr == null) {
            Log.log.warning((Object)"Body requested to leave no longer existent place?", new Object[]{"boid", source.getOid(), "place", oldloc});
            return;
        }
        pmgr.bodyWillLeave(source);
        source.didLeavePlace(pmgr.getPlaceObject());
    }

    public void moveBody(BodyObject source, Place place) {
        this.leaveOccupiedPlace(source);
        LocationSender.forcedMove(source.getClientObject(), place.placeOid);
    }
}

