/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.data;

import com.samskivert.util.StringUtil;
import com.threerings.crowd.Log;
import com.threerings.crowd.client.PlaceController;
import com.threerings.io.SimpleStreamableObject;
import com.threerings.util.ActionScript;

public abstract class PlaceConfig
extends SimpleStreamableObject {
    public String getControllerClassName() {
        return null;
    }

    public PlaceController createController() {
        try {
            Class<?> cclass = Class.forName(this.getControllerClassName());
            if (cclass == null) {
                throw new RuntimeException("PlaceConfig.createController() must be overridden or getControllerClassName() cannot be null.");
            }
            return (PlaceController)((Object)cclass.newInstance());
        }
        catch (Exception e) {
            Log.log.warning((Object)("Failed to instantiate controller class getControllerClassName='" + this.getControllerClassName() + "'."), new Object[]{e});
            return null;
        }
    }

    public abstract String getManagerClassName();

    @Override
    @ActionScript(name="toStringBuilder")
    protected void toString(StringBuilder buf) {
        buf.append("type=").append(StringUtil.shortClassName((Object)this));
        buf.append(", ");
        super.toString(buf);
    }
}

