/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.admin.client;

import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.samskivert.swing.ObjectEditorTable;
import com.samskivert.util.Logger;
import com.samskivert.util.QuickSort;
import com.samskivert.util.StringUtil;
import com.threerings.admin.client.DSetEditor;
import com.threerings.presents.dobj.AttributeChangeListener;
import com.threerings.presents.dobj.AttributeChangedEvent;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.EntryAddedEvent;
import com.threerings.presents.dobj.EntryRemovedEvent;
import com.threerings.presents.dobj.EntryUpdatedEvent;
import com.threerings.presents.dobj.SetListener;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Set;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class TabbedDSetEditor<E extends DSet.Entry>
extends JPanel
implements AttributeChangeListener,
SetListener<E> {
    protected final DObject _setter;
    protected final String _setName;
    protected final Class<?> _entryClass;
    protected final String[] _editableFields;
    protected final ObjectEditorTable.FieldInterpreter _interp;
    protected final EntryGrouper<E> _grouper;
    protected AccessorFactory _accessorFactory;
    protected JTabbedPane _tabs;
    protected HashMap<String, DSetEditor<E>> _editors = Maps.newHashMap();

    public TabbedDSetEditor(DObject setter, String setName, Class<?> entryClass, String[] editableFields, ObjectEditorTable.FieldInterpreter interp, String groupField) {
        this(setter, setName, entryClass, editableFields, interp, new FieldGrouper(groupField, entryClass));
    }

    public TabbedDSetEditor(DObject setter, String setName, Class<?> entryClass, String[] editableFields, ObjectEditorTable.FieldInterpreter interp, EntryGrouper<E> grouper) {
        this._setter = setter;
        this._setName = setName;
        this._entryClass = entryClass;
        this._editableFields = editableFields;
        this._interp = interp;
        this._grouper = grouper;
        this._tabs = new JTabbedPane();
        this.add(this._tabs);
    }

    public void setAccessorFactory(AccessorFactory accessorFactory) {
        this._accessorFactory = accessorFactory;
    }

    protected void computeTabs() {
        String[] groups;
        this._grouper.computeGroups(this._setter.getSet(this._setName));
        for (String group : groups = this._grouper.getAllGroups()) {
            if (this._editors.containsKey(group)) continue;
            DSetEditor<E> editor = this.createEditor(this._setter, this._setName, this._entryClass, this._editableFields, this._interp, this._grouper, group);
            if (this._accessorFactory != null) {
                editor.setAccessor(this._accessorFactory.createAccessor(editor));
            }
            this._tabs.add(group, editor);
            this._editors.put(group, editor);
        }
    }

    protected DSetEditor<E> createEditor(DObject setter, String setName, Class<?> entryClass, String[] editableFields, ObjectEditorTable.FieldInterpreter interp, EntryGrouper<E> grouper, String group) {
        return new DSetEditor<E>(setter, setName, entryClass, editableFields, interp, this.getDisplayFields(group), grouper.getPredicate(group));
    }

    protected String[] getDisplayFields(String group) {
        return null;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._setter.addListener(this);
        this.computeTabs();
    }

    @Override
    public void removeNotify() {
        this._setter.removeListener(this);
        super.removeNotify();
    }

    @Override
    public void attributeChanged(AttributeChangedEvent event) {
        if (event.getName().equals(this._setName)) {
            this.computeTabs();
        }
    }

    @Override
    public void entryAdded(EntryAddedEvent<E> event) {
        if (event.getName().equals(this._setName)) {
            this.computeTabs();
        }
    }

    @Override
    public void entryRemoved(EntryRemovedEvent<E> event) {
        if (event.getName().equals(this._setName)) {
            this.computeTabs();
        }
    }

    @Override
    public void entryUpdated(EntryUpdatedEvent<E> event) {
        if (event.getName().equals(this._setName)) {
            this.computeTabs();
        }
    }

    public static class FieldGrouper<E extends DSet.Entry>
    extends EntryGrouper<E> {
        protected final Field _field;

        public FieldGrouper(String fieldName, Class<?> entryClass) {
            try {
                this._field = entryClass.getField(fieldName);
            }
            catch (NoSuchFieldException nsfe) {
                throw new IllegalArgumentException(Logger.format((Object)"Group field not found in prototype class!", (Object[])new Object[]{"proto", entryClass, "groupField", fieldName}));
            }
        }

        @Override
        protected String[] computeGroups(E entry) {
            try {
                return new String[]{StringUtil.toString((Object)this._field.get(entry))};
            }
            catch (IllegalAccessException iae) {
                return new String[]{"<bogus>"};
            }
        }
    }

    public static abstract class EntryGrouper<E extends DSet.Entry> {
        protected Set<String> _allGroups = Sets.newHashSet();
        protected static final Comparator<Object> LEXICAL_CASE_INSENSITIVE = Ordering.from((Comparator)String.CASE_INSENSITIVE_ORDER).onResultOf(Functions.toStringFunction()).nullsLast();

        protected abstract String[] computeGroups(E var1);

        protected Predicate<E> getPredicate(final String group) {
            return new Predicate<E>(){

                public boolean apply(E entry) {
                    String[] groups;
                    for (String g : groups = EntryGrouper.this.computeGroups(entry)) {
                        if (!g.equals(group)) continue;
                        return true;
                    }
                    return false;
                }
            };
        }

        public void computeGroups(Iterable<E> entries) {
            for (DSet.Entry entry : entries) {
                String[] groups;
                for (String group : groups = this.computeGroups(entry)) {
                    this._allGroups.add(group);
                }
            }
        }

        public String[] getAllGroups() {
            Object[] list = this._allGroups.toArray(new String[this._allGroups.size()]);
            QuickSort.sort((Object[])list, this.getComparator());
            return list;
        }

        protected Comparator<Object> getComparator() {
            return LEXICAL_CASE_INSENSITIVE;
        }
    }

    public static interface AccessorFactory {
        public <E extends DSet.Entry> DSetEditor.Accessor<E> createAccessor(DSetEditor<E> var1);
    }
}

