/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server.net;

import com.threerings.io.ObjectInputStream;
import com.threerings.presents.Log;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.ClientObjectInputStream;
import com.threerings.presents.client.ClientObserver;
import com.threerings.presents.client.Communicator;
import com.threerings.presents.client.ObserverOps;
import com.threerings.presents.client.SessionObserver;
import com.threerings.presents.dobj.RootDObjectManager;
import com.threerings.presents.net.AuthRequest;
import com.threerings.presents.net.AuthResponse;
import com.threerings.presents.net.AuthResponseData;
import com.threerings.presents.net.LogoffRequest;
import com.threerings.presents.net.Message;
import com.threerings.presents.net.PingRequest;
import com.threerings.presents.net.PongResponse;
import com.threerings.presents.net.UpstreamMessage;
import com.threerings.presents.server.net.PresentsConnection;
import com.threerings.presents.server.net.PresentsConnectionManager;
import java.io.IOException;
import java.io.InputStream;

public class ServerCommunicator
extends Communicator {
    protected PresentsConnectionManager _conmgr;
    protected RootDObjectManager _rootmgr;
    protected PresentsConnection _conn;
    protected ClassLoader _loader;
    protected Exception _logonError;
    protected static final boolean PING_DEBUG = Boolean.getBoolean("ping_debug");

    public ServerCommunicator(Client client, PresentsConnectionManager conmgr, RootDObjectManager rootmgr) {
        super(client);
        this._conmgr = conmgr;
        this._rootmgr = rootmgr;
    }

    @Override
    public void logon() {
        if (this._conn != null) {
            throw new RuntimeException("Communicator already started.");
        }
        try {
            PresentsConnection conn = new PresentsConnection(){

                @Override
                public void postMessage(Message msg) {
                    super.postMessage(msg);
                    this._lastEvent = System.currentTimeMillis();
                    if (PING_DEBUG && msg instanceof PingRequest) {
                        Log.log.info((Object)("Pinging on server comm " + msg), new Object[0]);
                    }
                }

                @Override
                public void connectFailure(IOException ioe) {
                    ServerCommunicator.this._logonError = ioe;
                    super.connectFailure(ioe);
                }

                @Override
                public void networkFailure(final IOException ioe) {
                    ServerCommunicator.this.notifyClientObservers(new ObserverOps.Client(ServerCommunicator.this._client){

                        @Override
                        protected void notify(ClientObserver obs) {
                            obs.clientConnectionFailed(this._client, ioe);
                        }
                    });
                    super.networkFailure(ioe);
                }

                @Override
                protected ObjectInputStream createObjectInputStream(InputStream src) {
                    return new ClientObjectInputStream(ServerCommunicator.this._client, src);
                }

                @Override
                protected void closeSocket() {
                    super.closeSocket();
                    ServerCommunicator.this.shutdown();
                }
            };
            conn.setMessageHandler(new PresentsConnection.MessageHandler(){

                @Override
                public void handleMessage(Message message) {
                    try {
                        ServerCommunicator.this.gotAuthResponse((AuthResponse)message);
                    }
                    catch (Exception e) {
                        ServerCommunicator.this._logonError = e;
                        ServerCommunicator.this.shutdown();
                    }
                }
            });
            this._conmgr.openOutgoingConnection(conn, this._client.getHostname(), this._client.getPorts()[0]);
            this._conn = conn;
            if (this._loader != null) {
                this._conn.setClassLoader(this._loader);
            }
            this.postMessage(new AuthRequest(this._client.getCredentials(), this._client.getVersion(), this._client.getBootGroups()));
        }
        catch (IOException ioe) {
            this._logonError = ioe;
            this.shutdown();
        }
    }

    @Override
    public void logoff() {
        this.isLogoned = false;
        if (this._conn != null) {
            this._conn.postMessage(new LogoffRequest());
            this._conn.asyncClose();
            this._conn = null;
        }
    }

    @Override
    public void gotBootstrap() {
    }

    @Override
    public void postMessage(final UpstreamMessage msg) {
        if (!this._rootmgr.isDispatchThread()) {
            this._rootmgr.postRunnable(new Runnable(){

                @Override
                public void run() {
                    ServerCommunicator.this.postMessage(msg);
                }
            });
            return;
        }
        if (this._conn == null) {
            Log.log.info((Object)"Dropping message for lack of connection.", new Object[]{"client", this._client, "msg", msg});
            return;
        }
        this._conn.postMessage(msg);
        this.updateWriteStamp();
    }

    @Override
    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
        if (this._conn != null) {
            this._conn.setClassLoader(loader);
        }
    }

    @Override
    protected synchronized void logonSucceeded(AuthResponseData data) {
        super.logonSucceeded(data);
        this._conn.setMessageHandler(new PresentsConnection.MessageHandler(){

            @Override
            public void handleMessage(Message message) {
                if (PING_DEBUG && message instanceof PongResponse) {
                    Log.log.info((Object)("Got pong from server " + message), new Object[0]);
                }
                ServerCommunicator.this.processMessage(message);
            }
        });
    }

    protected void shutdown() {
        if (this._logonError == null) {
            this.notifyClientObservers(new ObserverOps.Session(this._client){

                @Override
                protected void notify(SessionObserver obs) {
                    obs.clientDidLogoff(this._client);
                }
            });
        }
        this.clientCleanup(this._logonError);
    }
}

