/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server.net;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.samskivert.net.AddressUtil;
import com.samskivert.util.Lifecycle;
import com.threerings.nio.conman.NetEventHandler;
import com.threerings.presents.Log;
import com.threerings.presents.server.net.PresentsConnectionManager;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.channels.DatagramChannel;
import java.util.List;

public class DatagramChannelReader
implements Lifecycle.ShutdownComponent {
    protected final int[] _datagramPorts;
    protected final String _datagramHostname;
    protected final List<DatagramChannel> _datagramChannels = Lists.newArrayList();
    protected final PresentsConnectionManager _conMan;

    public DatagramChannelReader(String datagramHostname, int[] datagramPorts, PresentsConnectionManager conMgr) {
        Preconditions.checkNotNull((Object)datagramPorts, (Object)"Datagram ports must be non-null. Pass a zero-length array to bind no datagram ports.");
        this._datagramHostname = datagramHostname;
        this._datagramPorts = datagramPorts;
        this._conMan = conMgr;
    }

    public void bind() {
        for (int port : this._datagramPorts) {
            try {
                this.acceptDatagrams(port);
            }
            catch (IOException ioe) {
                Log.log.warning((Object)"Failure opening datagram channel", new Object[]{"hostname", this._datagramHostname, "port", port, ioe});
            }
        }
    }

    public void shutdown() {
        for (DatagramChannel datagramChannel : this._datagramChannels) {
            datagramChannel.socket().close();
        }
    }

    protected void acceptDatagrams(int port) throws IOException {
        final DatagramChannel channel = DatagramChannel.open();
        channel.socket().setTrafficClass(16);
        channel.configureBlocking(false);
        InetSocketAddress isa = AddressUtil.getAddress((String)this._datagramHostname, (int)port);
        channel.socket().bind(isa);
        this._conMan.register(channel, 1, new NetEventHandler(){

            @Override
            public int handleEvent(long when) {
                return DatagramChannelReader.this._conMan.handleDatagram(channel, when);
            }

            @Override
            public boolean checkIdle(long idleStamp) {
                return false;
            }

            @Override
            public void becameIdle() {
            }
        });
        this._datagramChannels.add(channel);
        Log.log.info((Object)("Server accepting datagrams on " + isa + "."), new Object[0]);
    }
}

