/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.util.Invoker;
import com.samskivert.util.Lifecycle;
import com.threerings.presents.Log;
import com.threerings.presents.server.PresentsDObjectMgr;
import com.threerings.presents.server.PresentsServer;
import com.threerings.presents.server.ReportManager;
import com.threerings.presents.server.ReportingInvoker;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

@Singleton
public class PresentsInvoker
extends ReportingInvoker
implements Lifecycle.ShutdownComponent {
    protected Object _checkMonitor = new Object();
    protected List<Invoker> _interdependentInvokers = Lists.newArrayList();
    protected PresentsDObjectMgr _omgr;
    @Inject
    protected PresentsServer _server;

    @Inject
    public PresentsInvoker(PresentsDObjectMgr omgr, Lifecycle cycle, ReportManager repmgr) {
        super("presents.Invoker", omgr, repmgr);
        cycle.addComponent((Lifecycle.BaseComponent)this);
        this._omgr = omgr;
    }

    public void addInterdependentInvoker(Invoker invoker) {
        this._interdependentInvokers.add(invoker);
    }

    public void postRunnableWhenEmpty(Runnable onEmpty) {
        this.postUnit(new EmptyingUnit(onEmpty));
    }

    public void shutdown() {
        this.postRunnableWhenEmpty(new Runnable(){

            @Override
            public void run() {
                PresentsInvoker.this._omgr.harshShutdown();
                PresentsInvoker.super.shutdown();
            }
        });
    }

    protected void didShutdown() {
        this._server.invokerDidShutdown();
    }

    protected class BlockingUnit
    extends Invoker.Unit
    implements PresentsDObjectMgr.LongRunnable {
        public boolean run;
        public boolean released;
        protected Invoker _invoker;

        public BlockingUnit() {
            PresentsInvoker.this._omgr.postRunnable(this);
        }

        public BlockingUnit(Invoker invoker) {
            this._invoker = invoker;
            this._invoker.postUnit((Invoker.Unit)this);
        }

        public boolean isEmpty() {
            return this._invoker == null ? PresentsInvoker.this._omgr.queueIsEmpty() : this._invoker.getPendingUnits() == 0;
        }

        public void post(Runnable runnable) {
            if (this._invoker != null) {
                this._invoker.postRunnable(runnable);
            } else {
                PresentsInvoker.this._omgr.postRunnable(runnable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.run = true;
            Object object = PresentsInvoker.this._checkMonitor;
            synchronized (object) {
                PresentsInvoker.this._checkMonitor.notify();
            }
            object = this;
            synchronized (object) {
                while (!this.released) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        public boolean invoke() {
            this.run();
            return false;
        }

        public long getLongThreshold() {
            return 300000L;
        }
    }

    protected class EmptyingUnit
    extends Invoker.Unit {
        protected Runnable _onEmpty;
        protected int _passCount;
        protected int _loopCount;
        protected static final int MAX_PASSES = 50;
        protected static final int MAX_LOOPS = 10000;
        protected static final long CHECK_TIMEOUT = 300000L;

        public EmptyingUnit(Runnable onEmpty) {
            this._onEmpty = onEmpty;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean invoke() {
            if (this._loopCount > 10000) {
                Log.log.warning((Object)"Emptying waiter looped on invoker 10000 times without finishing, running onEmpty while items remain in the queue.", new Object[0]);
                this._onEmpty.run();
                return false;
            }
            if (PresentsInvoker.this.getPendingUnits() > 0) {
                ++this._loopCount;
                PresentsInvoker.this.postUnit(this);
                return false;
            }
            if (++this._passCount >= 50) {
                Log.log.warning((Object)"Emptying waiter passed 50 times without finishing, running onEmpty while items remain in queue.", new Object[0]);
                this._onEmpty.run();
                return false;
            }
            this._loopCount = 0;
            ArrayList checkers = Lists.newArrayListWithCapacity((int)(PresentsInvoker.this._interdependentInvokers.size() + 1));
            for (Invoker invoker : PresentsInvoker.this._interdependentInvokers) {
                checkers.add(new BlockingUnit(invoker));
            }
            checkers.add(new BlockingUnit());
            long checkStart = System.currentTimeMillis();
            while (true) {
                Object object = PresentsInvoker.this._checkMonitor;
                synchronized (object) {
                    boolean unchecked = false;
                    for (BlockingUnit checker : checkers) {
                        if (checker.run) continue;
                        unchecked = true;
                        break;
                    }
                    if (unchecked) {
                        long timeChecking = System.currentTimeMillis() - checkStart;
                        if (timeChecking >= 300000L) {
                            Log.log.warning((Object)"Waited 5 minutes for all the blocking units to no avail.  Running onEmpty while items may remain in the queue.", new Object[0]);
                            this.releaseCheckers(checkers);
                            this._onEmpty.run();
                            return false;
                        }
                        try {
                            PresentsInvoker.this._checkMonitor.wait(300000L - timeChecking);
                        }
                        catch (InterruptedException interruptedException) {}
                    } else {
                        for (BlockingUnit checker : checkers) {
                            if (checker.isEmpty()) continue;
                            this.releaseCheckers(checkers);
                            checker.post(new Runnable(){

                                @Override
                                public void run() {
                                    PresentsInvoker.this.postUnit(EmptyingUnit.this);
                                }
                            });
                            return false;
                        }
                        this.releaseCheckers(checkers);
                        if (PresentsInvoker.this.getPendingUnits() > 0) {
                            PresentsInvoker.this.postUnit(this);
                        } else {
                            this._onEmpty.run();
                        }
                        return false;
                    }
                }
            }
        }

        public long getLongThreshold() {
            return 60000L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void releaseCheckers(List<BlockingUnit> checkers) {
            Iterator<BlockingUnit> iterator = checkers.iterator();
            while (iterator.hasNext()) {
                BlockingUnit checker;
                BlockingUnit blockingUnit = checker = iterator.next();
                synchronized (blockingUnit) {
                    checker.released = true;
                    checker.notify();
                }
            }
        }
    }
}

