/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Singleton;
import com.samskivert.util.Lifecycle;
import com.samskivert.util.ObserverList;
import com.samskivert.util.StringUtil;
import com.threerings.nio.conman.Connection;
import com.threerings.presents.Log;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.net.AuthRequest;
import com.threerings.presents.net.AuthResponse;
import com.threerings.presents.server.ClientLocal;
import com.threerings.presents.server.ClientResolutionListener;
import com.threerings.presents.server.ClientResolver;
import com.threerings.presents.server.PresentsDObjectMgr;
import com.threerings.presents.server.PresentsSession;
import com.threerings.presents.server.ReportManager;
import com.threerings.presents.server.SessionFactory;
import com.threerings.presents.server.net.AuthingConnection;
import com.threerings.presents.server.net.PresentsConnection;
import com.threerings.util.Name;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

@Singleton
public class ClientManager
implements ClientResolutionListener,
ReportManager.Reporter,
Lifecycle.Component {
    protected Injector _injector;
    protected Map<Name, PresentsSession> _usermap = Maps.newHashMap();
    protected Map<Connection, PresentsSession> _conmap = Maps.newConcurrentMap();
    protected Map<Name, ClientObject> _objmap = Maps.newHashMap();
    protected Map<Name, ClientResolver> _penders = Maps.newHashMap();
    protected List<SessionFactory> _factories = Lists.newArrayList((Object[])new SessionFactory[]{SessionFactory.DEFAULT});
    protected ObserverList<ClientObserver> _clobservers = ObserverList.newSafeInOrder();
    protected ObserverList<DetailedClientObserver> _dclobservers = ObserverList.newSafeInOrder();
    @Inject
    protected PresentsDObjectMgr _omgr;
    protected static final long SESSION_FLUSH_INTERVAL = 60000L;

    @Inject
    public ClientManager(ReportManager repmgr, Lifecycle cycle) {
        repmgr.registerReporter(this);
        cycle.addComponent((Lifecycle.BaseComponent)this);
    }

    public void setInjector(Injector injector) {
        this._injector = injector;
    }

    public void setDefaultSessionFactory(SessionFactory factory) {
        this._factories.set(this._factories.size() - 1, factory);
    }

    public void addSessionFactory(SessionFactory factory) {
        this._factories.add(0, factory);
    }

    public int getOutstandingResolutionCount() {
        return this._penders.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getClientCount() {
        Map<Name, PresentsSession> map = this._usermap;
        synchronized (map) {
            return this._usermap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<PresentsSession> getSessionsForAddress(byte[] addr) {
        ArrayList sessions = Lists.newArrayListWithExpectedSize((int)1);
        Map<Name, PresentsSession> map = this._usermap;
        synchronized (map) {
            for (PresentsSession session : this._usermap.values()) {
                InetAddress sessionAddr = session.getInetAddress();
                if (sessionAddr == null || !Arrays.equals(addr, sessionAddr.getAddress())) continue;
                sessions.add(session);
            }
        }
        return sessions;
    }

    public int getConnectionCount() {
        return this._conmap.size();
    }

    public Iterable<ClientObject> clientObjects() {
        return this._objmap.values();
    }

    public Iterator<ClientObject> enumerateClientObjects() {
        return this._objmap.values().iterator();
    }

    public void addClientObserver(ClientObserver observer) {
        this._clobservers.add((Object)observer);
        if (observer instanceof DetailedClientObserver) {
            this._dclobservers.add((Object)((DetailedClientObserver)observer));
        }
    }

    public void removeClientObserver(ClientObserver observer) {
        this._clobservers.remove((Object)observer);
        if (observer instanceof DetailedClientObserver) {
            this._dclobservers.remove((Object)((DetailedClientObserver)observer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PresentsSession getClient(Name authUsername) {
        Map<Name, PresentsSession> map = this._usermap;
        synchronized (map) {
            return this._usermap.get(authUsername);
        }
    }

    public ClientObject getClientObject(Name username) {
        return this._objmap.get(username);
    }

    public void applyToClient(Name username, final ClientOp clop) {
        this.resolveClientObject(username, new ClientResolutionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void clientResolved(Name username, ClientObject clobj) {
                try {
                    clop.apply(clobj);
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Client op failed", new Object[]{"username", username, "clop", clop, e});
                }
                finally {
                    ClientManager.this.releaseClientObject(username);
                }
            }

            @Override
            public void resolutionFailed(Name username, Exception reason) {
                clop.resolutionFailed(reason);
            }
        });
    }

    public synchronized void resolveClientObject(final Name username, final ClientResolutionListener listener) {
        SessionFactory factory;
        final ClientObject clobj = this._objmap.get(username);
        if (clobj != null) {
            clobj.reference();
            this._omgr.postRunnable(new Runnable(){

                @Override
                public void run() {
                    listener.clientResolved(username, clobj);
                }
            });
            return;
        }
        ClientResolver clr = this._penders.get(username);
        if (clr != null) {
            clr.addResolutionListener(listener);
            return;
        }
        Class<? extends ClientResolver> resolverClass = null;
        Iterator<SessionFactory> iterator = this._factories.iterator();
        while (iterator.hasNext() && (resolverClass = (factory = iterator.next()).getClientResolverClass(username)) == null) {
        }
        try {
            clr = (ClientResolver)((Object)this._injector.getInstance(resolverClass));
            clr.init(username);
            clr.addResolutionListener(this);
            clr.addResolutionListener(listener);
            this._penders.put(username, clr);
            final ClientResolver fclr = clr;
            this._omgr.postRunnable(new Runnable(){

                @Override
                public void run() {
                    ClientObject clobj = fclr.createClientObject();
                    clobj.setLocal(ClientLocal.class, fclr.createLocalAttribute());
                    fclr.objectAvailable(ClientManager.this._omgr.registerObject(clobj));
                }
            });
        }
        catch (Exception e) {
            listener.resolutionFailed(username, e);
        }
    }

    public void releaseClientObject(Name username) {
        ClientObject clobj = this._objmap.get(username);
        if (clobj == null) {
            Log.log.info((Object)"Requested to release unmapped client object", new Object[]{"username", username});
            return;
        }
        if (clobj.release()) {
            return;
        }
        Log.log.debug((Object)("Destroying client " + clobj.who() + "."), new Object[0]);
        this._objmap.remove(username);
        this._omgr.destroyObject(clobj.getOid());
    }

    public void init() {
        this._omgr.newInterval(new Runnable(){

            @Override
            public void run() {
                ClientManager.this.flushSessions();
            }
        }).schedule(60000L, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Log.log.info((Object)"Client manager shutting down", new Object[]{"ccount", this._usermap.size()});
        Map<Name, PresentsSession> map = this._usermap;
        synchronized (map) {
            for (PresentsSession pc : this._usermap.values()) {
                try {
                    pc.shutdown();
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Client choked in shutdown()", new Object[]{"client", StringUtil.safeToString((Object)pc), e});
                }
            }
        }
    }

    protected boolean renameClientObject(Name oldname, Name newname) {
        ClientObject clobj = this._objmap.remove(oldname);
        if (clobj == null) {
            Log.log.warning((Object)"Requested to rename unmapped client object", new Object[]{"username", oldname, new Exception()});
            return false;
        }
        this._objmap.put(newname, clobj);
        return true;
    }

    @Override
    public synchronized void clientResolved(Name username, ClientObject clobj) {
        clobj.release();
        this._objmap.put(username, clobj);
        this._penders.remove(username);
    }

    @Override
    public synchronized void resolutionFailed(Name username, Exception reason) {
        this._penders.remove(username);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void connectionEstablished(PresentsConnection conn, Name authname, AuthRequest req, AuthResponse rsp) {
        String type = authname.getClass().getSimpleName();
        PresentsSession session = this.getClient(authname);
        if (session != null) {
            Log.log.info((Object)"Resuming session", new Object[]{"type", type, "who", authname, "conn", conn});
            session.resumeSession(req, conn);
        } else {
            SessionFactory factory;
            Log.log.info((Object)"Session initiated", new Object[]{"type", type, "who", authname, "conn", conn});
            Class<? extends PresentsSession> sessionClass = null;
            Object object = this._factories.iterator();
            while (object.hasNext() && (sessionClass = (factory = object.next()).getSessionClass(req)) == null) {
            }
            session = (PresentsSession)this._injector.getInstance(sessionClass);
            session.startSession(authname, req, conn, rsp.authdata);
            object = this._usermap;
            synchronized (object) {
                this._usermap.put(session.getAuthName(), session);
            }
        }
        this._conmap.put(conn, session);
    }

    public void connectionFailed(Connection conn, IOException fault) {
        PresentsSession session = this._conmap.remove(conn);
        if (session != null) {
            Log.log.info((Object)"Unmapped failed session", new Object[]{"session", session, "conn", conn, "fault", fault});
            session.wasUnmapped();
            session.connectionFailed(fault);
        } else if (!(conn instanceof AuthingConnection)) {
            Log.log.info((Object)"Unmapped connection failed?", new Object[]{"conn", conn, "fault", fault, new Exception()});
        }
    }

    public void connectionClosed(Connection conn) {
        PresentsSession session = this._conmap.remove(conn);
        if (session != null) {
            Log.log.debug((Object)"Unmapped session", new Object[]{"session", session, "conn", conn});
            session.wasUnmapped();
        } else {
            Log.log.info((Object)("Closed unmapped connection '" + conn + "'. Session probably not yet authenticated."), new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void appendReport(StringBuilder report, long now, long sinceLast, boolean reset) {
        report.append("* presents.ClientManager:\n");
        report.append("- Sessions: ");
        Map<Name, PresentsSession> map = this._usermap;
        synchronized (map) {
            report.append(this._usermap.size()).append(" total, ");
        }
        report.append(this._conmap.size()).append(" connected, ");
        report.append(this._penders.size()).append(" pending\n");
        report.append("- Mapped users: ").append(this._objmap.size()).append("\n");
    }

    protected void clientSessionDidStart(final PresentsSession session) {
        this._clobservers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<ClientObserver>(){

            public boolean apply(ClientObserver observer) {
                observer.clientSessionDidStart(session);
                return true;
            }
        });
    }

    protected void clientSessionWillEnd(final PresentsSession session) {
        this._dclobservers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<DetailedClientObserver>(){

            public boolean apply(DetailedClientObserver observer) {
                observer.clientSessionWillEnd(session);
                return true;
            }
        });
    }

    protected void clientSessionDidEnd(final PresentsSession session) {
        this._clobservers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<ClientObserver>(){

            public boolean apply(ClientObserver observer) {
                observer.clientSessionDidEnd(session);
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void clearSession(PresentsSession session) {
        PresentsSession rc;
        Map<Name, PresentsSession> map = this._usermap;
        synchronized (map) {
            rc = this._usermap.remove(session.getAuthName());
        }
        if (rc == null) {
            Log.log.info((Object)"Cleared session: unregistered!", new Object[]{"session", session});
        } else if (rc != session) {
            Log.log.info((Object)"Cleared session: multiple!", new Object[]{"s1", rc, "s2", session});
        } else {
            Log.log.info((Object)"Cleared session", new Object[]{"session", session});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void flushSessions() {
        ArrayList victims = Lists.newArrayList();
        long now = System.currentTimeMillis();
        Map<Name, PresentsSession> map = this._usermap;
        synchronized (map) {
            for (PresentsSession session : this._usermap.values()) {
                if (!session.checkExpired(now)) continue;
                victims.add(session);
            }
        }
        for (PresentsSession session : victims) {
            try {
                Log.log.info((Object)"Session expired, ending session", new Object[]{"session", session, "dtime", now - session.getNetworkStamp() + "ms]."});
                session.endSession();
            }
            catch (Exception e) {
                Log.log.warning((Object)"Choke while flushing session", new Object[]{"victim", session, e});
            }
        }
    }

    public static interface DetailedClientObserver
    extends ClientObserver {
        public void clientSessionWillEnd(PresentsSession var1);
    }

    public static interface ClientObserver {
        public void clientSessionDidStart(PresentsSession var1);

        public void clientSessionDidEnd(PresentsSession var1);
    }

    public static interface ClientOp {
        public void apply(ClientObject var1);

        public void resolutionFailed(Exception var1);
    }
}

