/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.peer.server;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.samskivert.jdbc.RepositoryUnit;
import com.samskivert.jdbc.WriteOnlyUnit;
import com.samskivert.util.ArrayIntSet;
import com.samskivert.util.ChainedResultListener;
import com.samskivert.util.Interval;
import com.samskivert.util.Invoker;
import com.samskivert.util.Lifecycle;
import com.samskivert.util.ObserverList;
import com.samskivert.util.ResultListener;
import com.samskivert.util.ResultListenerList;
import com.samskivert.util.Tuple;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.Streamable;
import com.threerings.presents.Log;
import com.threerings.presents.annotation.PeerInvoker;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.data.InvocationException;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.Subscriber;
import com.threerings.presents.net.DownstreamMessage;
import com.threerings.presents.net.Message;
import com.threerings.presents.peer.data.ClientInfo;
import com.threerings.presents.peer.data.DObjectAddress;
import com.threerings.presents.peer.data.NodeObject;
import com.threerings.presents.peer.data.PeerAuthName;
import com.threerings.presents.peer.data.PeerMarshaller;
import com.threerings.presents.peer.net.PeerCreds;
import com.threerings.presents.peer.server.NodeRequestsListener;
import com.threerings.presents.peer.server.PeerClientResolver;
import com.threerings.presents.peer.server.PeerNode;
import com.threerings.presents.peer.server.PeerProvider;
import com.threerings.presents.peer.server.PeerSession;
import com.threerings.presents.peer.server.persist.NodeRecord;
import com.threerings.presents.peer.server.persist.NodeRepository;
import com.threerings.presents.server.ClientManager;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.PresentsDObjectMgr;
import com.threerings.presents.server.PresentsSession;
import com.threerings.presents.server.ReportManager;
import com.threerings.presents.server.ServiceAuthenticator;
import com.threerings.presents.server.SessionFactory;
import com.threerings.presents.server.net.PresentsConnectionManager;
import com.threerings.util.Name;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class PeerManager
implements PeerProvider,
ClientManager.ClientObserver,
Lifecycle.ShutdownComponent {
    protected static final Function<PeerNode, NodeObject> GET_NODE_OBJECT = new Function<PeerNode, NodeObject>(){

        public NodeObject apply(PeerNode peer) {
            return peer.nodeobj;
        }
    };
    protected String _nodeName;
    protected String _sharedSecret;
    protected NodeRecord _self;
    protected NodeObject _nodeobj;
    protected String _nodeNamespace;
    protected Map<String, PeerNode> _peers = Maps.newHashMap();
    protected ArrayIntSet _suboids = new ArrayIntSet();
    protected Map<DObjectAddress, Tuple<Subscriber<?>, DObject>> _proxies = Maps.newHashMap();
    protected Map<String, ObserverList<StaleCacheObserver>> _cacheobs = Maps.newHashMap();
    protected ObserverList<DroppedLockObserver> _dropobs = ObserverList.newFastUnsafe();
    protected Map<NodeObject.Lock, LockHandler> _locks = Maps.newHashMap();
    protected Stats _stats = new Stats();
    @Inject
    @PeerInvoker
    protected Invoker _invoker;
    @Inject
    protected ClientManager _clmgr;
    @Inject
    protected PresentsConnectionManager _conmgr;
    @Inject
    protected Injector _injector;
    @Inject
    protected InvocationManager _invmgr;
    @Inject
    protected NodeRepository _noderepo;
    @Inject
    protected PresentsDObjectMgr _omgr;
    @Inject
    protected ReportManager _repmgr;
    protected static final long DEFAULT_LOCK_TIMEOUT = 5000L;

    @Inject
    public PeerManager(Lifecycle cycle) {
        cycle.addComponent((Lifecycle.BaseComponent)this);
    }

    public NodeObject getNodeObject() {
        return this._nodeobj;
    }

    public Iterable<NodeObject> getNodeObjects() {
        return Iterables.filter((Iterable)Iterables.concat(Collections.singleton(this._nodeobj), (Iterable)Iterables.transform(this._peers.values(), GET_NODE_OBJECT)), (Predicate)Predicates.notNull());
    }

    public void init(String nodeName, String sharedSecret, String hostName, String publicHostName, int port) {
        this.init(nodeName, sharedSecret, hostName, publicHostName, port, "");
    }

    public void init(String nodeName, String sharedSecret, String hostName, String publicHostName, int port, String nodeNamespace) {
        this.init(nodeName, sharedSecret, hostName, publicHostName, null, port, nodeNamespace);
    }

    public void init(String nodeName, String sharedSecret, String hostName, String publicHostName, String region, int port, String nodeNamespace) {
        this._nodeNamespace = nodeNamespace;
        this._nodeName = nodeName;
        this._sharedSecret = sharedSecret;
        this._conmgr.addChainedAuthenticator(new ServiceAuthenticator<PeerCreds>(PeerCreds.class, PeerAuthName.class){

            @Override
            protected boolean areValid(PeerCreds creds) {
                return creds.areValid(PeerManager.this._sharedSecret);
            }
        });
        this._clmgr.addSessionFactory(SessionFactory.newSessionFactory(PeerCreds.class, PeerSession.class, PeerAuthName.class, PeerClientResolver.class));
        this._nodeobj = this._omgr.registerObject(this.createNodeObject());
        this._nodeobj.setNodeName(nodeName);
        this._nodeobj.setBootStamp(System.currentTimeMillis());
        this._self = new NodeRecord(this._nodeName, hostName, publicHostName == null ? hostName : publicHostName, region, port);
        this._invoker.postUnit((Invoker.Unit)new WriteOnlyUnit("registerNode(" + (Object)((Object)this._self) + ")"){

            public void invokePersist() throws Exception {
                PeerManager.this._noderepo.updateNode(PeerManager.this._self);
            }
        });
        this._nodeobj.setPeerService(this._invmgr.registerProvider(this, PeerMarshaller.class));
        this._clmgr.addClientObserver(this);
        this._omgr.newInterval(new Runnable(){

            @Override
            public void run() {
                PeerManager.this.refreshPeers();
            }
        }).schedule(5000L, 60000L);
        this.didInit();
    }

    public boolean isAuthenticPeer(PeerCreds creds) {
        return creds.areValid(this._sharedSecret);
    }

    public ClientInfo locateClient(final Name key) {
        return this.lookupNodeDatum(new Function<NodeObject, ClientInfo>(){

            public ClientInfo apply(NodeObject nodeobj) {
                return nodeobj.clients.get(key);
            }
        });
    }

    public <T> T lookupNodeDatum(Function<NodeObject, T> op) {
        Iterator iterator = Iterables.filter((Iterable)Iterables.transform(this.getNodeObjects(), op), (Predicate)Predicates.notNull()).iterator();
        if (iterator.hasNext()) {
            Object value = iterator.next();
            return value;
        }
        return null;
    }

    public int invokeOnNodes(Function<Tuple<Client, NodeObject>, Boolean> func) {
        int invoked = 0;
        for (PeerNode peer : this._peers.values()) {
            if (peer.nodeobj == null || !((Boolean)func.apply((Object)Tuple.newTuple((Object)peer.getClient(), (Object)peer.nodeobj))).booleanValue()) continue;
            ++invoked;
        }
        return invoked;
    }

    public void invokeNodeAction(NodeAction action) {
        this.invokeNodeAction(action, null);
    }

    public void invokeNodeAction(final NodeAction action, final Runnable onDropped) {
        if (!this._omgr.isDispatchThread()) {
            this._omgr.postRunnable(new Runnable(){

                @Override
                public void run() {
                    PeerManager.this.invokeNodeAction(action, onDropped);
                }
            });
            return;
        }
        byte[] actionBytes = this.flattenAction(action);
        boolean invoked = false;
        if (action.isApplicable(this._nodeobj)) {
            this.invokeAction(null, actionBytes);
            invoked = true;
        }
        for (PeerNode peer : this._peers.values()) {
            if (peer.nodeobj == null || !action.isApplicable(peer.nodeobj)) continue;
            peer.nodeobj.peerService.invokeAction(actionBytes);
            invoked = true;
        }
        if (!invoked && onDropped != null) {
            onDropped.run();
        }
        if (invoked) {
            this._stats.noteNodeActionInvoked(action);
        }
    }

    public void invokeNodeAction(String nodeName, NodeAction action) {
        PeerNode peer = this._peers.get(nodeName);
        if (peer != null) {
            peer.nodeobj.peerService.invokeAction(this.flattenAction(action));
        } else if (nodeName.equals(this._nodeName)) {
            this.invokeAction(null, this.flattenAction(action));
        }
    }

    public <T> void invokeNodeRequest(final NodeRequest request, final NodeRequestsListener<T> listener) {
        if (!this._omgr.isDispatchThread()) {
            this._omgr.postRunnable(new Runnable(){

                @Override
                public void run() {
                    PeerManager.this.invokeNodeRequest(request, listener);
                }
            });
            return;
        }
        byte[] requestBytes = this.flattenRequest(request);
        final Set<String> nodes = this.findApplicableNodes(request);
        if (nodes.isEmpty()) {
            listener.requestsProcessed(new NodeRequestsResultImpl());
            return;
        }
        final HashMap results = Maps.newHashMap();
        final HashMap failures = Maps.newHashMap();
        final AtomicInteger completedNodes = new AtomicInteger();
        for (final String node : nodes) {
            this.invokeNodeRequest(node, requestBytes, new InvocationService.ResultListener(){

                @Override
                public void requestProcessed(Object result) {
                    Object castResult = result;
                    results.put(node, castResult);
                    this.nodeDone();
                }

                @Override
                public void requestFailed(String cause) {
                    failures.put(node, cause);
                    this.nodeDone();
                }

                protected void nodeDone() {
                    if (completedNodes.incrementAndGet() == nodes.size()) {
                        listener.requestsProcessed(new NodeRequestsResultImpl(results, failures));
                    }
                }
            });
        }
    }

    public Set<String> findApplicableNodes(NodeApplicant applicant) {
        HashSet nodes = Sets.newHashSet();
        if (applicant.isApplicable(this._nodeobj)) {
            nodes.add(this._nodeobj.nodeName);
        }
        for (PeerNode peer : this._peers.values()) {
            if (!applicant.isApplicable(peer.nodeobj)) continue;
            nodes.add(peer.getNodeName());
        }
        return nodes;
    }

    public void invokeNodeRequest(String nodeName, NodeRequest request, InvocationService.ResultListener listener) {
        this.invokeNodeRequest(nodeName, this.flattenRequest(request), listener);
    }

    public <T extends DObject> void proxyRemoteObject(String nodeName, int remoteOid, ResultListener<Integer> listener) {
        this.proxyRemoteObject(new DObjectAddress(nodeName, remoteOid), listener);
    }

    public <T extends DObject> void proxyRemoteObject(final DObjectAddress remote, final ResultListener<Integer> listener) {
        if (remote.nodeName.equals(this._nodeName)) {
            this._omgr.subscribeToObject(remote.oid, new Subscriber<T>(){

                @Override
                public void objectAvailable(T object) {
                    PeerManager.this._proxies.put(remote, new Tuple((Object)this, object));
                    listener.requestCompleted((Object)remote.oid);
                }

                @Override
                public void requestFailed(int oid, ObjectAccessException oae) {
                    listener.requestFailed((Exception)oae);
                }
            });
            return;
        }
        final Client peer = this.getPeerClient(remote.nodeName);
        if (peer == null) {
            String errmsg = "Have no connection to peer [node=" + remote.nodeName + "].";
            listener.requestFailed((Exception)new ObjectAccessException(errmsg));
            return;
        }
        if (this._proxies.containsKey(remote)) {
            String errmsg = "Cannot proxy already proxied object [key=" + remote + "].";
            listener.requestFailed((Exception)new ObjectAccessException(errmsg));
            return;
        }
        peer.getDObjectManager().subscribeToObject(remote.oid, new Subscriber<T>(){

            @Override
            public void objectAvailable(T object) {
                PeerManager.this._proxies.put(remote, new Tuple((Object)this, object));
                PeerManager.this._omgr.registerProxyObject((DObject)object, peer.getDObjectManager());
                listener.requestCompleted((Object)((DObject)object).getOid());
            }

            @Override
            public void requestFailed(int oid, ObjectAccessException cause) {
                listener.requestFailed((Exception)cause);
            }
        });
    }

    public void unproxyRemoteObject(String nodeName, int remoteOid) {
        this.unproxyRemoteObject(new DObjectAddress(nodeName, remoteOid));
    }

    public void unproxyRemoteObject(DObjectAddress addr) {
        Tuple<Subscriber<?>, DObject> bits = this._proxies.remove(addr);
        if (bits == null) {
            Log.log.warning((Object)"Requested to clear unknown proxy", new Object[]{"addr", addr});
            return;
        }
        if (addr.nodeName.equals(this._nodeName)) {
            ((DObject)bits.right).removeSubscriber((Subscriber)bits.left);
            return;
        }
        this._omgr.clearProxyObject(addr.oid, (DObject)bits.right);
        Client peer = this.getPeerClient(addr.nodeName);
        if (peer == null) {
            Log.log.warning((Object)"Unable to unsubscribe from proxy, missing peer", new Object[]{"addr", addr});
            return;
        }
        ((DObject)bits.right).setOid(addr.oid);
        ((DObject)bits.right).setManager(peer.getDObjectManager());
        peer.getDObjectManager().unsubscribeFromObject(addr.oid, (Subscriber)bits.left);
    }

    public NodeObject getPeerNodeObject(String nodeName) {
        if (this._nodeName.equals(nodeName)) {
            return this._nodeobj;
        }
        PeerNode peer = this._peers.get(nodeName);
        return peer == null ? null : peer.nodeobj;
    }

    public Client getPeerClient(String nodeName) {
        PeerNode peer = this._peers.get(nodeName);
        return peer == null ? null : peer.getClient();
    }

    public String getPeerPublicHostName(String nodeName) {
        if (this._nodeName.equals(nodeName)) {
            return this._self.publicHostName;
        }
        PeerNode peer = this._peers.get(nodeName);
        return peer == null ? null : peer.getPublicHostName();
    }

    public String getPeerInternalHostName(String nodeName) {
        if (this._nodeName.equals(nodeName)) {
            return this._self.hostName;
        }
        PeerNode peer = this._peers.get(nodeName);
        return peer == null ? null : peer.getInternalHostName();
    }

    public int getPeerPort(String nodeName) {
        if (this._nodeName.equals(nodeName)) {
            return this._self.port;
        }
        PeerNode peer = this._peers.get(nodeName);
        return peer == null ? -1 : peer.getPort();
    }

    public void acquireLock(final NodeObject.Lock lock, final ResultListener<String> listener) {
        this.queryLock(lock, (ResultListener<String>)new ChainedResultListener<String, String>(listener){

            public void requestCompleted(String result) {
                if (result == null) {
                    if (PeerManager.this._suboids.isEmpty()) {
                        PeerManager.this.lockAcquired(lock, 0L, (ResultListener<String>)listener);
                    } else {
                        PeerManager.this._locks.put(lock, new LockHandler(lock, true, (ResultListener<String>)listener));
                    }
                } else {
                    listener.requestCompleted((Object)result);
                }
            }
        });
    }

    public void releaseLock(final NodeObject.Lock lock, final ResultListener<String> listener) {
        this.queryLock(lock, (ResultListener<String>)new ChainedResultListener<String, String>(listener){

            public void requestCompleted(String result) {
                if (PeerManager.this._nodeName.equals(result)) {
                    if (PeerManager.this._suboids.isEmpty()) {
                        PeerManager.this.lockReleased(lock, (ResultListener<String>)listener);
                    } else {
                        PeerManager.this._locks.put(lock, new LockHandler(lock, false, (ResultListener<String>)listener));
                    }
                } else {
                    if (result != null) {
                        Log.log.warning((Object)"Tried to release lock held by another peer", new Object[]{"lock", lock, "owner", result});
                    }
                    listener.requestCompleted((Object)result);
                }
            }
        });
    }

    public void reacquireLock(NodeObject.Lock lock) {
        LockHandler handler = this._locks.get(lock);
        if (handler == null || !handler.getNodeName().equals(this._nodeName) || handler.isAcquiring()) {
            Log.log.warning((Object)"Tried to reacquire lock not being released", new Object[]{"lock", lock, "handler", handler});
            return;
        }
        this._nodeobj.updateLocks(lock);
        this._locks.remove(lock);
        handler.cancel();
        handler.listeners.requestCompleted((Object)this._nodeName);
    }

    public void queryLock(NodeObject.Lock lock, ResultListener<String> listener) {
        LockHandler handler = this._locks.get(lock);
        if (handler != null) {
            handler.listeners.add(listener);
            return;
        }
        listener.requestCompleted((Object)this.queryLock(lock));
    }

    public String queryLock(NodeObject.Lock lock) {
        for (NodeObject nodeobj : this.getNodeObjects()) {
            if (!nodeobj.locks.contains(lock)) continue;
            return nodeobj.nodeName;
        }
        return null;
    }

    public void performWithLock(final NodeObject.Lock lock, final LockedOperation operation) {
        this.acquireLock(lock, new ResultListener<String>(){

            public void requestCompleted(String nodeName) {
                if (PeerManager.this.getNodeObject().nodeName.equals(nodeName)) {
                    try {
                        operation.run();
                    }
                    finally {
                        PeerManager.this.releaseLock(lock, (ResultListener<String>)new ResultListener.NOOP());
                    }
                } else {
                    operation.fail(nodeName);
                    if (nodeName == null) {
                        Log.log.warning((Object)"Lock acquired by null?", new Object[]{"lock", lock});
                    }
                }
            }

            public void requestFailed(Exception cause) {
                Log.log.warning((Object)"Lock acquisition failed", new Object[]{"lock", lock, cause});
                operation.fail(null);
            }
        });
    }

    public void addDroppedLockObserver(DroppedLockObserver observer) {
        this._dropobs.add((Object)observer);
    }

    public void removeDroppedLockObserver(DroppedLockObserver observer) {
        this._dropobs.remove((Object)observer);
    }

    public void clientSubscribedToNode(int cloid) {
        this._suboids.add(cloid);
    }

    public void clientUnsubscribedFromNode(int cloid) {
        this._suboids.remove(cloid);
        for (LockHandler handler : this._locks.values().toArray(new LockHandler[this._locks.size()])) {
            if (!handler.getNodeName().equals(this._nodeName)) continue;
            handler.clientUnsubscribed(cloid);
        }
    }

    public void addStaleCacheObserver(String cache, StaleCacheObserver observer) {
        ObserverList list = this._cacheobs.get(cache);
        if (list == null) {
            list = ObserverList.newFastUnsafe();
            this._cacheobs.put(cache, (ObserverList<StaleCacheObserver>)list);
        }
        list.add((Object)observer);
    }

    public void removeStaleCacheObserver(String cache, StaleCacheObserver observer) {
        ObserverList<StaleCacheObserver> list = this._cacheobs.get(cache);
        if (list == null) {
            return;
        }
        list.remove((Object)observer);
        if (list.isEmpty()) {
            this._cacheobs.remove(cache);
        }
    }

    public void broadcastStaleCacheData(String cache, Streamable data) {
        if (this._nodeobj != null) {
            this._nodeobj.setCacheData(new NodeObject.CacheData(cache, data));
        }
    }

    public Stats getStats() {
        return this._stats.clone();
    }

    public void shutdown() {
        if (this._nodeName == null) {
            return;
        }
        if (this._nodeobj != null) {
            this._invmgr.clearDispatcher(this._nodeobj.peerService);
        }
        this._clmgr.removeClientObserver(this);
        this._invoker.postUnit((Invoker.Unit)new WriteOnlyUnit("shutdownNode(" + this._nodeName + ")"){

            public void invokePersist() throws Exception {
                PeerManager.this._noderepo.shutdownNode(PeerManager.this._nodeName);
            }
        });
        for (PeerNode peer : this._peers.values()) {
            peer.shutdown();
        }
    }

    @Override
    public void ratifyLockAction(ClientObject caller, NodeObject.Lock lock, boolean acquire) {
        LockHandler handler = this._locks.get(lock);
        if (handler != null && handler.getNodeName().equals(this._nodeName)) {
            handler.ratify(caller, acquire);
        }
    }

    @Override
    public void invokeAction(ClientObject caller, byte[] serializedAction) {
        NodeAction action = null;
        try {
            ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(serializedAction));
            action = (NodeAction)oin.readObject();
            this._injector.injectMembers((Object)action);
            action.invoke();
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed to execute node action", new Object[]{"from", caller == null ? "self" : caller.who(), "action", action, "serializedSize", serializedAction.length, e});
        }
    }

    @Override
    public void invokeRequest(ClientObject caller, byte[] serializedAction, InvocationService.ResultListener listener) {
        NodeRequest request = null;
        try {
            ObjectInputStream oin = new ObjectInputStream(new ByteArrayInputStream(serializedAction));
            request = (NodeRequest)oin.readObject();
            this._injector.injectMembers((Object)request);
            request.invoke(listener);
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed to execute node request", new Object[]{"from", caller == null ? "self" : caller.who(), "request", request, "serializedSize", serializedAction.length, e});
            listener.requestFailed("Failed to execute node request");
        }
    }

    @Override
    public void generateReport(ClientObject caller, String type, InvocationService.ResultListener listener) throws InvocationException {
        listener.requestProcessed(this._repmgr.generateReport(type));
    }

    @Override
    public void clientSessionDidStart(PresentsSession client) {
        if (this.ignoreClient(client)) {
            return;
        }
        ClientInfo clinfo = this.createClientInfo();
        this.initClientInfo(client, clinfo);
        if (this._nodeobj.clients.contains(clinfo)) {
            Log.log.warning((Object)"Received clientSessionDidStart() for already registered client!?", new Object[]{"old", this._nodeobj.clients.get(clinfo.getKey()), "new", clinfo});
            this._nodeobj.updateClients(clinfo);
        } else {
            this._nodeobj.addToClients(clinfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clientSessionDidEnd(PresentsSession client) {
        if (this.ignoreClient(client)) {
            return;
        }
        Name username = client.getAuthName();
        for (ClientInfo clinfo : this._nodeobj.clients) {
            if (!clinfo.username.equals(username)) continue;
            this._nodeobj.startTransaction();
            try {
                this.clearClientInfo(client, clinfo);
            }
            finally {
                this._nodeobj.commitTransaction();
            }
            return;
        }
        Log.log.warning((Object)"Session ended for unregistered client", new Object[]{"who", username});
    }

    protected void didInit() {
    }

    protected void refreshPeers() {
        this._invoker.postUnit((Invoker.Unit)new RepositoryUnit("refreshPeers"){
            protected Map<String, NodeRecord> _nodes;

            public void invokePersist() throws Exception {
                PeerManager.this._noderepo.heartbeatNode(PeerManager.this._nodeName);
                this._nodes = Maps.newHashMap();
                for (NodeRecord record : PeerManager.this._noderepo.loadNodes(PeerManager.this._nodeNamespace)) {
                    this._nodes.put(record.nodeName, record);
                }
            }

            public void handleSuccess() {
                long now = System.currentTimeMillis();
                Iterator<Object> it = this._nodes.values().iterator();
                while (it.hasNext()) {
                    NodeRecord record = it.next();
                    if (record.nodeName.equals(PeerManager.this._nodeName)) continue;
                    if (now - record.lastUpdated.getTime() > 300000L) {
                        it.remove();
                        continue;
                    }
                    try {
                        PeerManager.this.refreshPeer(record);
                    }
                    catch (Exception e) {
                        Log.log.warning((Object)("Failure refreshing peer " + (Object)((Object)record) + "."), new Object[]{e});
                    }
                }
                it = PeerManager.this._peers.values().iterator();
                while (it.hasNext()) {
                    PeerNode peer = (PeerNode)it.next();
                    if (this._nodes.containsKey(peer.getNodeName())) continue;
                    peer.shutdown();
                    it.remove();
                }
            }

            public long getLongThreshold() {
                return 700L;
            }
        });
    }

    protected void refreshPeer(NodeRecord record) {
        PeerNode peer = this._peers.get(record.nodeName);
        if (peer == null) {
            peer = (PeerNode)this._injector.getInstance(this.getPeerNodeClass());
            this._peers.put(record.nodeName, peer);
            peer.init(record);
        }
        peer.refresh(record);
    }

    protected boolean ignoreClient(PresentsSession client) {
        return client instanceof PeerSession;
    }

    protected NodeObject createNodeObject() {
        return new NodeObject();
    }

    protected ClientInfo createClientInfo() {
        return new ClientInfo();
    }

    protected LockHandler getLockHandler(NodeObject.Lock lock) {
        return this._locks.get(lock);
    }

    protected LockHandler createLockHandler(PeerNode peer, NodeObject.Lock lock, boolean acquire) {
        LockHandler handler = new LockHandler(peer, lock, acquire);
        this._locks.put(lock, handler);
        return handler;
    }

    protected void changedCacheData(String cache, final Streamable data) {
        ObserverList<StaleCacheObserver> list = this._cacheobs.get(cache);
        if (list == null) {
            return;
        }
        list.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<StaleCacheObserver>(){

            public boolean apply(StaleCacheObserver observer) {
                observer.changedCacheData(data);
                return true;
            }
        });
    }

    protected void droppedLock(final NodeObject.Lock lock) {
        this._nodeobj.removeFromLocks(lock);
        ++this._stats.locksHijacked;
        this._dropobs.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<DroppedLockObserver>(){

            public boolean apply(DroppedLockObserver observer) {
                observer.droppedLock(lock);
                return true;
            }
        });
    }

    protected void initClientInfo(PresentsSession client, ClientInfo info) {
        info.username = client.getAuthName();
    }

    protected void clearClientInfo(PresentsSession client, ClientInfo info) {
        this._nodeobj.removeFromClients(info.getKey());
    }

    protected Class<? extends PeerNode> getPeerNodeClass() {
        return PeerNode.class;
    }

    protected PeerCreds createCreds() {
        return new PeerCreds(this._nodeName, this._sharedSecret);
    }

    protected String getRegion() {
        return this._self.region;
    }

    protected void clientLoggedOn(String nodeName, ClientInfo clinfo) {
        PresentsSession session = this._clmgr.getClient(clinfo.username);
        if (session != null) {
            Log.log.info((Object)"Booting user that has connected on another node", new Object[]{"username", clinfo.username, "otherNode", nodeName});
            session.endSession();
        }
    }

    protected void clientLoggedOff(String nodeName, ClientInfo clinfo) {
    }

    protected void peerStartedSession(PeerSession session) {
        this.refreshPeers();
        session.setStats(this._stats);
    }

    protected void peerEndedSession(PeerSession session) {
    }

    protected void connectedToPeer(PeerNode peer) {
    }

    protected void disconnectedFromPeer(PeerNode peer) {
    }

    protected void peerAcquiringLock(PeerNode peer, NodeObject.Lock lock) {
        String owner = this.queryLock(lock);
        if (owner != null) {
            Log.log.warning((Object)"Refusing to ratify lock acquisition.", new Object[]{"lock", lock, "node", peer.getNodeName(), "owner", owner});
            return;
        }
        LockHandler handler = this._locks.get(lock);
        if (handler == null) {
            this.createLockHandler(peer, lock, true);
            return;
        }
        if (PeerManager.hasPriority(handler.getNodeName(), peer.getNodeName())) {
            return;
        }
        ResultListenerList<String> olisteners = handler.listeners;
        handler.cancel();
        handler = this.createLockHandler(peer, lock, true);
        handler.listeners = olisteners;
    }

    protected void peerReleasingLock(PeerNode peer, NodeObject.Lock lock) {
        String owner = this.queryLock(lock);
        if (!peer.getNodeName().equals(owner)) {
            Log.log.warning((Object)"Refusing to ratify lock release.", new Object[]{"lock", lock, "node", peer.getNodeName(), "owner", owner});
            return;
        }
        LockHandler handler = this._locks.get(lock);
        if (handler == null) {
            this.createLockHandler(peer, lock, false);
        } else {
            Log.log.warning((Object)"Received request to release resolving lock", new Object[]{"node", peer.getNodeName(), "handler", handler});
        }
    }

    protected void peerAddedLock(String nodeName, NodeObject.Lock lock) {
        LockHandler handler;
        if (this._nodeobj.locks.contains(lock)) {
            Log.log.warning((Object)"Client hijacked lock owned by this node", new Object[]{"lock", lock, "node", nodeName});
            this.droppedLock(lock);
        }
        if ((handler = this._locks.get(lock)) != null) {
            handler.peerAddedLock(nodeName);
        }
    }

    protected void peerUpdatedLock(String nodeName, NodeObject.Lock lock) {
        LockHandler handler = this._locks.get(lock);
        if (handler != null) {
            handler.peerUpdatedLock(nodeName);
        }
    }

    protected void peerRemovedLock(String nodeName, NodeObject.Lock lock) {
        LockHandler handler = this._locks.get(lock);
        if (handler != null) {
            handler.peerRemovedLock(nodeName);
        }
    }

    protected byte[] flattenAction(NodeAction action) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(action);
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to serialize node action [action=" + action + "].", e);
        }
    }

    protected byte[] flattenRequest(NodeRequest request) {
        try {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            ObjectOutputStream oout = new ObjectOutputStream(bout);
            oout.writeObject(request);
            return bout.toByteArray();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to serialize node request [request=" + request + "].", e);
        }
    }

    protected void invokeNodeRequest(String nodeName, byte[] requestBytes, InvocationService.ResultListener listener) {
        PeerNode peer = this._peers.get(nodeName);
        if (peer != null) {
            peer.nodeobj.peerService.invokeRequest(requestBytes, listener);
        } else if (nodeName.equals(this._nodeName)) {
            this.invokeRequest(null, requestBytes, listener);
        }
    }

    protected void lockAcquired(NodeObject.Lock lock, long wait, ResultListener<String> listener) {
        this._nodeobj.addToLocks(lock);
        ++this._stats.locksAcquired;
        this._stats.lockAcquireWait += wait;
        listener.requestCompleted((Object)this._nodeName);
    }

    protected void lockReleased(NodeObject.Lock lock, ResultListener<String> listener) {
        this._nodeobj.removeFromLocks(lock);
        ++this._stats.locksReleased;
        listener.requestCompleted(null);
    }

    protected long getLockTimeout() {
        return 5000L;
    }

    protected static boolean hasPriority(String nodeName1, String nodeName2) {
        return nodeName1.compareTo(nodeName2) < 0;
    }

    protected static class NodeRequestsResultImpl<T>
    implements NodeRequestsListener.NodeRequestsResult<T> {
        protected Map<String, T> _results;
        protected Map<String, String> _errors;

        public NodeRequestsResultImpl(Map<String, T> results, Map<String, String> errors) {
            this._results = Maps.newHashMap(results);
            this._errors = Maps.newHashMap(errors);
        }

        public NodeRequestsResultImpl() {
            this._results = Maps.newHashMap();
            this._errors = Maps.newHashMap();
        }

        @Override
        public Map<String, T> getNodeResults() {
            return this._results;
        }

        @Override
        public Map<String, String> getNodeErrors() {
            return this._errors;
        }

        @Override
        public boolean wasDropped() {
            return this._results.isEmpty() && this._errors.isEmpty();
        }
    }

    protected class LockHandler {
        public ResultListenerList<String> listeners = new ResultListenerList();
        protected PeerNode _peer;
        protected NodeObject.Lock _lock;
        protected boolean _acquire;
        protected ArrayIntSet _remoids;
        protected Interval _timeout;
        protected long _startStamp = System.currentTimeMillis();

        public LockHandler(NodeObject.Lock lock, boolean acquire, ResultListener<String> listener) {
            this._lock = lock;
            this._acquire = acquire;
            this.listeners.add(listener);
            if (acquire) {
                PeerManager.this._nodeobj.setAcquiringLock(lock);
            } else {
                PeerManager.this._nodeobj.setReleasingLock(lock);
            }
            this._remoids = PeerManager.this._suboids.clone();
            this._timeout = PeerManager.this._omgr.newInterval(new Runnable(){

                @Override
                public void run() {
                    Log.log.warning((Object)"Lock handler timed out, acting anyway", new Object[]{"lock", LockHandler.this._lock, "acquire", LockHandler.this._acquire});
                    ++PeerManager.this._stats.lockTimeouts;
                    LockHandler.this.activate();
                }
            });
            this._timeout.schedule(PeerManager.this.getLockTimeout());
        }

        public LockHandler(PeerNode peer, NodeObject.Lock lock, boolean acquire) {
            this._peer = peer;
            this._lock = lock;
            this._acquire = acquire;
            peer.nodeobj.peerService.ratifyLockAction(lock, acquire);
        }

        public String getNodeName() {
            return this._peer == null ? PeerManager.this._nodeName : this._peer.getNodeName();
        }

        public boolean isAcquiring() {
            return this._acquire;
        }

        public void ratify(ClientObject caller, boolean acquire) {
            if (acquire != this._acquire) {
                return;
            }
            if (!this._remoids.remove(caller.getOid())) {
                Log.log.warning((Object)"Received unexpected ratification", new Object[]{"handler", this, "who", caller.who()});
            }
            this.maybeActivate();
        }

        public void clientUnsubscribed(int cloid) {
            if (this._remoids.remove(cloid)) {
                this.maybeActivate();
            }
        }

        public void peerAddedLock(String nodeName) {
            if (!this._acquire || !this.getNodeName().equals(nodeName)) {
                Log.log.warning((Object)"Node hijacked lock in process of resolution.", new Object[]{"node", nodeName, "handler", this});
                ++PeerManager.this._stats.locksHijacked;
            }
            this.cancel();
            this.wasActivated(nodeName);
        }

        public void peerUpdatedLock(String nodeName) {
            if (this._acquire || !this.getNodeName().equals(nodeName)) {
                Log.log.warning((Object)"Unexpected lock update.", new Object[]{"node", nodeName, "handler", this});
                ++PeerManager.this._stats.locksHijacked;
            }
            this.cancel();
            this.wasActivated(nodeName);
        }

        public void peerRemovedLock(String nodeName) {
            if (this.getNodeName().equals(nodeName)) {
                this.wasActivated(null);
            } else {
                Log.log.warning((Object)"Unexpected lock removal.", new Object[]{"node", nodeName, "handler", this});
            }
        }

        public void cancel() {
            if (this._peer == null) {
                this._timeout.cancel();
            }
        }

        public String toString() {
            return "[node=" + this.getNodeName() + ", lock=" + this._lock + ", acquire=" + this._acquire + "]";
        }

        protected void maybeActivate() {
            if (this._remoids.isEmpty()) {
                this._timeout.cancel();
                this.activate();
            }
        }

        protected void activate() {
            PeerManager.this._locks.remove(this._lock);
            if (this._acquire) {
                PeerManager.this.lockAcquired(this._lock, System.currentTimeMillis() - this._startStamp, (ResultListener<String>)this.listeners);
            } else {
                PeerManager.this.lockReleased(this._lock, (ResultListener<String>)this.listeners);
            }
        }

        protected void wasActivated(String owner) {
            PeerManager.this._locks.remove(this._lock);
            this.listeners.requestCompleted((Object)owner);
        }
    }

    public static class Stats
    implements Cloneable {
        public long locksAcquired;
        public long lockAcquireWait;
        public long locksReleased;
        public long locksHijacked;
        public long lockTimeouts;
        public long nodeActionsInvoked;
        public AtomicLong peerMessagesIn = new AtomicLong(0L);
        public long peerMessagesOut;

        public void noteNodeActionInvoked(NodeAction action) {
            ++this.nodeActionsInvoked;
        }

        public void notePeerMessageReceived(Message msg) {
            this.peerMessagesIn.incrementAndGet();
        }

        public void notePeerMessageSent(DownstreamMessage msg) {
            ++this.peerMessagesOut;
        }

        public Stats clone() {
            try {
                Stats cstats = (Stats)super.clone();
                cstats.peerMessagesIn = new AtomicLong(this.peerMessagesIn.get());
                return cstats;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static abstract class NodeRequest
    implements Streamable.Closure,
    NodeApplicant {
        public void invoke(InvocationService.ResultListener listener) {
            try {
                this.execute(listener);
            }
            catch (Throwable t) {
                Log.log.warning((Object)(this.getClass().getName() + " failed."), new Object[]{t});
            }
        }

        protected abstract void execute(InvocationService.ResultListener var1);
    }

    public static abstract class NodeAction
    implements Streamable.Closure,
    NodeApplicant {
        public void invoke() {
            try {
                this.execute();
            }
            catch (Throwable t) {
                Log.log.warning((Object)(this.getClass().getName() + " failed."), new Object[]{t});
            }
        }

        protected abstract void execute();
    }

    public static interface NodeApplicant {
        public boolean isApplicable(NodeObject var1);
    }

    public static interface LockedOperation {
        public void run();

        public void fail(String var1);
    }

    public static interface DroppedLockObserver {
        public void droppedLock(NodeObject.Lock var1);
    }

    public static interface StaleCacheObserver {
        public void changedCacheData(Streamable var1);
    }
}

