/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.io;

import com.google.common.collect.Maps;
import com.samskivert.util.HashIntMap;
import com.threerings.NaryaLog;
import com.threerings.io.BasicStreamers;
import com.threerings.io.Intern;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.Streamable;
import com.threerings.io.Streamer;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ReflectPermission;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class FieldMarshaller {
    protected final String _type;
    protected static Map<Class<?>, FieldMarshaller> _marshallers;
    protected static FieldMarshaller _internMarshaller;
    protected static final Class<?>[] READER_ARGS;
    protected static final Class<?>[] WRITER_ARGS;

    public FieldMarshaller() {
        this(null);
    }

    public FieldMarshaller(String type) {
        this._type = type;
    }

    public abstract void readField(Field var1, Object var2, ObjectInputStream var3) throws Exception;

    public abstract void writeField(Field var1, Object var2, ObjectOutputStream var3) throws Exception;

    public String toString() {
        if (this._type != null) {
            return "FieldMarshaller " + this._type;
        }
        return super.toString();
    }

    public static FieldMarshaller getFieldMarshaller(Field field) {
        Class<?> ftype;
        if (_marshallers == null) {
            _marshallers = FieldMarshaller.createMarshallers();
        }
        if (FieldMarshaller.useFieldAccessors()) {
            Method reader = null;
            Method writer = null;
            try {
                reader = field.getDeclaringClass().getMethod(FieldMarshaller.getReaderMethodName(field.getName()), READER_ARGS);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            try {
                writer = field.getDeclaringClass().getMethod(FieldMarshaller.getWriterMethodName(field.getName()), WRITER_ARGS);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            if (reader != null && writer != null) {
                return new MethodFieldMarshaller(reader, writer);
            }
            if (reader == null && writer != null || writer == null && reader != null) {
                NaryaLog.log.warning((Object)"Class contains one but not both custom field reader and writer", new Object[]{"class", field.getDeclaringClass().getName(), "field", field.getName(), "reader", reader, "writer", writer});
            }
        }
        if ((ftype = field.getType()) == String.class && field.isAnnotationPresent(Intern.class)) {
            return _internMarshaller;
        }
        FieldMarshaller fm = _marshallers.get(ftype);
        if (fm == null) {
            Class<?> collClass = Streamer.getCollectionClass(ftype);
            if (collClass != null && !collClass.equals(ftype)) {
                NaryaLog.log.warning((Object)"Specific field types are discouraged for Iterables/Collections and Maps. The implementation type may not be recreated on the other side.", new Object[]{"class", field.getDeclaringClass(), "field", field.getName(), "type", ftype, "shouldBe", collClass});
                fm = _marshallers.get(collClass);
            }
            if (fm == null && (ftype.isInterface() || Streamer.isStreamable(ftype))) {
                fm = _marshallers.get(Streamable.class);
            }
        }
        return fm;
    }

    public static final String getReaderMethodName(String field) {
        return "readField_" + field;
    }

    public static final String getWriterMethodName(String field) {
        return "writeField_" + field;
    }

    protected static boolean useFieldAccessors() {
        try {
            SecurityManager security = System.getSecurityManager();
            if (security != null) {
                security.checkPermission(new ReflectPermission("suppressAccessChecks"));
            }
            return false;
        }
        catch (SecurityException se) {
            return true;
        }
    }

    protected static Map<Class<?>, FieldMarshaller> createMarshallers() {
        HashMap marshallers = Maps.newHashMap();
        FieldMarshaller gmarsh = new FieldMarshaller("Generic"){

            @Override
            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.set(target, in.readObject());
            }

            @Override
            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeObject(field.get(source));
            }
        };
        marshallers.put(Streamable.class, gmarsh);
        marshallers.put(Object.class, gmarsh);
        marshallers.put(HashMap.class, gmarsh);
        marshallers.put(Map.class, gmarsh);
        marshallers.put(HashIntMap.class, gmarsh);
        marshallers.put(Boolean.TYPE, new FieldMarshaller("boolean"){

            @Override
            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.setBoolean(target, in.readBoolean());
            }

            @Override
            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeBoolean(field.getBoolean(source));
            }
        });
        marshallers.put(Byte.TYPE, new FieldMarshaller("byte"){

            @Override
            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.setByte(target, in.readByte());
            }

            @Override
            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeByte(field.getByte(source));
            }
        });
        marshallers.put(Character.TYPE, new FieldMarshaller("char"){

            @Override
            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.setChar(target, in.readChar());
            }

            @Override
            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeChar(field.getChar(source));
            }
        });
        marshallers.put(Short.TYPE, new FieldMarshaller("short"){

            @Override
            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.setShort(target, in.readShort());
            }

            @Override
            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeShort(field.getShort(source));
            }
        });
        marshallers.put(Integer.TYPE, new FieldMarshaller("int"){

            @Override
            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.setInt(target, in.readInt());
            }

            @Override
            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeInt(field.getInt(source));
            }
        });
        marshallers.put(Long.TYPE, new FieldMarshaller("long"){

            @Override
            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.setLong(target, in.readLong());
            }

            @Override
            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeLong(field.getLong(source));
            }
        });
        marshallers.put(Float.TYPE, new FieldMarshaller("float"){

            @Override
            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.setFloat(target, in.readFloat());
            }

            @Override
            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeFloat(field.getFloat(source));
            }
        });
        marshallers.put(Double.TYPE, new FieldMarshaller("double"){

            @Override
            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.setDouble(target, in.readDouble());
            }

            @Override
            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeDouble(field.getDouble(source));
            }
        });
        marshallers.put(Date.class, new FieldMarshaller("Date"){

            @Override
            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.set(target, new Date(in.readLong()));
            }

            @Override
            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeLong(((Date)field.get(source)).getTime());
            }
        });
        for (Map.Entry<Class<?>, Streamer> entry : BasicStreamers.BSTREAMERS.entrySet()) {
            marshallers.put(entry.getKey(), new StreamerMarshaller(entry.getValue()));
        }
        _internMarshaller = new FieldMarshaller("intern"){

            @Override
            public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
                field.set(target, in.readIntern());
            }

            @Override
            public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
                out.writeIntern((String)field.get(source));
            }
        };
        return marshallers;
    }

    static {
        READER_ARGS = new Class[]{ObjectInputStream.class};
        WRITER_ARGS = new Class[]{ObjectOutputStream.class};
    }

    protected static class MethodFieldMarshaller
    extends FieldMarshaller {
        protected Method _reader;
        protected Method _writer;

        public MethodFieldMarshaller(Method reader, Method writer) {
            this._reader = reader;
            this._writer = writer;
        }

        @Override
        public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
            this._reader.invoke(target, in);
        }

        @Override
        public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
            this._writer.invoke(source, out);
        }
    }

    protected static class StreamerMarshaller
    extends FieldMarshaller {
        protected Streamer _streamer;

        public StreamerMarshaller(Streamer streamer) {
            this._streamer = streamer;
        }

        @Override
        public void readField(Field field, Object target, ObjectInputStream in) throws Exception {
            if (in.readBoolean()) {
                Object value = this._streamer.createObject(in);
                this._streamer.readObject(value, in, true);
                field.set(target, value);
            } else {
                field.set(target, null);
            }
        }

        @Override
        public void writeField(Field field, Object source, ObjectOutputStream out) throws Exception {
            Object value = field.get(source);
            if (value == null) {
                out.writeBoolean(false);
            } else {
                out.writeBoolean(true);
                this._streamer.writeObject(value, out, true);
            }
        }

        @Override
        public String toString() {
            return "StreamerMarshaller:" + this._streamer.toString();
        }
    }
}

