/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.server;

import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.threerings.crowd.chat.server.ChatProvider;
import com.threerings.crowd.server.BodyManager;
import com.threerings.crowd.server.CrowdClientResolver;
import com.threerings.crowd.server.CrowdSession;
import com.threerings.crowd.server.LocationManager;
import com.threerings.crowd.server.PlaceRegistry;
import com.threerings.presents.net.AuthRequest;
import com.threerings.presents.server.ClientResolver;
import com.threerings.presents.server.PresentsServer;
import com.threerings.presents.server.PresentsSession;
import com.threerings.presents.server.SessionFactory;
import com.threerings.util.Name;

@Singleton
public class CrowdServer
extends PresentsServer {
    @Inject
    protected PlaceRegistry _plreg;
    @Inject
    protected BodyManager _bodyman;
    @Inject
    protected LocationManager _locman;
    @Inject
    protected ChatProvider _chatprov;
    protected static final String PROVIDERS_KEY = "providers";

    @Override
    public void init(Injector injector) throws Exception {
        super.init(injector);
        this._clmgr.setDefaultSessionFactory(new SessionFactory(){

            @Override
            public Class<? extends PresentsSession> getSessionClass(AuthRequest areq) {
                return CrowdSession.class;
            }

            @Override
            public Class<? extends ClientResolver> getClientResolverClass(Name username) {
                return CrowdClientResolver.class;
            }
        });
    }

    public static void main(String[] args) {
        CrowdServer.runServer(new Module[]{new CrowdModule(), new PresentsServer.PresentsServerModule(CrowdServer.class)});
    }

    public static class CrowdModule
    extends PresentsServer.PresentsModule {
        @Override
        protected void configure() {
            super.configure();
        }
    }
}

