/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.peer.server;

import com.google.inject.Inject;
import com.samskivert.util.Lifecycle;
import com.threerings.crowd.chat.client.ChatService;
import com.threerings.crowd.chat.data.UserMessage;
import com.threerings.crowd.chat.server.ChatProvider;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.peer.data.CrowdClientInfo;
import com.threerings.crowd.peer.data.CrowdNodeObject;
import com.threerings.crowd.peer.data.CrowdPeerMarshaller;
import com.threerings.crowd.peer.server.CrowdPeerProvider;
import com.threerings.crowd.server.BodyLocator;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.data.InvocationException;
import com.threerings.presents.peer.data.ClientInfo;
import com.threerings.presents.peer.data.NodeObject;
import com.threerings.presents.peer.server.PeerManager;
import com.threerings.presents.peer.server.PeerNode;
import com.threerings.presents.server.PresentsSession;
import com.threerings.util.Name;

public abstract class CrowdPeerManager
extends PeerManager
implements CrowdPeerProvider,
ChatProvider.ChatForwarder {
    @Inject
    protected ChatProvider _chatprov;
    @Inject
    protected BodyLocator _locator;

    @Inject
    public CrowdPeerManager(Lifecycle cycle) {
        super(cycle);
    }

    @Override
    public void deliverTell(ClientObject caller, UserMessage message, Name target, ChatService.TellListener listener) throws InvocationException {
        this._chatprov.deliverTell(message, target, listener);
    }

    @Override
    public void deliverBroadcast(ClientObject caller, Name from, byte levelOrMode, String bundle, String msg) {
        this._chatprov.broadcast(from, levelOrMode, bundle, msg, false);
    }

    @Override
    public boolean forwardTell(UserMessage message, Name target, ChatService.TellListener listener) {
        Name username = this.authFromViz(target);
        if (username == null) {
            return false;
        }
        for (PeerNode peer : this._peers.values()) {
            CrowdClientInfo cinfo;
            CrowdNodeObject cnobj = (CrowdNodeObject)peer.nodeobj;
            if (cnobj == null || (cinfo = (CrowdClientInfo)cnobj.clients.get(username)) == null) continue;
            cnobj.crowdPeerService.deliverTell(message, target, listener);
            return true;
        }
        return false;
    }

    @Override
    public void forwardBroadcast(Name from, byte levelOrMode, String bundle, String msg) {
        for (PeerNode peer : this._peers.values()) {
            if (peer.nodeobj == null) continue;
            ((CrowdNodeObject)peer.nodeobj).crowdPeerService.deliverBroadcast(from, levelOrMode, bundle, msg);
        }
    }

    @Override
    public void shutdown() {
        super.shutdown();
        if (this._nodeobj != null) {
            this._invmgr.clearDispatcher(((CrowdNodeObject)this._nodeobj).crowdPeerService);
        }
        this._chatprov.setChatForwarder(null);
    }

    @Override
    protected NodeObject createNodeObject() {
        return new CrowdNodeObject();
    }

    @Override
    protected ClientInfo createClientInfo() {
        return new CrowdClientInfo();
    }

    @Override
    protected void initClientInfo(PresentsSession client, ClientInfo info) {
        super.initClientInfo(client, info);
        BodyObject body = this._locator.forClient(client.getClientObject());
        if (body != null) {
            ((CrowdClientInfo)info).visibleName = body.getVisibleName();
        }
    }

    @Override
    protected void didInit() {
        super.didInit();
        CrowdNodeObject cnobj = (CrowdNodeObject)this._nodeobj;
        cnobj.setCrowdPeerService(this._invmgr.registerProvider(this, CrowdPeerMarshaller.class));
        this._chatprov.setChatForwarder(this);
    }

    protected abstract Name authFromViz(Name var1);
}

