/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.client;

import com.google.common.collect.Lists;
import com.samskivert.swing.Controller;
import com.threerings.crowd.client.PlaceControllerDelegate;
import com.threerings.crowd.client.PlaceView;
import com.threerings.crowd.client.PlaceViewUtil;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.crowd.util.CrowdContext;
import java.awt.event.ActionEvent;
import java.util.ArrayList;

public abstract class PlaceController
extends Controller {
    protected CrowdContext _ctx;
    protected PlaceConfig _config;
    protected PlaceObject _plobj;
    protected PlaceView _view;
    protected ArrayList<PlaceControllerDelegate> _delegates;

    public void init(CrowdContext ctx, PlaceConfig config) {
        this._ctx = ctx;
        this._config = config;
        this._view = this.createPlaceView(this._ctx);
        this.applyToDelegates(new DelegateOp(PlaceControllerDelegate.class){

            @Override
            public void apply(PlaceControllerDelegate delegate) {
                delegate.init(PlaceController.this._ctx, PlaceController.this._config);
            }
        });
        this.didInit();
    }

    protected void didInit() {
    }

    public PlaceView getPlaceView() {
        return this._view;
    }

    public PlaceConfig getPlaceConfig() {
        return this._config;
    }

    protected PlaceView createPlaceView(CrowdContext ctx) {
        return this.createPlaceView();
    }

    @Deprecated
    protected PlaceView createPlaceView() {
        return null;
    }

    public void willEnterPlace(final PlaceObject plobj) {
        this._plobj = plobj;
        if (this._view != null) {
            PlaceViewUtil.dispatchWillEnterPlace(this._view, plobj);
            this._ctx.setPlaceView(this._view);
        }
        this.applyToDelegates(new DelegateOp(PlaceControllerDelegate.class){

            @Override
            public void apply(PlaceControllerDelegate delegate) {
                delegate.willEnterPlace(plobj);
            }
        });
    }

    public void mayLeavePlace(final PlaceObject plobj) {
        this.applyToDelegates(new DelegateOp(PlaceControllerDelegate.class){

            @Override
            public void apply(PlaceControllerDelegate delegate) {
                delegate.mayLeavePlace(plobj);
            }
        });
    }

    public void didLeavePlace(final PlaceObject plobj) {
        this.applyToDelegates(new DelegateOp(PlaceControllerDelegate.class){

            @Override
            public void apply(PlaceControllerDelegate delegate) {
                delegate.didLeavePlace(plobj);
            }
        });
        if (this._view != null) {
            PlaceViewUtil.dispatchDidLeavePlace(this._view, plobj);
            this._ctx.clearPlaceView(this._view);
            this._view = null;
        }
        this._plobj = null;
    }

    public boolean handleAction(final ActionEvent action) {
        final boolean[] handled = new boolean[1];
        this.applyToDelegates(new DelegateOp(PlaceControllerDelegate.class){

            @Override
            public void apply(PlaceControllerDelegate delegate) {
                handled[0] = handled[0] || delegate.handleAction(action);
            }
        });
        return handled[0] || super.handleAction(action);
    }

    protected void addDelegate(PlaceControllerDelegate delegate) {
        if (this._delegates == null) {
            this._delegates = Lists.newArrayList();
        }
        this._delegates.add(delegate);
    }

    protected void applyToDelegates(DelegateOp op) {
        if (this._delegates != null) {
            int ll = this._delegates.size();
            for (int ii = 0; ii < ll; ++ii) {
                PlaceControllerDelegate delegate = this._delegates.get(ii);
                if (!op.shouldApply(delegate)) continue;
                op.apply(delegate);
            }
        }
    }

    public static abstract class DelegateOp {
        protected Class<? extends PlaceControllerDelegate> _delegateClass;

        public DelegateOp(Class<? extends PlaceControllerDelegate> delegateClass) {
            this._delegateClass = delegateClass;
        }

        public abstract void apply(PlaceControllerDelegate var1);

        public boolean shouldApply(PlaceControllerDelegate delegate) {
            return this._delegateClass.isInstance(delegate);
        }
    }
}

