/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.chat.server;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Longs;
import com.google.inject.Inject;
import com.samskivert.util.ArrayIntSet;
import com.samskivert.util.ResultListener;
import com.threerings.crowd.Log;
import com.threerings.crowd.chat.data.ChannelSpeakMarshaller;
import com.threerings.crowd.chat.data.ChatChannel;
import com.threerings.crowd.chat.data.UserMessage;
import com.threerings.crowd.chat.server.ChannelSpeakProvider;
import com.threerings.crowd.chat.server.ChatHistory;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.peer.data.CrowdClientInfo;
import com.threerings.crowd.peer.data.CrowdNodeObject;
import com.threerings.crowd.peer.server.CrowdPeerManager;
import com.threerings.crowd.server.BodyLocator;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.data.InvocationException;
import com.threerings.presents.peer.data.ClientInfo;
import com.threerings.presents.peer.data.NodeObject;
import com.threerings.presents.peer.server.NodeRequestsListener;
import com.threerings.presents.peer.server.PeerManager;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.PresentsDObjectMgr;
import com.threerings.util.Name;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class ChatChannelManager
implements ChannelSpeakProvider {
    protected static final Predicate<ChatHistory.Entry> IS_USER_MESSAGE = new Predicate<ChatHistory.Entry>(){

        public boolean apply(ChatHistory.Entry entry) {
            return entry.message instanceof UserMessage;
        }
    };
    protected static final Comparator<ChatHistory.Entry> SORT_BY_TIMESTAMP = new Comparator<ChatHistory.Entry>(){

        @Override
        public int compare(ChatHistory.Entry e1, ChatHistory.Entry e2) {
            return Longs.compare((long)e1.message.timestamp, (long)e2.message.timestamp);
        }
    };
    protected Map<ChatChannel, List<UserMessage>> _resolving = Maps.newHashMap();
    protected Map<ChatChannel, ChannelInfo> _channels = Maps.newHashMap();
    @Inject
    protected CrowdPeerManager _peerMan;
    @Inject
    protected BodyLocator _locator;
    @Inject
    protected ChatHistory _chatHistory;
    protected static final long IDLE_CHANNEL_CHECK_PERIOD = 5000L;
    protected static final long IDLE_CHANNEL_CLOSE_TIME = 300000L;

    public void bodyAddedToChannel(ChatChannel channel, final int bodyId) {
        this._peerMan.invokeNodeAction(new ChannelAction(channel){

            @Override
            protected void execute() {
                ChannelInfo info = this._channelMan._channels.get(this._channel);
                if (info != null) {
                    info.participants.add(bodyId);
                } else if (this._channelMan._resolving.containsKey(this._channel)) {
                    Log.log.warning((Object)"Oh for fuck's sake, distributed systems are complicated", new Object[]{"channel", this._channel});
                }
            }
        });
    }

    public void bodyRemovedFromChannel(ChatChannel channel, final int bodyId) {
        this._peerMan.invokeNodeAction(new ChannelAction(channel){

            @Override
            protected void execute() {
                ChannelInfo info = this._channelMan._channels.get(this._channel);
                if (info != null) {
                    info.participants.remove(bodyId);
                } else if (this._channelMan._resolving.containsKey(this._channel)) {
                    Log.log.warning((Object)"Oh for fuck's sake, distributed systems are complicated", new Object[]{"channel", this._channel});
                }
            }
        });
    }

    public void collectChatHistory(final Name user, final ResultListener<ChatHistoryResult> lner) {
        this._peerMan.invokeNodeRequest(new PeerManager.NodeRequest(){
            @Inject
            protected transient ChatHistory _chatHistory;

            @Override
            public boolean isApplicable(NodeObject nodeobj) {
                return true;
            }

            @Override
            protected void execute(InvocationService.ResultListener listener) {
                listener.requestProcessed(Lists.newArrayList((Iterable)Iterables.filter(this._chatHistory.get(user), IS_USER_MESSAGE)));
            }
        }, new NodeRequestsListener<List<ChatHistory.Entry>>(){

            @Override
            public void requestsProcessed(NodeRequestsListener.NodeRequestsResult<List<ChatHistory.Entry>> rRes) {
                ChatHistoryResult chRes = new ChatHistoryResult();
                chRes.failedNodes = rRes.getNodeErrors().keySet();
                chRes.history = Lists.newArrayList((Iterable)Iterables.concat(rRes.getNodeResults().values()));
                Collections.sort(chRes.history, SORT_BY_TIMESTAMP);
                lner.requestCompleted((Object)chRes);
            }

            @Override
            public void requestFailed(String cause) {
                lner.requestFailed((Exception)new InvocationException(cause));
            }
        });
    }

    @Override
    public void speak(ClientObject caller, final ChatChannel channel, String message, byte mode) {
        BodyObject body = this._locator.forClient(caller);
        final UserMessage umsg = new UserMessage(body.getVisibleName(), null, message, mode);
        if (this._channels.containsKey(channel)) {
            this.dispatchSpeak(channel, umsg);
            return;
        }
        List<UserMessage> msgs = this._resolving.get(channel);
        if (msgs != null) {
            msgs.add(umsg);
            return;
        }
        this._peerMan.invokeNodeAction(new ChannelAction(channel){

            @Override
            protected void execute() {
                this._channelMan.dispatchSpeak(this._channel, umsg);
            }
        }, new Runnable(){

            @Override
            public void run() {
                ChatChannelManager.this._resolving.put(channel, Lists.newArrayList((Object[])new UserMessage[]{umsg}));
                ChatChannelManager.this.resolveAndDispatch(channel);
            }
        });
    }

    @Inject
    protected ChatChannelManager(PresentsDObjectMgr omgr, InvocationManager invmgr) {
        invmgr.registerProvider(this, ChannelSpeakMarshaller.class, "crowd");
        omgr.newInterval(new Runnable(){

            @Override
            public void run() {
                ChatChannelManager.this.closeIdleChannels();
            }
        }).schedule(5000L, true);
    }

    protected void resolveAndDispatch(final ChatChannel channel) {
        NodeObject.Lock lock = new NodeObject.Lock("ChatChannel", (Comparable<?>)((Object)channel.getLockName()));
        this._peerMan.performWithLock(lock, new PeerManager.LockedOperation(){

            @Override
            public void run() {
                ((CrowdNodeObject)ChatChannelManager.this._peerMan.getNodeObject()).addToHostedChannels(channel);
                ChatChannelManager.this.finishResolveAndDispatch(channel);
            }

            @Override
            public void fail(String peerName) {
                final List<UserMessage> msgs = ChatChannelManager.this._resolving.remove(channel);
                if (peerName == null) {
                    Log.log.warning((Object)"Failed to resolve chat channel due to lock failure", new Object[]{"channel", channel});
                } else {
                    ChatChannelManager.this._peerMan.invokeNodeAction(peerName, new ChannelAction(channel){

                        @Override
                        protected void execute() {
                            for (UserMessage msg : msgs) {
                                this._channelMan.dispatchSpeak(this._channel, msg);
                            }
                        }
                    });
                }
            }
        });
    }

    protected void finishResolveAndDispatch(ChatChannel channel) {
        this.resolutionComplete(channel, (Set<Integer>)new ArrayIntSet());
    }

    protected void resolutionComplete(ChatChannel channel, Set<Integer> parts) {
        ChannelInfo info = new ChannelInfo();
        info.channel = channel;
        info.participants = parts;
        this._channels.put(channel, info);
        for (UserMessage msg : this._resolving.remove(channel)) {
            this.dispatchSpeak(channel, msg);
        }
    }

    protected void resolutionFailed(ChatChannel channel, Exception cause) {
        Log.log.warning((Object)"Failed to resolve chat channel", new Object[]{"channel", channel, cause});
        this._resolving.remove(channel);
    }

    protected void dispatchSpeak(ChatChannel channel, final UserMessage message) {
        ChannelInfo info = this._channels.get(channel);
        if (info == null) {
            Log.log.warning((Object)"Requested to dispatch speak on unhosted channel", new Object[]{"channel", channel, "msg", message});
            return;
        }
        if (!info.participants.contains(this.getBodyId(message.speaker))) {
            Log.log.warning((Object)"Dropping channel chat message from non-speaker", new Object[]{"channel", channel, "message", message});
            return;
        }
        info.lastMessage = System.currentTimeMillis();
        HashMap partMap = Maps.newHashMap();
        for (NodeObject nodeObject : this._peerMan.getNodeObjects()) {
            ArrayIntSet nodeBodyIds = new ArrayIntSet();
            for (ClientInfo clinfo : nodeObject.clients) {
                int bodyId = this.getBodyId(((CrowdClientInfo)clinfo).visibleName);
                if (!info.participants.contains(bodyId)) continue;
                nodeBodyIds.add(bodyId);
            }
            partMap.put(nodeObject.nodeName, nodeBodyIds.toIntArray());
        }
        for (Map.Entry entry : partMap.entrySet()) {
            final int[] bodyIds = (int[])entry.getValue();
            this._peerMan.invokeNodeAction((String)entry.getKey(), new ChannelAction(channel){

                @Override
                protected void execute() {
                    this._channelMan.deliverSpeak(this._channel, message, bodyIds);
                }
            });
        }
    }

    protected void deliverSpeak(ChatChannel channel, UserMessage message, int[] bodyIds) {
        channel = this.intern(channel);
        for (int bodyId : bodyIds) {
            BodyObject bobj = this.getBodyObject(bodyId);
            if (bobj == null || !this.shouldDeliverSpeak(channel, message, bobj)) continue;
            this._chatHistory.record(channel, message, bobj.getVisibleName());
            bobj.postMessage("crowd.chat.channel", channel, message);
        }
    }

    protected void closeIdleChannels() {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<ChatChannel, ChannelInfo>> iter = this._channels.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<ChatChannel, ChannelInfo> entry = iter.next();
            if (now - entry.getValue().lastMessage <= 300000L) continue;
            ((CrowdNodeObject)this._peerMan.getNodeObject()).removeFromHostedChannels(entry.getKey());
            iter.remove();
        }
    }

    protected boolean shouldDeliverSpeak(ChatChannel channel, UserMessage message, BodyObject body) {
        return true;
    }

    protected ChatChannel intern(ChatChannel channel) {
        ChannelInfo chinfo = this._channels.get(channel);
        if (chinfo != null) {
            return chinfo.channel;
        }
        return channel;
    }

    protected abstract int getBodyId(Name var1);

    protected abstract BodyObject getBodyObject(int var1);

    protected static class ChannelInfo {
        public ChatChannel channel;
        public Set<Integer> participants;
        public long lastMessage;

        protected ChannelInfo() {
        }
    }

    protected static abstract class ChannelAction
    extends PeerManager.NodeAction {
        protected ChatChannel _channel;
        @Inject
        protected transient ChatChannelManager _channelMan;

        public ChannelAction(ChatChannel channel) {
            this._channel = channel;
        }

        @Override
        public boolean isApplicable(NodeObject nodeobj) {
            return ((CrowdNodeObject)nodeobj).hostedChannels.contains(this._channel);
        }
    }

    public static class ChatHistoryResult {
        public Set<String> failedNodes;
        public List<ChatHistory.Entry> history;
    }
}

