/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.chat.client;

import com.samskivert.util.ObserverList;
import com.threerings.crowd.chat.client.ChatDisplay;
import com.threerings.crowd.chat.data.ChatMessage;
import java.util.ArrayList;

public class HistoryList
extends ArrayList<ChatMessage>
implements ChatDisplay {
    protected ObserverList<Observer> _obs = ObserverList.newFastUnsafe();
    protected HistoryUpdatedOp _historyUpdatedOp = new HistoryUpdatedOp();
    protected static final int MAX_HISTORY = 2000;
    protected static final int PRUNE_HISTORY = 200;

    @Override
    public boolean displayMessage(ChatMessage msg, boolean alreadyDisplayed) {
        int adjusted;
        if (this.size() == 2000) {
            this.removeRange(0, 200);
            adjusted = 200;
        } else {
            adjusted = 0;
        }
        this.add(msg);
        this.notify(adjusted);
        return true;
    }

    @Override
    public void clear() {
        int adjusted = this.size();
        super.clear();
        this.notify(adjusted);
    }

    public void addObserver(Observer obs) {
        this._obs.add((Object)obs);
    }

    public void removeObserver(Observer obs) {
        this._obs.remove((Object)obs);
    }

    protected void notify(int adjustment) {
        this._historyUpdatedOp.setAdjustment(adjustment);
        this._obs.apply((ObserverList.ObserverOp)this._historyUpdatedOp);
    }

    protected static class HistoryUpdatedOp
    implements ObserverList.ObserverOp<Observer> {
        protected int _adjustment;

        protected HistoryUpdatedOp() {
        }

        public void setAdjustment(int adjustment) {
            this._adjustment = adjustment;
        }

        public boolean apply(Observer obs) {
            obs.historyUpdated(this._adjustment);
            return true;
        }
    }

    public static interface Observer {
        public void historyUpdated(int var1);
    }
}

