/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.admin.client;

import com.samskivert.swing.ScrollablePanel;
import com.samskivert.swing.VGroupLayout;
import com.samskivert.swing.util.SwingUtil;
import com.threerings.admin.Log;
import com.threerings.admin.data.ConfigObject;
import com.threerings.presents.dobj.ChangeListener;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.Subscriber;
import com.threerings.presents.util.PresentsContext;
import com.threerings.presents.util.SafeSubscriber;
import java.awt.LayoutManager;
import java.lang.reflect.Field;
import javax.swing.BorderFactory;
import javax.swing.JComponent;

public class ObjectEditorPanel
extends ScrollablePanel
implements Subscriber<ConfigObject> {
    protected PresentsContext _ctx;
    protected String _key;
    protected SafeSubscriber<ConfigObject> _safesub;
    protected ConfigObject _object;
    protected static final int BORDER = 5;

    public ObjectEditorPanel(PresentsContext ctx, String key, int oid) {
        super((LayoutManager)new VGroupLayout(VGroupLayout.NONE, VGroupLayout.STRETCH, 5, VGroupLayout.TOP));
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this._ctx = ctx;
        this._key = key;
        this._safesub = new SafeSubscriber<ConfigObject>(oid, this, new ChangeListener[0]);
        this._safesub.subscribe(this._ctx.getDObjectManager());
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public void cleanup() {
        this._safesub.unsubscribe(this._ctx.getDObjectManager());
        this._object = null;
        this.removeAll();
    }

    @Override
    public void objectAvailable(ConfigObject object) {
        this._object = object;
        try {
            Field[] fields;
            for (Field field : fields = object.getClass().getFields()) {
                if (field.getModifiers() != 1) continue;
                this.add(this._object.getEditor(this._ctx, field));
            }
        }
        catch (SecurityException se) {
            Log.log.warning((Object)("Unable to introspect DObject!? " + se), new Object[0]);
        }
        SwingUtil.refresh((JComponent)((Object)this));
    }

    @Override
    public void requestFailed(int oid, ObjectAccessException cause) {
        Log.log.warning((Object)("Unable to subscribe to config object: " + cause), new Object[0]);
    }
}

