/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server;

import com.google.inject.AbstractModule;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Singleton;
import com.samskivert.util.Invoker;
import com.samskivert.util.Lifecycle;
import com.samskivert.util.RunQueue;
import com.samskivert.util.SystemInfo;
import com.threerings.nio.conman.ConnectionManager;
import com.threerings.nio.conman.ServerSocketChannelAcceptor;
import com.threerings.presents.Log;
import com.threerings.presents.annotation.AuthInvoker;
import com.threerings.presents.annotation.EventQueue;
import com.threerings.presents.annotation.MainInvoker;
import com.threerings.presents.annotation.PeerInvoker;
import com.threerings.presents.client.Client;
import com.threerings.presents.dobj.AccessController;
import com.threerings.presents.dobj.DObjectManager;
import com.threerings.presents.dobj.RootDObjectManager;
import com.threerings.presents.server.ClientManager;
import com.threerings.presents.server.InvocationManager;
import com.threerings.presents.server.PresentsAuthInvoker;
import com.threerings.presents.server.PresentsDObjectMgr;
import com.threerings.presents.server.PresentsInvoker;
import com.threerings.presents.server.PresentsObjectAccess;
import com.threerings.presents.server.SunSignalHandler;
import com.threerings.presents.server.TimeBaseProvider;
import com.threerings.presents.server.net.DatagramChannelReader;
import com.threerings.presents.server.net.PresentsConnectionManager;

@Singleton
public class PresentsServer {
    @Deprecated
    public static PresentsDObjectMgr omgr;
    @Deprecated
    public static InvocationManager invmgr;
    protected ServerSocketChannelAcceptor _socketAcceptor;
    protected DatagramChannelReader _datagramReader;
    @Inject
    protected PresentsDObjectMgr _omgr;
    @Inject
    protected PresentsConnectionManager _conmgr;
    @Inject
    protected ClientManager _clmgr;
    @Inject
    protected InvocationManager _invmgr;
    @Inject
    protected Lifecycle _lifecycle;
    @Inject
    @MainInvoker
    protected Invoker _invoker;
    @Inject
    @AuthInvoker
    protected Invoker _authInvoker;

    public static void runServer(Module ... modules) {
        Injector injector = Guice.createInjector((Module[])modules);
        PresentsServer server = (PresentsServer)injector.getInstance(PresentsServer.class);
        try {
            server.init(injector);
            String testmod = System.getProperty("test_module");
            if (testmod != null) {
                try {
                    Log.log.info((Object)"Invoking test module", new Object[]{"mod", testmod});
                    Class<?> tmclass = Class.forName(testmod);
                    Runnable trun = (Runnable)tmclass.newInstance();
                    trun.run();
                }
                catch (Exception e) {
                    Log.log.warning((Object)("Unable to invoke test module '" + testmod + "'."), new Object[]{e});
                }
            }
            server.run();
        }
        catch (Throwable t) {
            Log.log.warning((Object)"Unable to initialize server.", new Object[]{t});
            System.exit(-1);
        }
    }

    public static void main(String[] args) {
        PresentsServer.runServer(new Module[]{new PresentsModule()});
    }

    public void init(Injector injector) throws Exception {
        SystemInfo si = new SystemInfo();
        Log.log.info((Object)"Starting up", new Object[]{"server", this.getClass().getSimpleName(), "os", si.osToString(), "jvm", si.jvmToString()});
        this.registerSignalHandlers(injector);
        omgr = this._omgr;
        invmgr = this._invmgr;
        this._omgr.setDefaultAccessController(this.createDefaultObjectAccessController());
        this._invoker.start();
        this._authInvoker.start();
        ((PresentsInvoker)this._invoker).addInterdependentInvoker(this._authInvoker);
        this._clmgr.setInjector(injector);
        this._socketAcceptor = this.createSocketAcceptor();
        this._lifecycle.addComponent((Lifecycle.BaseComponent)this._socketAcceptor);
        this._datagramReader = new DatagramChannelReader(this.getDatagramHostname(), this.getDatagramPorts(), this._conmgr);
        this._lifecycle.addComponent((Lifecycle.BaseComponent)this._datagramReader);
        TimeBaseProvider.init(this._invmgr, this._omgr);
        this._lifecycle.addShutdownConstraint((Lifecycle.ShutdownComponent)this._clmgr, Lifecycle.Constraint.RUNS_BEFORE, (Lifecycle.ShutdownComponent)((PresentsInvoker)this._invoker));
        this._lifecycle.init();
    }

    protected void registerSignalHandlers(Injector injector) {
        try {
            ((SunSignalHandler)injector.getInstance(SunSignalHandler.class)).init();
        }
        catch (Throwable t) {
            Log.log.warning((Object)"Unable to register Sun signal handlers", new Object[]{"error", t});
        }
    }

    protected ServerSocketChannelAcceptor createSocketAcceptor() {
        return new ServerSocketChannelAcceptor(this.getBindHostname(), this.getListenPorts(), this._conmgr);
    }

    public void run() {
        ((PresentsInvoker)this._invoker).postRunnableWhenEmpty(new Runnable(){

            @Override
            public void run() {
                PresentsServer.this._omgr.postRunnable(new PresentsDObjectMgr.LongRunnable(){

                    @Override
                    public void run() {
                        PresentsServer.this.openToThePublic();
                    }
                });
            }
        });
        this._omgr.run();
    }

    protected void openToThePublic() {
        if (this.getListenPorts().length != 0 && !this._socketAcceptor.bind()) {
            this.queueShutdown();
        } else {
            this._datagramReader.bind();
            this._conmgr.start();
        }
    }

    public void queueShutdown() {
        this._omgr.postRunnable(new PresentsDObjectMgr.LongRunnable(){

            @Override
            public void run() {
                PresentsServer.this._lifecycle.shutdown();
            }
        });
    }

    protected AccessController createDefaultObjectAccessController() {
        return PresentsObjectAccess.DEFAULT;
    }

    protected String getBindHostname() {
        return null;
    }

    protected String getDatagramHostname() {
        return null;
    }

    protected int[] getListenPorts() {
        return Client.DEFAULT_SERVER_PORTS;
    }

    protected int[] getDatagramPorts() {
        return Client.DEFAULT_DATAGRAM_PORTS;
    }

    protected void invokerDidShutdown() {
    }

    public static class PresentsServerModule
    extends AbstractModule {
        protected final Class<? extends PresentsServer> _serverType;

        public PresentsServerModule(Class<? extends PresentsServer> serverType) {
            this._serverType = serverType;
        }

        protected void configure() {
            this.bind(PresentsServer.class).to(this._serverType);
        }
    }

    public static class PresentsModule
    extends AbstractModule {
        protected void configure() {
            this.bindInvokers();
            this.bindPeerInvoker();
            this.bind(ConnectionManager.class).to(PresentsConnectionManager.class);
            this.bind(RunQueue.class).annotatedWith(EventQueue.class).to(PresentsDObjectMgr.class);
            this.bind(DObjectManager.class).to(PresentsDObjectMgr.class);
            this.bind(RootDObjectManager.class).to(PresentsDObjectMgr.class);
            this.bind(Lifecycle.class).toInstance((Object)new Lifecycle());
        }

        protected void bindInvokers() {
            this.bind(Invoker.class).annotatedWith(MainInvoker.class).to(PresentsInvoker.class);
            this.bind(Invoker.class).annotatedWith(AuthInvoker.class).to(PresentsAuthInvoker.class);
        }

        protected void bindPeerInvoker() {
            this.bind(Invoker.class).annotatedWith(PeerInvoker.class).to(Key.get(Invoker.class, MainInvoker.class));
        }
    }
}

