/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.client;

import com.google.common.collect.Sets;
import com.samskivert.util.Interval;
import com.samskivert.util.ObserverList;
import com.samskivert.util.RunAnywhere;
import com.samskivert.util.RunQueue;
import com.samskivert.util.StringUtil;
import com.samskivert.util.Throttle;
import com.threerings.presents.Log;
import com.threerings.presents.client.ClientAdapter;
import com.threerings.presents.client.ClientCommunicator;
import com.threerings.presents.client.ClientDObjectMgr;
import com.threerings.presents.client.ClientObserver;
import com.threerings.presents.client.Communicator;
import com.threerings.presents.client.DeltaCalculator;
import com.threerings.presents.client.InvocationDirector;
import com.threerings.presents.client.InvocationService;
import com.threerings.presents.client.LogonException;
import com.threerings.presents.client.MessageTracker;
import com.threerings.presents.client.ObserverOps;
import com.threerings.presents.client.SessionObserver;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.DEvent;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DObjectManager;
import com.threerings.presents.net.AuthResponseData;
import com.threerings.presents.net.BootstrapData;
import com.threerings.presents.net.Credentials;
import com.threerings.presents.net.PingRequest;
import com.threerings.presents.net.PongResponse;
import com.threerings.presents.net.ThrottleUpdatedMessage;
import com.threerings.presents.util.SecureUtil;
import java.security.PublicKey;
import java.util.HashSet;

public class Client {
    public static final int[] DEFAULT_SERVER_PORTS = new int[]{47624};
    public static final int[] DEFAULT_DATAGRAM_PORTS = new int[0];
    public static final int MAX_DATAGRAM_SIZE = 1450;
    public static final int DEFAULT_MSGS_PER_SECOND = 10;
    protected Credentials _creds;
    protected String _version = "";
    protected RunQueue _runQueue;
    protected DObjectManager _omgr;
    protected AuthResponseData _authData;
    protected PublicKey _publicKey;
    protected byte[] _secret;
    protected boolean _requireSecureAuth = false;
    protected int _connectionId = -1;
    protected int _cloid = -1;
    protected ClientObject _clobj;
    protected boolean _standalone;
    protected String _hostname;
    protected int[] _ports;
    protected int[] _datagramPorts;
    protected ObserverList<SessionObserver> _observers = ObserverList.newSafeInOrder();
    protected Communicator _comm;
    protected ClassLoader _loader = this.getClass().getClassLoader();
    protected BootstrapData _bstrap;
    protected HashSet<String> _bootGroups = Sets.newHashSet();
    protected InvocationDirector _invdir;
    protected long _serverDelta;
    protected DeltaCalculator _dcalc;
    protected long _lastSync;
    protected Interval _tickInterval;
    protected Throttle _outThrottle;
    protected volatile MessageTracker _messageTracker;
    protected static final long CLOCK_SYNC_INTERVAL = 600000L;

    public Client(Credentials creds, RunQueue runQueue) {
        this._bootGroups.add("presents");
        this._invdir = new InvocationDirector();
        this._outThrottle = new Throttle(10, 1000L);
        this._messageTracker = MessageTracker.NOOP;
        this._creds = creds;
        this._runQueue = runQueue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addClientObserver(SessionObserver observer) {
        ObserverList<SessionObserver> observerList = this._observers;
        synchronized (observerList) {
            this._observers.add((Object)observer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeClientObserver(SessionObserver observer) {
        ObserverList<SessionObserver> observerList = this._observers;
        synchronized (observerList) {
            this._observers.remove((Object)observer);
        }
    }

    public boolean isStandalone() {
        return this._standalone;
    }

    public void setServer(String hostname, int[] ports) {
        this.setServer(hostname, ports, new int[0]);
    }

    public void setServer(String hostname, int[] ports, int[] datagramPorts) {
        this._hostname = hostname;
        this._ports = ports;
        this._datagramPorts = datagramPorts;
    }

    public RunQueue getRunQueue() {
        return this._runQueue;
    }

    public String getHostname() {
        return this._hostname;
    }

    public int[] getPorts() {
        return this._ports;
    }

    public int[] getDatagramPorts() {
        return this._datagramPorts;
    }

    public Credentials getCredentials() {
        return this._creds;
    }

    public void setCredentials(Credentials creds) {
        this._creds = creds;
    }

    public PublicKey getPublicKey() {
        return this._publicKey;
    }

    public boolean setPublicKey(PublicKey key) {
        if (SecureUtil.ciphersSupported(key)) {
            this._publicKey = key;
            return true;
        }
        return false;
    }

    public boolean setPublicKey(String key) {
        return key == null ? false : this.setPublicKey(SecureUtil.stringToRSAPublicKey(key));
    }

    public void setRequireSecureAuth(boolean requireSecureAuth) {
        this._requireSecureAuth = requireSecureAuth;
    }

    public boolean requireSecureAuth() {
        return this._requireSecureAuth;
    }

    public void setSecret(byte[] secret) {
        this._secret = secret;
    }

    public byte[] getSecret() {
        return this._secret;
    }

    public String getVersion() {
        return this._version;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
        if (this._comm != null) {
            this._comm.setClassLoader(loader);
        }
    }

    public void setMessageTracker(MessageTracker tracker) {
        this._messageTracker = tracker == null ? MessageTracker.NOOP : tracker;
    }

    public AuthResponseData getAuthResponseData() {
        return this._authData;
    }

    public DObjectManager getDObjectManager() {
        return this._omgr;
    }

    public void registerFlushDelay(Class<?> objclass, long delay) {
        ClientDObjectMgr omgr = (ClientDObjectMgr)this.getDObjectManager();
        omgr.registerFlushDelay(objclass, delay);
    }

    public int getConnectionId() {
        return this._connectionId;
    }

    public int getClientOid() {
        return this._cloid;
    }

    public ClientObject getClientObject() {
        return this._clobj;
    }

    public InvocationDirector getInvocationDirector() {
        return this._invdir;
    }

    public void addServiceGroup(String group) {
        if (this.isLoggedOn()) {
            throw new IllegalStateException("Service groups must be registered prior to logon.");
        }
        this._bootGroups.add(group);
    }

    public String[] getBootGroups() {
        return this._bootGroups.toArray(new String[this._bootGroups.size()]);
    }

    public <T> T getService(Class<T> sclass) {
        if (this._bstrap == null) {
            return null;
        }
        int scount = this._bstrap.services.size();
        for (int ii = 0; ii < scount; ++ii) {
            InvocationService service = this._bstrap.services.get(ii);
            if (!sclass.isInstance(service)) continue;
            return sclass.cast(service);
        }
        return null;
    }

    public <T> T requireService(Class<T> sclass) {
        T isvc = this.getService(sclass);
        if (isvc == null) {
            throw new RuntimeException(sclass.getName() + " isn't available. I can't bear to go on.");
        }
        return isvc;
    }

    public BootstrapData getBootstrapData() {
        return this._bstrap;
    }

    public long fromServerTime(long stamp) {
        return stamp + this._serverDelta;
    }

    public long toServerTime(long stamp) {
        return stamp - this._serverDelta;
    }

    public synchronized boolean isActive() {
        return this._comm != null;
    }

    public synchronized boolean getTransmitDatagrams() {
        return this._comm != null && this._comm.getTransmitDatagrams();
    }

    public synchronized boolean isLoggedOn() {
        return this._clobj != null;
    }

    public synchronized boolean logon() {
        if (this._comm != null) {
            return false;
        }
        this._observers.apply((ObserverList.ObserverOp)new ObserverOps.Session(this){

            @Override
            protected void notify(SessionObserver obs) {
                obs.clientWillLogon(this._client);
            }
        });
        this._comm = this.createCommunicator();
        this._comm.setClassLoader(this._loader);
        this._comm.logon();
        if (this._tickInterval == null) {
            this._tickInterval = new Interval(this._runQueue){

                public void expired() {
                    Client.this.tick();
                }

                public String toString() {
                    return "Client.tickInterval";
                }
            };
            this._tickInterval.schedule(5000L, true);
        }
        return true;
    }

    public void moveToServer(String hostname, int[] ports, InvocationService.ConfirmListener obs) {
        this.moveToServer(hostname, ports, new int[0], obs);
    }

    public void moveToServer(String hostname, int[] ports, int[] datagramPorts, InvocationService.ConfirmListener obs) {
        new ServerSwitcher(hostname, ports, datagramPorts, obs).switchServers();
    }

    public boolean logoff(boolean abortable) {
        if (this._comm == null) {
            Log.log.warning((Object)"Ignoring request to logoff because we're not logged on.", new Object[0]);
            return true;
        }
        final boolean[] rejected = new boolean[]{false};
        this._observers.apply((ObserverList.ObserverOp)new ObserverOps.Client(this){

            @Override
            protected void notify(ClientObserver obs) {
                if (!obs.clientWillLogoff(this._client)) {
                    rejected[0] = true;
                }
            }
        });
        if (abortable && rejected[0]) {
            return false;
        }
        this._comm.logoff();
        return true;
    }

    public String[] prepareStandaloneLogon() {
        this._standalone = true;
        this._observers.apply((ObserverList.ObserverOp)new ObserverOps.Session(this){

            @Override
            protected void notify(SessionObserver obs) {
                obs.clientWillLogon(this._client);
            }
        });
        return this.getBootGroups();
    }

    public void standaloneLogon(BootstrapData data, DObjectManager omgr) {
        if (!this._standalone) {
            throw new IllegalStateException("Must call prepareStandaloneLogon() first.");
        }
        this.gotBootstrap(data, omgr);
    }

    public void standaloneLogoff() {
        this.notifyObservers(new ObserverOps.Session(this){

            @Override
            protected void notify(SessionObserver obs) {
                obs.clientDidLogoff(this._client);
            }
        });
        this.cleanup(null);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getClass().getSimpleName()).append(" [");
        this.fieldsToString(builder);
        builder.append("]");
        return builder.toString();
    }

    public void fieldsToString(StringBuilder builder) {
        builder.append("hostname=").append(this._hostname);
        if (this._ports != null && this._ports.length > 0) {
            builder.append(", ports=");
            StringUtil.toString((StringBuilder)builder, (Object)this._ports);
        }
        if (this._datagramPorts != null && this._datagramPorts.length > 0) {
            builder.append(", datagramPorts=");
            StringUtil.toString((StringBuilder)builder, (Object)this._datagramPorts);
        }
        builder.append(", clOid=").append(this._cloid);
        builder.append(", connId=").append(this._connectionId);
        builder.append(", creds=");
        StringUtil.toString((StringBuilder)builder, (Object)this._creds);
    }

    protected void gotBootstrap(BootstrapData data, DObjectManager omgr) {
        if (this.debugLogMessages()) {
            Log.log.info((Object)("Got bootstrap " + data + "."), new Object[0]);
        }
        this._bstrap = data;
        this._omgr = omgr;
        this._connectionId = data.connectionId;
        this._cloid = data.clientOid;
        if (this._comm != null) {
            this._comm.gotBootstrap();
        }
        this._invdir.init(omgr, this._cloid, this);
        this.establishClockDelta(System.currentTimeMillis());
    }

    protected void convertFromRemote(DObject target, DEvent event) {
    }

    protected Communicator createCommunicator() {
        return new ClientCommunicator(this);
    }

    protected synchronized void setOutgoingMessageThrottle(int msgsPerSec) {
        Log.log.info((Object)"Updating outgoing message throttle", new Object[]{"msgsPerSec", msgsPerSec});
        this._outThrottle.reinit(msgsPerSec, 1000L);
        this._comm.postMessage(new ThrottleUpdatedMessage());
    }

    protected synchronized Throttle getOutgoingMessageThrottle() {
        return this._outThrottle;
    }

    protected MessageTracker getMessageTracker() {
        return this._messageTracker;
    }

    protected void tick() {
        if (this._comm == null) {
            return;
        }
        long now = RunAnywhere.currentTimeMillis();
        if (this._dcalc != null) {
            if (this._dcalc.isDone()) {
                if (this.debugLogMessages()) {
                    Log.log.info((Object)("Time offset from server: " + this._serverDelta + "ms."), new Object[0]);
                }
                this._dcalc = null;
            } else if (this._dcalc.shouldSendPing()) {
                PingRequest req = new PingRequest();
                this._comm.postMessage(req);
                this._dcalc.sentPing(req);
            }
        } else if (this._comm.isLogoned() && now - this._comm.getLastWrite() > 60000L) {
            this._comm.postMessage(new PingRequest());
        } else if (now - this._lastSync > 600000L) {
            this.establishClockDelta(now);
        }
    }

    protected void establishClockDelta(long now) {
        if (this._comm != null) {
            this._dcalc = new DeltaCalculator();
            PingRequest req = new PingRequest();
            this._comm.postMessage(req);
            this._dcalc.sentPing(req);
            this._lastSync = now;
        }
    }

    protected void reportLogonTribulations(final LogonException cause) {
        this.notifyObservers(new ObserverOps.Client(this){

            @Override
            protected void notify(ClientObserver obs) {
                obs.clientFailedToLogon(this._client, cause);
            }
        });
    }

    protected void gotClientObject(ClientObject clobj) {
        this._clobj = clobj;
        this.notifyObservers(new ObserverOps.Session(this){

            @Override
            protected void notify(SessionObserver obs) {
                obs.clientDidLogon(this._client);
            }
        });
    }

    protected void getClientObjectFailed(final Exception cause) {
        this.notifyObservers(new ObserverOps.Client(this){

            @Override
            protected void notify(ClientObserver obs) {
                obs.clientFailedToLogon(this._client, cause);
            }
        });
    }

    protected void clientObjectDidChange(ClientObject clobj) {
        this._clobj = clobj;
        this._cloid = this._clobj.getOid();
        this.notifyObservers(new ObserverOps.Session(this){

            @Override
            protected void notify(SessionObserver obs) {
                obs.clientObjectDidChange(this._client);
            }
        });
    }

    protected void notifyObservers(final ObserverOps.Session op) {
        if (this._runQueue == null) {
            this._observers.apply((ObserverList.ObserverOp)op);
        } else {
            this._runQueue.postRunnable(new Runnable(){

                @Override
                public void run() {
                    Client.this._observers.apply((ObserverList.ObserverOp)op);
                }
            });
        }
    }

    protected synchronized void cleanup(final Exception logonError) {
        if (this._tickInterval != null) {
            this._tickInterval.cancel();
            this._tickInterval = null;
        }
        this._outThrottle = new Throttle(10, 1000L);
        this._runQueue.postRunnable(new Runnable(){

            @Override
            public void run() {
                if (Client.this._omgr instanceof ClientDObjectMgr) {
                    ((ClientDObjectMgr)Client.this._omgr).cleanup();
                }
                Client.this._comm = null;
                Client.this._bstrap = null;
                Client.this._omgr = null;
                Client.this._clobj = null;
                Client.this._cloid = -1;
                Client.this._connectionId = -1;
                Client.this._standalone = false;
                Client.this._invdir.cleanup();
                Client.this.notifyObservers(new ObserverOps.Client(Client.this){

                    @Override
                    protected void notify(ClientObserver obs) {
                        if (logonError != null) {
                            obs.clientFailedToLogon(this._client, logonError);
                        } else {
                            obs.clientDidClear(this._client);
                        }
                    }
                });
            }
        });
    }

    protected void gotPong(PongResponse pong) {
        if (this._dcalc != null) {
            this._dcalc.gotPong(pong);
            this._serverDelta = this._dcalc.getTimeDelta();
        }
    }

    protected boolean debugLogMessages() {
        return false;
    }

    protected class ServerSwitcher
    extends ClientAdapter {
        protected String _hostname;
        protected String _oldHostname;
        protected int[] _ports;
        protected int[] _oldPorts;
        protected int[] _datagramPorts;
        protected int[] _oldDatagramPorts;
        protected InvocationService.ConfirmListener _observer;

        public ServerSwitcher(String hostname, int[] ports, InvocationService.ConfirmListener obs) {
            this(hostname, ports, new int[0], obs);
        }

        public ServerSwitcher(String hostname, int[] ports, int[] datagramPorts, InvocationService.ConfirmListener obs) {
            this._hostname = hostname;
            this._ports = ports;
            this._datagramPorts = datagramPorts;
            this._observer = obs;
        }

        public void switchServers() {
            Client.this.addClientObserver(this);
            if (!Client.this.isLoggedOn()) {
                this.clientDidClear(Client.this);
            } else {
                this._oldHostname = Client.this._hostname;
                this._oldPorts = Client.this._ports;
                this._oldDatagramPorts = Client.this._datagramPorts;
                Client.this.logoff(true);
            }
        }

        @Override
        public void clientDidClear(Client client) {
            Client.this.setServer(this._hostname, this._ports, this._datagramPorts);
            if (!Client.this.logon()) {
                Log.log.warning((Object)"logon() failed during server switch?", new Object[]{"hostname", this._hostname, "ports", this._ports, "datagramPorts", this._datagramPorts});
                this.clientFailedToLogon(Client.this, new Exception("logon() failed?"));
            }
        }

        @Override
        public void clientDidLogon(Client client) {
            Client.this.removeClientObserver(this);
            if (this._observer != null) {
                this._observer.requestProcessed();
            }
        }

        @Override
        public void clientFailedToLogon(Client client, Exception cause) {
            Client.this.removeClientObserver(this);
            if (this._oldHostname != null) {
                Client.this.setServer(this._oldHostname, this._oldPorts, this._oldDatagramPorts);
            }
            if (this._observer != null) {
                this._observer.requestFailed(cause instanceof LogonException ? cause.getMessage() : "m.server_error");
            }
        }
    }
}

