/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.client;

import com.threerings.presents.client.Client;
import com.threerings.presents.client.SessionObserver;
import com.threerings.presents.util.PresentsContext;

public class BasicDirector
implements SessionObserver {
    protected PresentsContext _ctx;
    protected boolean _availableInStandalone = true;

    protected BasicDirector(PresentsContext ctx) {
        this._ctx = ctx;
        Client client = ctx.getClient();
        client.addClientObserver(this);
        if (client.isLoggedOn()) {
            if (this.isAvailable()) {
                this.registerServices(client);
                this.fetchServices(client);
            }
            this.clientObjectUpdated(client);
        }
    }

    @Override
    public void clientWillLogon(Client client) {
        this.registerServices(client);
    }

    @Override
    public void clientDidLogon(Client client) {
        if (this.isAvailable()) {
            this.fetchServices(client);
        }
        this.clientObjectUpdated(client);
    }

    @Override
    public void clientObjectDidChange(Client client) {
        this.clientObjectUpdated(client);
    }

    @Override
    public void clientDidLogoff(Client client) {
    }

    public void setAvailableInStandalone(boolean available) {
        this._availableInStandalone = available;
    }

    public boolean isAvailableInStandalone() {
        return this._availableInStandalone;
    }

    protected boolean isAvailable() {
        return this.isAvailableInStandalone() || !this._ctx.getClient().isStandalone();
    }

    protected void assertAvailable() {
        if (!this.isAvailable()) {
            throw new RuntimeException(this.getClass().getName() + " not available in standalone mode!");
        }
    }

    protected void clientObjectUpdated(Client client) {
    }

    protected void registerServices(Client client) {
    }

    protected void fetchServices(Client client) {
    }
}

