/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.nio.conman;

import com.threerings.NaryaLog;
import com.threerings.nio.conman.ConnectionManager;
import com.threerings.nio.conman.NetEventHandler;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicBoolean;

public abstract class Connection
implements NetEventHandler {
    public SelectionKey selkey;
    public AtomicBoolean postClose = new AtomicBoolean(false);
    protected ConnectionManager _cmgr;
    protected SocketChannel _channel;
    protected long _lastEvent;
    protected int _connectionId;
    protected static int _lastConnectionId;

    public void init(ConnectionManager cmgr, SocketChannel channel, long createStamp) throws IOException {
        this._cmgr = cmgr;
        this._channel = channel;
        this._lastEvent = createStamp;
        this._connectionId = ++_lastConnectionId;
    }

    public int getConnectionId() {
        return this._connectionId;
    }

    public SocketChannel getChannel() {
        return this._channel;
    }

    public InetAddress getInetAddress() {
        return this._channel == null ? null : this._channel.socket().getInetAddress();
    }

    public boolean isClosed() {
        return this._channel == null;
    }

    public void close() {
        if (!this.postClose.compareAndSet(false, true)) {
            return;
        }
        if (this.isClosed()) {
            NaryaLog.log.warning((Object)("Attempted to re-close connection " + this + "."), new Object[]{new Exception()});
            return;
        }
        this._cmgr.connectionClosed(this);
        this.closeSocket();
    }

    public void asyncClose() {
        this._cmgr.postAsyncClose(this);
    }

    public void connectFailure(IOException ioe) {
        this.closeSocket();
    }

    public void networkFailure(IOException ioe) {
        if (this.isClosed()) {
            NaryaLog.log.warning((Object)("Failure reported on closed connection " + this + "."), new Object[]{new Exception()});
            return;
        }
        this._cmgr.connectionFailed(this, ioe);
        this.closeSocket();
    }

    @Override
    public boolean checkIdle(long idleStamp) {
        if (this._lastEvent > idleStamp) {
            return false;
        }
        if (!this.isClosed()) {
            NaryaLog.log.info((Object)"Disconnecting non-communicative client", new Object[]{"conn", this, "idle", System.currentTimeMillis() - this._lastEvent + "ms"});
        }
        return true;
    }

    @Override
    public void becameIdle() {
        this._cmgr.closeConnection(this);
    }

    public String toString() {
        return "[id=" + this._connectionId + ", addr=" + this.getInetAddress() + "]";
    }

    protected void closeSocket() {
        if (this._channel == null) {
            return;
        }
        NaryaLog.log.debug((Object)("Closing channel " + this + "."), new Object[0]);
        try {
            this._channel.close();
        }
        catch (IOException ioe) {
            NaryaLog.log.warning((Object)"Error closing connection", new Object[]{"conn", this, "error", ioe});
        }
        this._channel = null;
    }
}

