/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.admin.server;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.util.Invoker;
import com.threerings.admin.Log;
import com.threerings.admin.server.ConfigRegistry;
import com.threerings.admin.server.DatabaseConfigRegistry;
import com.threerings.io.Streamable;
import com.threerings.presents.annotation.MainInvoker;
import com.threerings.presents.dobj.AttributeChangedEvent;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.peer.server.PeerManager;
import com.threerings.util.StreamableTuple;
import java.util.ArrayList;

@Singleton
public class PeeredDatabaseConfigRegistry
extends DatabaseConfigRegistry {
    protected PeerManager _peermgr;
    protected static final String PEER_CACHE_PREFIX = "PeerConfigCache:";

    @Inject
    public PeeredDatabaseConfigRegistry(PersistenceContext ctx, @MainInvoker Invoker invoker, PeerManager peermgr) {
        super(ctx, invoker, "");
        this._peermgr = peermgr;
    }

    @Override
    protected ConfigRegistry.ObjectRecord createObjectRecord(String path, DObject object) {
        return new PeerDatabaseObjectRecord(path, object);
    }

    protected class PeerDatabaseObjectRecord
    extends DatabaseConfigRegistry.DatabaseObjectRecord
    implements PeerManager.StaleCacheObserver {
        protected ArrayList<String> _pendingSyncs;

        public PeerDatabaseObjectRecord(String path, DObject object) {
            super(path, object);
            this._pendingSyncs = Lists.newArrayList();
            PeeredDatabaseConfigRegistry.this._peermgr.addStaleCacheObserver(PeeredDatabaseConfigRegistry.PEER_CACHE_PREFIX + this._path, this);
        }

        @Override
        public void changedCacheData(Streamable data) {
            StreamableTuple change = (StreamableTuple)data;
            try {
                this.object.changeAttribute((String)change.left, change.right);
                this._pendingSyncs.add((String)change.left);
            }
            catch (Exception e) {
                Log.log.warning((Object)("Config attribute sync failed " + change + "."), new Object[]{e});
            }
        }

        @Override
        public void attributeChanged(AttributeChangedEvent event) {
            if (!this._pendingSyncs.remove(event.getName())) {
                super.attributeChanged(event);
            }
        }

        @Override
        protected void updateValue(String name, Object value) {
            super.updateValue(name, value);
            this.fieldUpdated(name, value);
        }

        protected void fieldUpdated(String field, Object value) {
            PeeredDatabaseConfigRegistry.this._peermgr.broadcastStaleCacheData(PeeredDatabaseConfigRegistry.PEER_CACHE_PREFIX + this._path, new StreamableTuple<String, Object>(field, value));
        }
    }
}

