/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.admin.server;

import com.google.common.collect.Maps;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.depot.DatabaseException;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.jdbc.WriteOnlyUnit;
import com.samskivert.util.Invoker;
import com.samskivert.util.StringUtil;
import com.threerings.admin.Log;
import com.threerings.admin.server.ConfigRegistry;
import com.threerings.admin.server.persist.ConfigRepository;
import com.threerings.presents.annotation.MainInvoker;
import com.threerings.presents.dobj.DObject;
import java.util.HashMap;

@Singleton
public class DatabaseConfigRegistry
extends ConfigRegistry {
    protected ConfigRepository _repo;
    protected Invoker _invoker;
    protected String _node;

    @Inject
    public DatabaseConfigRegistry(PersistenceContext ctx, @MainInvoker Invoker invoker) {
        this(ctx, invoker, false);
    }

    public DatabaseConfigRegistry(PersistenceContext ctx, Invoker invoker, boolean transitioning) {
        this(ctx, invoker, "", transitioning);
    }

    public DatabaseConfigRegistry(PersistenceContext ctx, Invoker invoker, String node) {
        this(ctx, invoker, node, false);
    }

    public DatabaseConfigRegistry(PersistenceContext ctx, Invoker invoker, String node, boolean transitioning) {
        super(transitioning);
        this._repo = new ConfigRepository(ctx);
        this._invoker = invoker;
        this._node = StringUtil.isBlank((String)node) ? "" : node;
    }

    @Override
    protected ConfigRegistry.ObjectRecord createObjectRecord(String path, DObject object) {
        return new DatabaseObjectRecord(path, object);
    }

    protected class DatabaseObjectRecord
    extends ConfigRegistry.ObjectRecord {
        protected String _path;
        protected HashMap<String, String> _data;

        public DatabaseObjectRecord(String path, DObject object) {
            super(object);
            this._path = path;
        }

        @Override
        public void init() {
            try {
                this._data = DatabaseConfigRegistry.this._repo.loadConfig(DatabaseConfigRegistry.this._node, this._path);
            }
            catch (DatabaseException pe) {
                Log.log.warning((Object)"Failed to load object configuration", new Object[]{"path", this._path, pe});
                this._data = Maps.newHashMap();
            }
            super.init();
        }

        @Override
        protected boolean getValue(String field, boolean defval) {
            String value = this._data.get(field);
            if (value != null) {
                return "true".equalsIgnoreCase(value);
            }
            return defval;
        }

        @Override
        protected byte getValue(String field, byte defval) {
            String value = this._data.get(field);
            try {
                if (value != null) {
                    return Byte.parseByte(value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defval;
        }

        @Override
        protected short getValue(String field, short defval) {
            String value = this._data.get(field);
            try {
                if (value != null) {
                    return Short.parseShort(value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defval;
        }

        @Override
        protected int getValue(String field, int defval) {
            String value = this._data.get(field);
            try {
                if (value != null) {
                    return Integer.parseInt(value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defval;
        }

        @Override
        protected long getValue(String field, long defval) {
            String value = this._data.get(field);
            try {
                if (value != null) {
                    return Long.parseLong(value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defval;
        }

        @Override
        protected float getValue(String field, float defval) {
            String value = this._data.get(field);
            try {
                if (value != null) {
                    return Float.parseFloat(value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defval;
        }

        @Override
        protected String getValue(String field, String defval) {
            String value = this._data.get(field);
            return value == null ? defval : value;
        }

        @Override
        protected int[] getValue(String field, int[] defval) {
            String value = this._data.get(field);
            try {
                int[] avalue;
                if (value != null && (avalue = StringUtil.parseIntArray((String)value)) != null) {
                    return avalue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defval;
        }

        @Override
        protected float[] getValue(String field, float[] defval) {
            String value = this._data.get(field);
            try {
                float[] avalue;
                if (value != null && (avalue = StringUtil.parseFloatArray((String)value)) != null) {
                    return avalue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defval;
        }

        @Override
        protected long[] getValue(String field, long[] defval) {
            String value = this._data.get(field);
            try {
                long[] avalue;
                if (value != null && (avalue = StringUtil.parseLongArray((String)value)) != null) {
                    return avalue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defval;
        }

        @Override
        protected String[] getValue(String field, String[] defval) {
            String value = this._data.get(field);
            try {
                if (value != null) {
                    return StringUtil.parseStringArray((String)value);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return defval;
        }

        @Override
        protected void setValue(String field, boolean value) {
            this.setAndFlush(field, String.valueOf(value));
        }

        @Override
        protected void setValue(String field, byte value) {
            this.setAndFlush(field, String.valueOf(value));
        }

        @Override
        protected void setValue(String field, short value) {
            this.setAndFlush(field, String.valueOf(value));
        }

        @Override
        protected void setValue(String field, int value) {
            this.setAndFlush(field, String.valueOf(value));
        }

        @Override
        protected void setValue(String field, long value) {
            this.setAndFlush(field, String.valueOf(value));
        }

        @Override
        protected void setValue(String field, float value) {
            this.setAndFlush(field, String.valueOf(value));
        }

        @Override
        protected void setValue(String field, String value) {
            this.setAndFlush(field, value);
        }

        @Override
        protected void setValue(String field, int[] value) {
            this.setAndFlush(field, StringUtil.toString((Object)value, (String)"", (String)""));
        }

        @Override
        protected void setValue(String field, float[] value) {
            this.setAndFlush(field, StringUtil.toString((Object)value, (String)"", (String)""));
        }

        @Override
        protected void setValue(String field, long[] value) {
            this.setAndFlush(field, StringUtil.toString((Object)value, (String)"", (String)""));
        }

        @Override
        protected void setValue(String field, String[] value) {
            this.setAndFlush(field, StringUtil.joinEscaped((String[])value));
        }

        protected void setAndFlush(String field, String value) {
            this._data.put(field, value);
            this.flush(field, value);
        }

        protected void flush(final String field, final String value) {
            String iname = "updateConfig(" + this._path + ", " + field + ", value=" + value + ")";
            DatabaseConfigRegistry.this._invoker.postUnit((Invoker.Unit)new WriteOnlyUnit(iname){

                public void invokePersist() throws Exception {
                    DatabaseConfigRegistry.this._repo.updateConfig(DatabaseConfigRegistry.this._node, DatabaseObjectRecord.this._path, field, value);
                }
            });
        }
    }
}

