/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.admin.server;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.samskivert.util.StringUtil;
import com.threerings.admin.Log;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.Streamer;
import com.threerings.presents.dobj.AttributeChangeListener;
import com.threerings.presents.dobj.AttributeChangedEvent;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.ElementUpdateListener;
import com.threerings.presents.dobj.ElementUpdatedEvent;
import com.threerings.presents.dobj.EntryAddedEvent;
import com.threerings.presents.dobj.EntryRemovedEvent;
import com.threerings.presents.dobj.EntryUpdatedEvent;
import com.threerings.presents.dobj.SetListener;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.HashMap;

public abstract class ConfigRegistry {
    protected HashMap<String, ObjectRecord> _configs = Maps.newHashMap();
    protected boolean _transitioning;
    protected Serializer _serializer = new DefaultSerializer();

    public ConfigRegistry() {
        this(false);
    }

    public ConfigRegistry(boolean transitioning) {
        this._transitioning = transitioning;
    }

    public void setSerializer(Serializer serializer) {
        Preconditions.checkState((boolean)this._configs.isEmpty(), (Object)"Must set serializer before registering config objects.");
        this._serializer = serializer;
    }

    public void registerObject(String key, String path, DObject object) {
        ObjectRecord record = this.createObjectRecord(path, object);
        record.init();
        this._configs.put(key, record);
    }

    public DObject getObject(String key) {
        ObjectRecord record = this._configs.get(key);
        return record == null ? null : record.object;
    }

    public String[] getKeys() {
        return this._configs.keySet().toArray(new String[this._configs.size()]);
    }

    protected abstract ObjectRecord createObjectRecord(String var1, DObject var2);

    protected static class DefaultSerializer
    implements Serializer {
        protected DefaultSerializer() {
        }

        @Override
        public String serialize(String name, Object value) throws Exception {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oout = this.createObjectOutputStream(out);
            oout.writeObject(value);
            oout.flush();
            return StringUtil.hexlate((byte[])out.toByteArray());
        }

        @Override
        public Object deserialize(String value) throws Exception {
            ByteArrayInputStream bin = new ByteArrayInputStream(StringUtil.unhexlate((String)value));
            ObjectInputStream oin = this.createObjectInputStream(bin);
            return oin.readObject();
        }

        protected ObjectInputStream createObjectInputStream(InputStream bin) {
            return new ObjectInputStream(bin);
        }

        protected ObjectOutputStream createObjectOutputStream(OutputStream bin) {
            return new ObjectOutputStream(bin);
        }
    }

    protected abstract class ObjectRecord
    implements AttributeChangeListener,
    SetListener<DSet.Entry>,
    ElementUpdateListener {
        public DObject object;

        public ObjectRecord(DObject obj) {
            this.object = obj;
        }

        public void init() {
            Class<?> cclass = this.object.getClass();
            try {
                Field[] fields;
                for (Field field : fields = cclass.getFields()) {
                    int mods = field.getModifiers();
                    if ((mods & 8) != 0 || (mods & 1) == 0 || (mods & 0x80) != 0) continue;
                    this.initField(field);
                }
                this.object.addListener(this);
            }
            catch (SecurityException se) {
                Log.log.warning((Object)("Unable to reflect on " + cclass.getName() + ": " + se + ". Refusing to monitor object."), new Object[0]);
            }
        }

        @Override
        public void entryAdded(EntryAddedEvent<DSet.Entry> event) {
            this.serializeAttribute(event.getName());
        }

        @Override
        public void entryUpdated(EntryUpdatedEvent<DSet.Entry> event) {
            this.serializeAttribute(event.getName());
        }

        @Override
        public void entryRemoved(EntryRemovedEvent<DSet.Entry> event) {
            this.serializeAttribute(event.getName());
        }

        @Override
        public void elementUpdated(ElementUpdatedEvent event) {
            this.updateValue(event.getName(), this.object.getAttribute(event.getName()));
        }

        @Override
        public void attributeChanged(AttributeChangedEvent event) {
            this.updateValue(event.getName(), event.getValue());
        }

        protected void updateValue(String name, Object value) {
            String key = this.nameToKey(name);
            if (value instanceof Boolean) {
                this.setValue(key, (Boolean)value);
            } else if (value instanceof Byte) {
                this.setValue(key, (Byte)value);
            } else if (value instanceof Short) {
                this.setValue(key, (Short)value);
            } else if (value instanceof Integer) {
                this.setValue(key, (Integer)value);
            } else if (value instanceof Long) {
                this.setValue(key, (Long)value);
            } else if (value instanceof Float) {
                this.setValue(key, ((Float)value).floatValue());
            } else if (value instanceof String) {
                this.setValue(key, (String)value);
            } else if (value instanceof float[]) {
                this.setValue(key, (float[])value);
            } else if (value instanceof int[]) {
                this.setValue(key, (int[])value);
            } else if (value instanceof String[]) {
                this.setValue(key, (String[])value);
            } else if (value instanceof long[]) {
                this.setValue(key, (long[])value);
            } else if (value == null || Streamer.isStreamable(value.getClass())) {
                this.serializeAttribute(name);
            } else {
                Log.log.info((Object)"Unable to flush config obj change", new Object[]{"cobj", this.object.getClass().getName(), "key", key, "type", value.getClass().getName(), "value", value});
            }
        }

        protected void initField(Field field) {
            block18: {
                String key = this.nameToKey(field.getName());
                Class<?> type = field.getType();
                try {
                    if (type.equals(Boolean.TYPE)) {
                        boolean defval = field.getBoolean(this.object);
                        field.setBoolean(this.object, this.getValue(key, defval));
                        break block18;
                    }
                    if (type.equals(Byte.TYPE)) {
                        byte defval = field.getByte(this.object);
                        field.setByte(this.object, this.getValue(key, defval));
                        break block18;
                    }
                    if (type.equals(Short.TYPE)) {
                        short defval = field.getShort(this.object);
                        field.setShort(this.object, this.getValue(key, defval));
                        break block18;
                    }
                    if (type.equals(Integer.TYPE)) {
                        int defval = field.getInt(this.object);
                        field.setInt(this.object, this.getValue(key, defval));
                        break block18;
                    }
                    if (type.equals(Long.TYPE)) {
                        long defval = field.getLong(this.object);
                        field.setLong(this.object, this.getValue(key, defval));
                        break block18;
                    }
                    if (type.equals(Float.TYPE)) {
                        float defval = field.getFloat(this.object);
                        field.setFloat(this.object, this.getValue(key, defval));
                        break block18;
                    }
                    if (type.equals(String.class)) {
                        String defval = (String)field.get(this.object);
                        field.set(this.object, this.getValue(key, defval));
                        break block18;
                    }
                    if (type.equals(int[].class)) {
                        int[] defval = (int[])field.get(this.object);
                        field.set(this.object, this.getValue(key, defval));
                        break block18;
                    }
                    if (type.equals(float[].class)) {
                        float[] defval = (float[])field.get(this.object);
                        field.set(this.object, this.getValue(key, defval));
                        break block18;
                    }
                    if (type.equals(String[].class)) {
                        String[] defval = (String[])field.get(this.object);
                        field.set(this.object, this.getValue(key, defval));
                        break block18;
                    }
                    if (type.equals(long[].class)) {
                        long[] defval = (long[])field.get(this.object);
                        field.set(this.object, this.getValue(key, defval));
                        break block18;
                    }
                    if (Streamer.isStreamable(type)) {
                        String value = this.getValue(key, "");
                        if (StringUtil.isBlank((String)value)) {
                            return;
                        }
                        try {
                            Object deserializedValue = ConfigRegistry.this._serializer.deserialize(value);
                            field.set(this.object, deserializedValue);
                            if (ConfigRegistry.this._transitioning) {
                                this.setValue(this.nameToKey(key), ConfigRegistry.this._serializer.serialize(key, deserializedValue));
                            }
                            break block18;
                        }
                        catch (Exception e) {
                            Log.log.warning((Object)"Failure decoding config value", new Object[]{"type", type, "field", field, "exception", e});
                        }
                        break block18;
                    }
                    Log.log.warning((Object)"Can't init field of unknown type", new Object[]{"cobj", this.object.getClass().getName(), "key", key, "type", type.getName()});
                }
                catch (IllegalAccessException iae) {
                    Log.log.warning((Object)"Can't set field", new Object[]{"cobj", this.object.getClass().getName(), "key", key, "error", iae});
                }
            }
        }

        protected void serializeAttribute(String attributeName) {
            String key = this.nameToKey(attributeName);
            Object value = this.object.getAttribute(attributeName);
            if (value == null || Streamer.isStreamable(value.getClass())) {
                try {
                    this.setValue(key, ConfigRegistry.this._serializer.serialize(attributeName, value));
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Error serializing", new Object[]{"name", attributeName, "value", value});
                }
            } else {
                Log.log.info((Object)"Unable to flush config obj change", new Object[]{"cobj", this.object.getClass().getName(), "key", key, "type", value.getClass().getName(), "value", value});
            }
        }

        protected String nameToKey(String attributeName) {
            return StringUtil.unStudlyName((String)attributeName).toLowerCase();
        }

        protected abstract boolean getValue(String var1, boolean var2);

        protected abstract byte getValue(String var1, byte var2);

        protected abstract short getValue(String var1, short var2);

        protected abstract int getValue(String var1, int var2);

        protected abstract long getValue(String var1, long var2);

        protected abstract float getValue(String var1, float var2);

        protected abstract String getValue(String var1, String var2);

        protected abstract int[] getValue(String var1, int[] var2);

        protected abstract float[] getValue(String var1, float[] var2);

        protected abstract long[] getValue(String var1, long[] var2);

        protected abstract String[] getValue(String var1, String[] var2);

        protected abstract void setValue(String var1, boolean var2);

        protected abstract void setValue(String var1, byte var2);

        protected abstract void setValue(String var1, short var2);

        protected abstract void setValue(String var1, int var2);

        protected abstract void setValue(String var1, long var2);

        protected abstract void setValue(String var1, float var2);

        protected abstract void setValue(String var1, String var2);

        protected abstract void setValue(String var1, int[] var2);

        protected abstract void setValue(String var1, float[] var2);

        protected abstract void setValue(String var1, long[] var2);

        protected abstract void setValue(String var1, String[] var2);
    }

    public static interface Serializer {
        public String serialize(String var1, Object var2) throws Exception;

        public Object deserialize(String var1) throws Exception;
    }
}

