/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.admin.client;

import com.google.common.collect.Maps;
import com.threerings.admin.Log;
import com.threerings.admin.client.AdminService;
import com.threerings.admin.data.ConfigObject;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.ClientAdapter;
import com.threerings.presents.dobj.DObjectManager;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.Subscriber;
import java.util.HashMap;

public class ConfigObjectManager
implements AdminService.ConfigInfoListener {
    protected ConfigObjectSubscriber[] _csubscribers;
    protected HashMap<String, ConfigObject> _serverconfig = Maps.newHashMap();
    protected DObjectManager _dobjmgr;
    protected AdminService _service;
    protected Client _client;

    public ConfigObjectManager(Client client) {
        this._client = client;
        this._client.addClientObserver(new ClientAdapter(){

            @Override
            public void clientWillLogon(Client client) {
                client.addServiceGroup("presents.admin");
            }

            @Override
            public void clientDidLogon(Client client) {
                ConfigObjectManager.this._dobjmgr = ConfigObjectManager.this._client.getDObjectManager();
                ConfigObjectManager.this._service = client.requireService(AdminService.class);
                ConfigObjectManager.this.getConfigInfo();
            }

            @Override
            public void clientDidLogoff(Client client) {
                for (ConfigObjectSubscriber _csubscriber : ConfigObjectManager.this._csubscribers) {
                    _csubscriber.cleanup();
                }
            }
        });
    }

    public ConfigObject getServerConfig(String key) {
        return this._serverconfig.get(key);
    }

    @Override
    public void gotConfigInfo(String[] keys, int[] oids) {
        this._csubscribers = new ConfigObjectSubscriber[keys.length];
        for (int ii = 0; ii < keys.length; ++ii) {
            this._csubscribers[ii] = new ConfigObjectSubscriber();
            this._csubscribers[ii].subscribeConfig(keys[ii], oids[ii]);
        }
    }

    @Override
    public void requestFailed(String reason) {
        Log.log.warning((Object)("Oh bugger, we didn't get the config data: " + reason), new Object[0]);
    }

    protected void getConfigInfo() {
        this._service.getConfigInfo(this);
    }

    protected class ConfigObjectSubscriber
    implements Subscriber<ConfigObject> {
        protected ConfigObject _cobj;
        protected String _key;
        protected int _oid;

        protected ConfigObjectSubscriber() {
        }

        public void subscribeConfig(String key, int oid) {
            this._key = key;
            this._oid = oid;
            ConfigObjectManager.this._dobjmgr.subscribeToObject(this._oid, this);
        }

        @Override
        public void objectAvailable(ConfigObject object) {
            this._cobj = object;
            ConfigObjectManager.this._serverconfig.put(this._key, this._cobj);
        }

        @Override
        public void requestFailed(int oid, ObjectAccessException cause) {
            Log.log.warning((Object)("Unable to subscribe to config object " + this._key), new Object[0]);
        }

        public void cleanup() {
            ConfigObjectManager.this._dobjmgr.unsubscribeFromObject(this._oid, this);
            this._cobj = null;
            ConfigObjectManager.this._serverconfig.remove(this._key);
        }
    }
}

