/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.threerings.presents.dobj.DEvent;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DObjectManager;
import com.threerings.presents.dobj.Subscriber;
import com.threerings.presents.server.PresentsDObjectMgr;
import com.threerings.presents.server.ReportManager;
import java.awt.EventQueue;

@Singleton
public class LocalDObjectMgr
extends PresentsDObjectMgr {
    @Inject
    public LocalDObjectMgr(ReportManager repmgr) {
        super(repmgr);
    }

    public DObjectManager getClientDObjectMgr(final int clientOid) {
        return new DObjectManager(){

            @Override
            public boolean isManager(DObject object) {
                return LocalDObjectMgr.this.isManager(object);
            }

            @Override
            public <T extends DObject> void subscribeToObject(int oid, Subscriber<T> target) {
                LocalDObjectMgr.this.subscribeToObject(oid, target);
            }

            @Override
            public <T extends DObject> void unsubscribeFromObject(int oid, Subscriber<T> target) {
                LocalDObjectMgr.this.unsubscribeFromObject(oid, target);
            }

            @Override
            public void postEvent(DEvent event) {
                event.setSourceOid(clientOid);
                LocalDObjectMgr.this.postEvent(event);
            }

            @Override
            public void removedLastSubscriber(DObject obj, boolean deathWish) {
                LocalDObjectMgr.this.removedLastSubscriber(obj, deathWish);
            }
        };
    }

    @Override
    public synchronized boolean isDispatchThread() {
        return EventQueue.isDispatchThread();
    }

    @Override
    public void postEvent(final DEvent event) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                LocalDObjectMgr.this.processUnit(event);
            }
        });
    }

    @Override
    public void postRunnable(Runnable unit) {
        EventQueue.invokeLater(unit);
    }
}

