/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.samskivert.util.LRUHashMap;
import com.samskivert.util.StringUtil;
import com.threerings.presents.Log;
import com.threerings.presents.client.Client;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.data.InvocationException;
import com.threerings.presents.data.InvocationMarshaller;
import com.threerings.presents.dobj.DEvent;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.EventListener;
import com.threerings.presents.dobj.InvocationRequestEvent;
import com.threerings.presents.net.Transport;
import com.threerings.presents.server.InvocationDispatcher;
import com.threerings.presents.server.InvocationProvider;
import com.threerings.presents.server.PresentsDObjectMgr;
import java.lang.reflect.Field;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@Singleton
public class InvocationManager
implements EventListener {
    protected int _invoid = -1;
    protected int _invCode;
    @Inject(optional=true)
    protected Client _standaloneClient;
    protected PresentsDObjectMgr _omgr;
    protected IntMap<Dispatcher> _dispatchers = IntMaps.newHashIntMap();
    protected Multimap<String, InvocationMarshaller<?>> _bootlists = ArrayListMultimap.create();
    protected final Map<Integer, String> _recentRegServices = new LRUHashMap(10000);
    protected static final String FAILED_SUFFIX = "Failed";

    @Inject
    public InvocationManager(PresentsDObjectMgr omgr) {
        this._omgr = omgr;
        this._omgr._invmgr = this;
        DObject invobj = this._omgr.registerObject(new DObject());
        invobj.addListener(this);
        this._invoid = invobj.getOid();
        Log.log.debug((Object)"Created invocation service object", new Object[]{"oid", this._invoid});
    }

    public int getOid() {
        return this._invoid;
    }

    public <T extends InvocationMarshaller<?>> T registerProvider(InvocationProvider provider, Class<T> mclass) {
        return this.registerProvider(provider, mclass, null);
    }

    public <T extends InvocationMarshaller<?>> T registerProvider(final InvocationProvider provider, Class<T> mclass, String group) {
        InvocationMarshaller marsh;
        int n;
        int n2;
        GenericDeclaration[] genericDeclarationArray;
        this._omgr.requireEventThread();
        GenericDeclaration pclass = provider.getClass();
        String pname = mclass.getSimpleName().replaceAll("Marshaller", "Provider");
        Class<?> sclass = pclass;
        block6: while (sclass != null) {
            genericDeclarationArray = sclass.getInterfaces();
            n2 = genericDeclarationArray.length;
            n = 0;
            while (n < n2) {
                GenericDeclaration iclass = genericDeclarationArray[n];
                if (InvocationProvider.class.isAssignableFrom((Class<?>)iclass) && ((Class)iclass).getSimpleName().equals(pname)) {
                    pclass = iclass;
                    break block6;
                }
                ++n;
            }
            sclass = sclass.getSuperclass();
        }
        final HashMap invmeths = Maps.newHashMap();
        genericDeclarationArray = pclass.getMethods();
        n2 = genericDeclarationArray.length;
        n = 0;
        while (n < n2) {
            GenericDeclaration method = genericDeclarationArray[n];
            Class<?>[] ptypes = ((Method)method).getParameterTypes();
            if (ptypes.length != 0 && ClientObject.class.isAssignableFrom(ptypes[0])) {
                try {
                    Field code = mclass.getField(StringUtil.unStudlyName((String)((Method)method).getName()));
                    invmeths.put(code.getInt(null), method);
                }
                catch (IllegalAccessException iae) {
                    throw new RuntimeException(iae);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                    // empty catch block
                }
            }
            ++n;
        }
        int invCode = this.nextInvCode();
        try {
            marsh = (InvocationMarshaller)mclass.newInstance();
            marsh.init(this._invoid, invCode, this._standaloneClient == null ? null : this._standaloneClient.getInvocationDirector());
        }
        catch (IllegalAccessException ie) {
            throw new RuntimeException(ie);
        }
        catch (InstantiationException ie) {
            throw new RuntimeException(ie);
        }
        this._dispatchers.put(invCode, (Object)new Dispatcher(){

            @Override
            public InvocationProvider getProvider() {
                return provider;
            }

            @Override
            public void dispatchRequest(ClientObject source, int methodId, Object[] args) throws InvocationException {
                Method m = (Method)invmeths.get(methodId);
                if (m == null) {
                    String pclass = StringUtil.shortClassName(provider.getClass());
                    Log.log.warning((Object)"Requested to dispatch unknown method", new Object[]{"source", source.who(), "methodId", methodId, "provider", pclass, "args", args});
                    throw new InvocationException("e.internal_error");
                }
                Object[] fargs = new Object[args.length + 1];
                System.arraycopy(args, 0, fargs, 1, args.length);
                fargs[0] = source;
                try {
                    m.invoke((Object)provider, fargs);
                }
                catch (IllegalAccessException ie) {
                    throw new RuntimeException(ie);
                }
                catch (InvocationTargetException ite) {
                    Throwable cause = ite.getCause();
                    if (cause instanceof InvocationException) {
                        throw (InvocationException)cause;
                    }
                    Log.log.warning((Object)"Invocation service method failure", new Object[]{"provider", StringUtil.shortClassName(provider.getClass()), "method", m.getName(), "args", fargs, cause});
                    throw new InvocationException("e.internal_error");
                }
            }
        });
        if (group != null) {
            this._bootlists.put((Object)group, (Object)marsh);
        }
        this._recentRegServices.put(invCode, marsh.getClass().getName());
        Log.log.debug((Object)"Registered service", new Object[]{"code", invCode, "marsh", marsh});
        return (T)marsh;
    }

    public <T extends InvocationMarshaller<?>> T registerDispatcher(InvocationDispatcher<T> dispatcher) {
        return this.registerDispatcher(dispatcher, null);
    }

    @Deprecated
    public <T extends InvocationMarshaller<?>> T registerDispatcher(InvocationDispatcher<T> dispatcher, boolean bootstrap) {
        return this.registerDispatcher(dispatcher, null);
    }

    public <T extends InvocationMarshaller<?>> T registerDispatcher(InvocationDispatcher<T> dispatcher, String group) {
        this._omgr.requireEventThread();
        int invCode = this.nextInvCode();
        T marsh = dispatcher.createMarshaller();
        ((InvocationMarshaller)marsh).init(this._invoid, invCode, this._standaloneClient == null ? null : this._standaloneClient.getInvocationDirector());
        this._dispatchers.put(invCode, dispatcher);
        if (group != null) {
            this._bootlists.put((Object)group, marsh);
        }
        this._recentRegServices.put(invCode, marsh.getClass().getName());
        Log.log.debug((Object)"Registered service", new Object[]{"code", invCode, "marsh", marsh});
        return marsh;
    }

    public void clearDispatcher(InvocationMarshaller<?> marsh) {
        this._omgr.requireEventThread();
        if (marsh == null) {
            Log.log.warning((Object)"Refusing to unregister null marshaller.", new Object[]{new Exception()});
            return;
        }
        if (this._dispatchers.remove(marsh.getInvocationCode()) == null) {
            Log.log.warning((Object)"Requested to remove unregistered marshaller?", new Object[]{"marsh", marsh, new Exception()});
        }
    }

    public List<InvocationMarshaller<?>> getBootstrapServices(String[] bootGroups) {
        ArrayList services = Lists.newArrayList();
        String[] stringArray = bootGroups;
        int n = bootGroups.length;
        int n2 = 0;
        while (n2 < n) {
            String group = stringArray[n2];
            services.addAll(this._bootlists.get((Object)group));
            ++n2;
        }
        return services;
    }

    public Class<?> getDispatcherClass(int invCode) {
        Object dispatcher = this._dispatchers.get(invCode);
        return dispatcher == null ? null : dispatcher.getClass();
    }

    @Override
    public void eventReceived(DEvent event) {
        Log.log.debug((Object)"Event received", new Object[]{"event", event});
        if (event instanceof InvocationRequestEvent) {
            InvocationRequestEvent ire = (InvocationRequestEvent)event;
            this.dispatchRequest(ire.getSourceOid(), ire.getInvCode(), ire.getMethodId(), ire.getArgs(), ire.getTransport());
        }
    }

    protected void dispatchRequest(int clientOid, int invCode, int methodId, Object[] args, Transport transport) {
        block11: {
            ClientObject source = (ClientObject)this._omgr.getObject(clientOid);
            if (source == null) {
                Log.log.info((Object)"Client no longer around for invocation request", new Object[]{"clientOid", clientOid, "code", invCode, "methId", methodId, "args", args});
                return;
            }
            Dispatcher disp = (Dispatcher)this._dispatchers.get(invCode);
            if (disp == null) {
                Log.log.info((Object)"Received invocation request but dispatcher registration was already cleared", new Object[]{"code", invCode, "methId", methodId, "args", args, "marsh", this._recentRegServices.get(invCode)});
                return;
            }
            InvocationMarshaller.ListenerMarshaller rlist = null;
            int acount = args.length;
            int ii = 0;
            while (ii < acount) {
                Object arg = args[ii];
                if (arg instanceof InvocationMarshaller.ListenerMarshaller) {
                    InvocationMarshaller.ListenerMarshaller list = (InvocationMarshaller.ListenerMarshaller)arg;
                    list.callerOid = clientOid;
                    list.omgr = this._omgr;
                    list.transport = transport;
                    if (rlist == null) {
                        rlist = list;
                    }
                }
                ++ii;
            }
            Log.log.debug((Object)"Dispatching invreq", new Object[]{"caller", source.who(), "provider", disp.getProvider(), "methId", methodId, "args", args});
            try {
                if (rlist != null) {
                    rlist.setInvocationId(String.valueOf(StringUtil.shortClassName((Object)disp.getProvider())) + ", methodId=" + methodId);
                }
                disp.dispatchRequest(source, methodId, args);
            }
            catch (InvocationException ie) {
                if (rlist != null) {
                    rlist.requestFailed(ie.getMessage());
                } else {
                    Log.log.warning((Object)"Service request failed but we've got no listener to inform of the failure", new Object[]{"caller", source.who(), "code", invCode, "provider", disp.getProvider(), "methodId", methodId, "args", args, "error", ie});
                }
            }
            catch (Throwable t) {
                Log.log.warning((Object)"Dispatcher choked", new Object[]{"provider", disp.getProvider(), "caller", source.who(), "methId", methodId, "args", args, t});
                if (rlist == null) break block11;
                rlist.setNoResponse();
            }
        }
    }

    protected synchronized int nextInvCode() {
        return this._invCode++;
    }

    protected static interface Dispatcher {
        public InvocationProvider getProvider();

        public void dispatchRequest(ClientObject var1, int var2, Object[] var3) throws InvocationException;
    }
}

