/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.samskivert.util.Invoker;
import com.threerings.presents.Log;
import com.threerings.presents.annotation.MainInvoker;
import com.threerings.presents.data.ClientObject;
import com.threerings.presents.dobj.RootDObjectManager;
import com.threerings.presents.server.ClientLocal;
import com.threerings.presents.server.ClientManager;
import com.threerings.presents.server.ClientResolutionListener;
import com.threerings.util.Name;
import java.util.List;

public class ClientResolver
extends Invoker.Unit {
    protected Name _username;
    protected List<ClientResolutionListener> _listeners = Lists.newArrayList();
    protected ClientObject _clobj;
    protected Exception _failure;
    @Inject
    @MainInvoker
    protected Invoker _invoker;
    @Inject
    protected RootDObjectManager _omgr;
    @Inject
    protected ClientManager _clmgr;

    public void init(Name username) {
        this._username = username;
    }

    public void addResolutionListener(ClientResolutionListener listener) {
        this._listeners.add(listener);
    }

    public ClientObject createClientObject() {
        return new ClientObject();
    }

    public ClientLocal createLocalAttribute() {
        return new ClientLocal();
    }

    public void objectAvailable(ClientObject object) {
        this._clobj = object;
        this._invoker.postUnit((Invoker.Unit)this);
    }

    public boolean invoke() {
        try {
            this.resolveClientData(this._clobj);
        }
        catch (Exception cause) {
            this._failure = cause;
        }
        return true;
    }

    public void handleResult() {
        if (this._failure == null) {
            try {
                this.finishResolution(this._clobj);
            }
            catch (Exception e) {
                this._failure = e;
            }
        }
        if (this._failure == null) {
            this.reportSuccess();
        } else {
            this._omgr.destroyObject(this._clobj.getOid());
            this.reportFailure(this._failure);
        }
    }

    public String toString() {
        return "ClientResolver:" + this._username;
    }

    protected void resolveClientData(ClientObject clobj) throws Exception {
        clobj.username = this._username;
    }

    protected void finishResolution(ClientObject clobj) {
    }

    protected void reportSuccess() {
        int ii = 0;
        int ll = this._listeners.size();
        while (ii < ll) {
            ClientResolutionListener crl = this._listeners.get(ii);
            try {
                this._clobj.reference();
                crl.clientResolved(this._username, this._clobj);
            }
            catch (Exception e) {
                Log.log.warning((Object)("Client resolution listener choked in clientResolved() " + crl), new Object[]{e});
            }
            ++ii;
        }
    }

    protected void reportFailure(Exception cause) {
        int ii = 0;
        int ll = this._listeners.size();
        while (ii < ll) {
            ClientResolutionListener crl = this._listeners.get(ii);
            try {
                crl.resolutionFailed(this._username, cause);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Client resolution listener choked in resolutionFailed()", new Object[]{"crl", crl, "username", this._username, "cause", cause, e});
            }
            ++ii;
        }
    }

    protected void enforceConnected() throws ClientDisconnectedException {
        if (this._clmgr.getClient(this._username) == null) {
            throw new ClientDisconnectedException();
        }
    }

    public static class ClientDisconnectedException
    extends Exception {
    }
}

