/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.peer.server.persist;

import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.samskivert.depot.DepotRepository;
import com.samskivert.depot.Ops;
import com.samskivert.depot.PersistenceContext;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.Query;
import com.samskivert.depot.expression.SQLExpression;
import com.samskivert.util.StringUtil;
import com.threerings.presents.peer.server.persist.NodeRecord;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

@Singleton
public class NodeRepository
extends DepotRepository {
    @Inject
    public NodeRepository(PersistenceContext ctx) {
        super(ctx);
    }

    public List<NodeRecord> loadNodes() {
        return this.loadNodes("", false);
    }

    public List<NodeRecord> loadNodes(String namespace) {
        return this.loadNodes(namespace, false);
    }

    public List<NodeRecord> loadNodes(String namespace, boolean includeShutdown) {
        Query query = this.from(NodeRecord.class).noCache();
        ArrayList conditions = Lists.newArrayList();
        if (!StringUtil.isBlank((String)namespace)) {
            conditions.add(NodeRecord.NODE_NAME.like((Comparable)((Object)(String.valueOf(namespace) + "%"))));
        }
        if (!includeShutdown) {
            conditions.add(Ops.not(NodeRecord.SHUTDOWN));
        }
        return (conditions.isEmpty() ? query : query.where((Iterable)conditions)).select();
    }

    public List<NodeRecord> loadNodesFromRegion(String region) {
        return this.from(NodeRecord.class).noCache().where(new SQLExpression[]{NodeRecord.REGION.eq((Comparable)((Object)region)), Ops.not(NodeRecord.SHUTDOWN)}).select();
    }

    public void updateNode(NodeRecord record) {
        record.lastUpdated = new Timestamp(System.currentTimeMillis());
        this.store(record);
    }

    public void heartbeatNode(String nodeName) {
        this.updatePartial(NodeRecord.getKey(nodeName), NodeRecord.LAST_UPDATED, new Timestamp(System.currentTimeMillis()), new Object[0]);
    }

    public void shutdownNode(String nodeName) {
        this.updatePartial(NodeRecord.getKey(nodeName), NodeRecord.SHUTDOWN, true, new Object[0]);
    }

    protected void getManagedRecords(Set<Class<? extends PersistentRecord>> classes) {
        classes.add(NodeRecord.class);
    }
}

