/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.peer.server.persist;

import com.google.common.base.Objects;
import com.samskivert.depot.Key;
import com.samskivert.depot.PersistentRecord;
import com.samskivert.depot.annotation.Column;
import com.samskivert.depot.annotation.Entity;
import com.samskivert.depot.annotation.Id;
import com.samskivert.depot.expression.ColumnExp;
import com.samskivert.util.StringUtil;
import java.sql.Timestamp;

@Entity(name="NODES")
public class NodeRecord
extends PersistentRecord {
    public static final Class<NodeRecord> _R = NodeRecord.class;
    public static final ColumnExp<String> NODE_NAME = NodeRecord.colexp(_R, (String)"nodeName");
    public static final ColumnExp<String> HOST_NAME = NodeRecord.colexp(_R, (String)"hostName");
    public static final ColumnExp<String> PUBLIC_HOST_NAME = NodeRecord.colexp(_R, (String)"publicHostName");
    public static final ColumnExp<String> REGION = NodeRecord.colexp(_R, (String)"region");
    public static final ColumnExp<Integer> PORT = NodeRecord.colexp(_R, (String)"port");
    public static final ColumnExp<Timestamp> LAST_UPDATED = NodeRecord.colexp(_R, (String)"lastUpdated");
    public static final ColumnExp<Boolean> SHUTDOWN = NodeRecord.colexp(_R, (String)"shutdown");
    public static final int SCHEMA_VERSION = 3;
    @Id
    @Column(name="NODE_NAME", length=64)
    public String nodeName;
    @Column(name="HOST_NAME", length=64)
    public String hostName;
    @Column(name="PUBLIC_HOST_NAME", length=64)
    public String publicHostName;
    @Column(name="REGION", length=64, nullable=true)
    public String region;
    @Column(name="PORT")
    public int port;
    @Column(name="LAST_UPDATED")
    public Timestamp lastUpdated;
    @Column(name="SHUTDOWN")
    public boolean shutdown;

    static {
        NodeRecord.registerKeyFields((ColumnExp[])new ColumnExp[]{NODE_NAME});
    }

    public NodeRecord() {
    }

    public NodeRecord(String nodeName, String hostName, String publicHostName, String region, int port) {
        this.nodeName = nodeName;
        this.hostName = hostName;
        this.publicHostName = publicHostName;
        this.region = region;
        this.port = port;
    }

    public NodeRecord(String nodeName) {
        this.nodeName = nodeName;
    }

    public String getPeerHostName(String region) {
        return Objects.equal((Object)this.region, (Object)region) ? this.hostName : this.publicHostName;
    }

    public String toString() {
        return StringUtil.fieldsToString((Object)((Object)this));
    }

    public static Key<NodeRecord> getKey(String nodeName) {
        return NodeRecord.newKey(_R, (Comparable[])new Comparable[]{nodeName});
    }
}

