/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.client;

import com.samskivert.swing.RuntimeAdjust;
import com.samskivert.util.IntListUtil;
import com.samskivert.util.Interval;
import com.threerings.presents.Log;
import com.threerings.presents.client.BlockingCommunicator;
import com.threerings.presents.client.Client;
import com.threerings.presents.client.LogonException;
import com.threerings.presents.client.PresentsPrefs;
import java.io.IOException;
import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.SocketChannel;

public class ClientCommunicator
extends BlockingCommunicator {
    protected PrefPortInterval _prefPortInterval;
    protected static RuntimeAdjust.BooleanAdjust _logMessages = new RuntimeAdjust.BooleanAdjust("Toggles whether or not all sent and received low-level network events are logged.", "narya.presents.log_events", PresentsPrefs.config, false);
    protected static long PREF_PORT_DELAY = 5000L;

    public ClientCommunicator(Client client) {
        super(client);
    }

    protected void setPrefPort(String key, int port) {
        PresentsPrefs.config.setValue(key, port);
    }

    protected int getPrefPort(String key, int defaultPort) {
        return PresentsPrefs.config.getValue(key, defaultPort);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void openChannel(InetAddress host) throws IOException {
        String pportKey = String.valueOf(this._client.getHostname()) + ".preferred_port";
        int[] ports = this._client.getPorts();
        int pport = this.getPrefPort(pportKey, ports[0]);
        int ppidx = Math.max(0, IntListUtil.indexOf((int[])ports, (int)pport));
        int ii = 0;
        while (ii < ports.length) {
            int port = ports[(ii + ppidx) % ports.length];
            int nextPort = ports[(ii + ppidx + 1) % ports.length];
            Log.log.info((Object)"Connecting", new Object[]{"host", host, "port", port});
            InetSocketAddress addr = new InetSocketAddress(host, port);
            try {
                ClientCommunicator clientCommunicator = this;
                synchronized (clientCommunicator) {
                    this.clearPPI(true);
                    this._prefPortInterval = new PrefPortInterval(pportKey, port, nextPort);
                    this._channel = SocketChannel.open(addr);
                    this._prefPortInterval.schedule(PREF_PORT_DELAY);
                    break;
                }
            }
            catch (IOException ioe) {
                if (!(ioe instanceof ConnectException) || ii >= ports.length - 1) {
                    throw ioe;
                }
                this._client.reportLogonTribulations(new LogonException("m.trying_next_port", true));
                ++ii;
            }
        }
    }

    @Override
    protected void readerDidExit() {
        this.clearPPI(true);
        super.readerDidExit();
    }

    @Override
    protected boolean debugLogMessages() {
        return _logMessages.getValue();
    }

    protected synchronized boolean clearPPI(boolean cancel) {
        if (this._prefPortInterval != null) {
            if (cancel) {
                this._prefPortInterval.cancel();
                this._prefPortInterval.failed();
            }
            this._prefPortInterval = null;
            return true;
        }
        return false;
    }

    protected class PrefPortInterval
    extends Interval {
        protected String _key;
        protected int _thisPort;
        protected int _nextPort;

        public PrefPortInterval(String key, int thisPort, int nextPort) {
            super(Interval.RUN_DIRECT);
            this._key = key;
            this._thisPort = thisPort;
            this._nextPort = nextPort;
        }

        public void expired() {
            if (ClientCommunicator.this.clearPPI(false)) {
                ClientCommunicator.this.setPrefPort(this._key, this._thisPort);
            }
        }

        public void failed() {
            ClientCommunicator.this.setPrefPort(this._key, this._nextPort);
        }
    }
}

