/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.chat.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.threerings.crowd.chat.data.ChatChannel;
import com.threerings.crowd.chat.data.ChatMessage;
import com.threerings.crowd.chat.data.KeepNoHistory;
import com.threerings.crowd.chat.data.UserMessage;
import com.threerings.crowd.chat.server.SpeakUtil;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.Streamable;
import com.threerings.presents.server.PresentsDObjectMgr;
import com.threerings.util.Name;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

@Singleton
public class ChatHistory {
    public static final long HISTORY_EXPIRATION = 300000L;
    protected Map<Name, List<Entry>> _histories = Maps.newHashMap();
    protected Set<Name> _holds = Sets.newHashSet();
    @Inject
    protected PresentsDObjectMgr _omgr;

    public ChatHistory() {
        SpeakUtil.registerMessageObserver(new SpeakUtil.MessageObserver(){

            @Override
            public void messageDelivered(Name hearer, UserMessage message) {
                ChatHistory.this.record(null, message, hearer);
            }
        });
    }

    public List<Entry> get(Name username) {
        List<Entry> history = this.getList(username);
        if (history != null) {
            this.prune(System.currentTimeMillis(), history);
        }
        return history;
    }

    public void clear(final Name username) {
        if (this._holds.contains(username)) {
            this._holds.remove(username);
            this._omgr.postRunnable(new Runnable(){

                @Override
                public void run() {
                    ChatHistory.this.clear(username);
                }
            });
            return;
        }
        this._histories.remove(username);
    }

    public void record(ChatChannel channel, UserMessage msg, Name ... usernames) {
        if (msg.timestamp == 0L) {
            msg.timestamp = System.currentTimeMillis();
        }
        Name[] nameArray = usernames;
        int n = usernames.length;
        int n2 = 0;
        while (n2 < n) {
            Name username = nameArray[n2];
            List<Entry> history = this.getList(username);
            if (history != null) {
                history.add(new Entry(channel, msg));
                if (history.size() > 15) {
                    this.prune(msg.timestamp, history);
                }
            }
            ++n2;
        }
    }

    public void hold(Name username) {
        this._holds.add(username);
    }

    protected List<Entry> getList(Name username) {
        if (username instanceof KeepNoHistory) {
            return null;
        }
        ArrayList history = this._histories.get(username);
        if (history == null) {
            history = Lists.newArrayList();
            this._histories.put(username, history);
        }
        return history;
    }

    protected void prune(long now, List<Entry> history) {
        int prunepos = 0;
        int ll = history.size();
        while (prunepos < ll) {
            Entry entry = history.get(prunepos);
            if (now - entry.message.timestamp < 300000L) break;
            ++prunepos;
        }
        history.subList(0, prunepos).clear();
    }

    public static class Entry
    implements Streamable {
        public final ChatChannel channel;
        public final ChatMessage message;

        public Entry(ChatChannel channel, ChatMessage message) {
            this.channel = channel;
            this.message = message;
        }

        public void writeObject(ObjectOutputStream out) throws IOException {
            out.defaultWriteObject();
            out.writeLong(this.message.timestamp);
        }

        public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            in.defaultReadObject();
            this.message.timestamp = in.readLong();
        }
    }
}

