/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.admin.web.client;

import com.google.gwt.dom.client.Style;
import com.google.gwt.event.dom.client.ChangeEvent;
import com.google.gwt.event.dom.client.ChangeHandler;
import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.ui.CheckBox;
import com.google.gwt.user.client.ui.Label;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.threerings.admin.web.gwt.ConfigField;

public abstract class ConfigFieldEditor {
    protected ConfigField _field;
    protected Command _onChange;
    protected Label _name;
    protected Label _reset;
    protected Widget _value;

    public static ConfigFieldEditor getEditorFor(ConfigField field, Command onChange) {
        if (field.type == ConfigField.FieldType.BOOLEAN) {
            return new CheckboxFieldEditor(field, onChange);
        }
        return new StringFieldEditor(field, onChange);
    }

    public ConfigFieldEditor(ConfigField field, Command onChange) {
        this._field = field;
        this._onChange = onChange;
        this._value = this.buildWidget(field);
        this._name = new Label(field.name);
        this._name.setStyleName("fieldName");
        this._reset = new Label("X");
        this._reset.setStyleName("resetButton");
        this._reset.addClickHandler(new ClickHandler(){

            public void onClick(ClickEvent event) {
                ConfigFieldEditor.this.resetField();
                ConfigFieldEditor.this.updateModificationState();
            }
        });
        this._reset.setVisible(false);
    }

    protected void updateModificationState() {
        Style style = this._value.getElement().getStyle();
        if (this.getModifiedField() != null) {
            style.setBackgroundColor("red");
            this._reset.setVisible(true);
        } else {
            style.clearBackgroundColor();
            this._reset.setVisible(false);
        }
        this._onChange.execute();
    }

    public Widget getNameWidget() {
        return this._name;
    }

    public Widget getValueWidget() {
        return this._value;
    }

    public Widget getResetWidget() {
        return this._reset;
    }

    public abstract ConfigField getModifiedField();

    protected abstract Widget buildWidget(ConfigField var1);

    protected abstract void resetField();

    protected static class CheckboxFieldEditor
    extends ConfigFieldEditor {
        protected CheckBox _box;

        public CheckboxFieldEditor(ConfigField field, Command onChange) {
            super(field, onChange);
        }

        @Override
        protected Widget buildWidget(ConfigField field) {
            this._box = new CheckBox();
            this._box.setStyleName("configCheckBoxEditor");
            this.resetField();
            this._box.addValueChangeHandler((ValueChangeHandler)new ValueChangeHandler<Boolean>(){

                public void onValueChange(ValueChangeEvent<Boolean> changeEvent) {
                    this.updateModificationState();
                }
            });
            return this._box;
        }

        @Override
        public ConfigField getModifiedField() {
            String newValStr = Boolean.toString(this._box.getValue());
            if (newValStr.equals(this._field.valStr)) {
                return null;
            }
            return new ConfigField(this._field.name, this._field.type, newValStr);
        }

        @Override
        protected void resetField() {
            this._box.setValue(Boolean.valueOf(this._field.valStr));
        }
    }

    protected static class StringFieldEditor
    extends ConfigFieldEditor {
        protected TextBox _box;

        public StringFieldEditor(ConfigField field, Command onChange) {
            super(field, onChange);
        }

        @Override
        protected Widget buildWidget(ConfigField field) {
            this._box = new TextBox();
            this._box.setStyleName("configStringEditor");
            this._box.setVisibleLength(40);
            this.resetField();
            this._box.addChangeHandler(new ChangeHandler(){

                public void onChange(ChangeEvent changeEvent) {
                    if (_field.type.toValue(_box.getText().trim()) == null) {
                        _box.setText(_field.valStr);
                    }
                    this.updateModificationState();
                }
            });
            return this._box;
        }

        @Override
        public ConfigField getModifiedField() {
            Object newValue = this._field.type.toValue(this._box.getText().trim());
            if (newValue == null) {
                return null;
            }
            String newValStr = newValue.toString();
            if (newValStr.length() == 0 && this._field.valStr == null || newValStr.equals(this._field.valStr)) {
                return null;
            }
            return new ConfigField(this._field.name, this._field.type, newValStr);
        }

        @Override
        protected void resetField() {
            this._box.setText(this._field.valStr);
        }
    }
}

