/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.dobj;

import com.samskivert.util.ArrayUtil;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.Streamable;
import com.threerings.presents.Log;
import com.threerings.presents.dobj.SimpleEntry;
import java.io.IOException;
import java.util.AbstractSet;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Set;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class DSet<E extends Entry>
implements Iterable<E>,
Streamable,
Cloneable {
    protected E[] _entries = new Entry[2];
    protected int _size;
    protected transient int _modCount;
    protected static final int INITIAL_CAPACITY = 2;
    protected static Comparator<Entry> ENTRY_COMP = new Comparator<Entry>(){

        @Override
        public int compare(Entry e1, Entry e2) {
            return DSet.compare(e1.getKey(), e2.getKey());
        }
    };

    public static <E extends Entry> DSet<E> newDSet() {
        return new DSet<E>();
    }

    public static <E extends Entry> DSet<E> newDSet(Iterable<? extends E> source) {
        return new DSet<E>(source);
    }

    public static int compare(Comparable<?> c1, Comparable<?> c2) {
        Comparable<?> cc1 = c1;
        Comparable<?> cc2 = c2;
        return cc1.compareTo(cc2);
    }

    public DSet(Iterable<? extends E> source) {
        for (Entry e : source) {
            this.add(e);
        }
    }

    public DSet(Iterator<? extends E> source) {
        while (source.hasNext()) {
            this.add((Entry)source.next());
        }
    }

    public DSet(E[] source) {
        E[] EArray = source;
        int n = source.length;
        int n2 = 0;
        while (n2 < n) {
            E element = EArray[n2];
            if (element != null) {
                this.add(element);
            }
            ++n2;
        }
    }

    public DSet() {
    }

    public boolean isEmpty() {
        return this._size == 0;
    }

    public int size() {
        return this._size;
    }

    public boolean contains(E elem) {
        return this.containsKey(elem.getKey());
    }

    public boolean containsKey(Comparable<?> key) {
        return this.get(key) != null;
    }

    public E get(Comparable<?> key) {
        int eidx = ArrayUtil.binarySearch((Object[])this._entries, (int)0, (int)this._size, new SimpleEntry(key), ENTRY_COMP);
        return eidx < 0 ? null : (E)this._entries[eidx];
    }

    @Deprecated
    public Iterator<E> entries() {
        return this.iterator();
    }

    @Override
    public Iterator<E> iterator() {
        if (this._size < 0 || this._size > this._entries.length || this._size > 0 && this._entries[this._size - 1] == null) {
            Log.log.warning((Object)"DSet in a bad way", new Object[]{"size", this._size, "entries", this._entries, new Exception()});
        }
        return new Iterator<E>(){
            protected int _index = 0;
            protected int _ssize;
            protected int _expectedModCount;
            {
                this._ssize = DSet.this._size;
                this._expectedModCount = DSet.this._modCount;
            }

            @Override
            public boolean hasNext() {
                this.checkComodification();
                return this._index < DSet.this._size;
            }

            @Override
            public E next() {
                this.checkComodification();
                return DSet.this._entries[this._index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            protected void checkComodification() {
                if (DSet.this._modCount != this._expectedModCount) {
                    throw new ConcurrentModificationException();
                }
                if (this._ssize != DSet.this._size) {
                    Log.log.warning((Object)"Size changed during iteration", new Object[]{"ssize", this._ssize, "nsize", DSet.this._size, "entries", DSet.this._entries, new Exception()});
                }
            }
        };
    }

    public Set<E> asSet() {
        return new AbstractSet<E>(){

            @Override
            public boolean add(E o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Entry)) {
                    return false;
                }
                Entry elem = (Entry)o;
                return DSet.this.contains(elem);
            }

            @Override
            public Iterator<E> iterator() {
                return DSet.this.iterator();
            }

            @Override
            public int size() {
                return DSet.this.size();
            }
        };
    }

    @Deprecated
    public E[] toArray(E[] array) {
        if (array == null) {
            Entry[] copy = new Entry[this.size()];
            array = copy;
        }
        System.arraycopy(this._entries, 0, array, 0, array.length);
        return array;
    }

    @Deprecated
    public Object[] toArray(Object[] array) {
        Entry[] casted = (Entry[])array;
        return this.toArray(casted);
    }

    protected boolean add(E elem) {
        int eidx = -1;
        if (this._entries != null && this._entries.length > 0) {
            eidx = ArrayUtil.binarySearch((Object[])this._entries, (int)0, (int)this._size, elem, ENTRY_COMP);
        }
        if (eidx >= 0) {
            Log.log.warning((Object)"Refusing to add duplicate entry", new Object[]{"entry", elem, "set", this, new Exception()});
            return false;
        }
        eidx = (eidx + 1) * -1;
        int elength = this._entries.length;
        if (this._size >= elength) {
            if (elength > this.getWarningSize()) {
                Log.log.warning((Object)"Requested to expand to questionably large size", new Object[]{"l", elength, new Exception()});
            }
            Entry[] elems = new Entry[elength * 2];
            System.arraycopy(this._entries, 0, elems, 0, elength);
            this._entries = elems;
        }
        if (eidx < this._size) {
            System.arraycopy(this._entries, eidx, this._entries, eidx + 1, this._size - eidx);
        }
        this._entries[eidx] = elem;
        ++this._size;
        ++this._modCount;
        return true;
    }

    protected boolean remove(E elem) {
        return this.removeKey(elem.getKey()) != null;
    }

    protected E removeKey(Comparable<?> key) {
        if (key == null) {
            Log.log.warning((Object)"Requested to remove null key.", new Object[]{new Exception()});
            return null;
        }
        int eidx = ArrayUtil.binarySearch((Object[])this._entries, (int)0, (int)this._size, new SimpleEntry(key), ENTRY_COMP);
        if (eidx >= 0) {
            E oldEntry = this._entries[eidx];
            --this._size;
            if (this._entries.length > 2 && this._size < this._entries.length / 8) {
                Entry[] newEnts = new Entry[this._entries.length / 2];
                System.arraycopy(this._entries, 0, newEnts, 0, eidx);
                System.arraycopy(this._entries, eidx + 1, newEnts, eidx, this._size - eidx);
                this._entries = newEnts;
            } else {
                System.arraycopy(this._entries, eidx + 1, this._entries, eidx, this._size - eidx);
                this._entries[this._size] = null;
            }
            ++this._modCount;
            return oldEntry;
        }
        return null;
    }

    protected E update(E elem) {
        int eidx = ArrayUtil.binarySearch((Object[])this._entries, (int)0, (int)this._size, elem, ENTRY_COMP);
        if (eidx >= 0) {
            E oldEntry = this._entries[eidx];
            this._entries[eidx] = elem;
            ++this._modCount;
            return oldEntry;
        }
        return null;
    }

    protected int getWarningSize() {
        return 2048;
    }

    @Deprecated
    public DSet<E> typedClone() {
        return this.clone();
    }

    public DSet<E> clone() {
        try {
            DSet nset = (DSet)super.clone();
            Entry[] copy = new Entry[this._entries.length];
            nset._entries = copy;
            System.arraycopy(this._entries, 0, nset._entries, 0, this._entries.length);
            nset._modCount = 0;
            return nset;
        }
        catch (CloneNotSupportedException cnse) {
            throw new AssertionError((Object)cnse);
        }
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("(");
        String prefix = "";
        E[] EArray = this._entries;
        int n = this._entries.length;
        int n2 = 0;
        while (n2 < n) {
            E elem = EArray[n2];
            if (elem != null) {
                buf.append(prefix);
                prefix = ", ";
                buf.append(elem);
            }
            ++n2;
        }
        buf.append(")");
        return buf.toString();
    }

    public void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(this._size);
        int ii = 0;
        while (ii < this._size) {
            out.writeObject(this._entries[ii]);
            ++ii;
        }
    }

    public void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this._size = in.readInt();
        int capacity = 2;
        while (capacity < this._size) {
            capacity <<= 1;
        }
        Entry[] entries = new Entry[capacity];
        this._entries = entries;
        int ii = 0;
        while (ii < this._size) {
            Entry entry = (Entry)in.readObject();
            this._entries[ii] = entry;
            ++ii;
        }
    }

    public static interface Entry
    extends Streamable {
        public Comparable<?> getKey();
    }
}

