/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.nio;

import com.google.common.collect.Iterators;
import com.threerings.NaryaLog;
import java.io.IOException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class SelectorIterable
implements Iterable<SelectionKey> {
    public static final int MAX_SELECT_FAILURES = 20;
    protected int _runtimeExceptionCount;
    protected final int _selectLoopTime;
    protected final Selector _selector;
    protected final SelectFailureHandler _failureHandler;

    public SelectorIterable(Selector selector, int selectLoopTime, SelectFailureHandler handler) {
        this._selector = selector;
        this._selectLoopTime = selectLoopTime;
        this._failureHandler = handler;
    }

    @Override
    public Iterator<SelectionKey> iterator() {
        return Iterators.consumingIterator(this.select().iterator());
    }

    protected Set<SelectionKey> select() {
        block4: {
            try {
                int eventCount = this._selectLoopTime == 0 ? this._selector.selectNow() : this._selector.select(this._selectLoopTime);
                Set<SelectionKey> ready = this._selector.selectedKeys();
                if (eventCount == 0 && ready.size() != 0) {
                    NaryaLog.log.warning((Object)("select() returned no selected sockets, but there are " + ready.size() + " in the ready set."), new Object[0]);
                }
                this._runtimeExceptionCount = 0;
                return ready;
            }
            catch (IOException ioe) {
                NaryaLog.log.warning((Object)"Failure select()ing", new Object[]{"ioe", ioe});
            }
            catch (RuntimeException re) {
                NaryaLog.log.warning((Object)"Failure select()ing.", new Object[]{re});
                if (this._runtimeExceptionCount++ < 20) break block4;
                this._failureHandler.handleSelectFailure(re);
            }
        }
        return Collections.emptySet();
    }

    public static interface SelectFailureHandler {
        public void handleSelectFailure(Exception var1);
    }
}

