/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.io;

import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.Streamable;
import java.io.IOException;

public class ArrayMask
implements Streamable {
    protected byte[] _mask;

    public ArrayMask() {
    }

    public ArrayMask(int length) {
        int mlength = length / 8;
        if (length % 8 != 0) {
            ++mlength;
        }
        this._mask = new byte[mlength];
    }

    public void set(int index) {
        int n = index / 8;
        this._mask[n] = (byte)(this._mask[n] | 1 << index % 8);
    }

    public void unSet(int index) {
        int n = index / 8;
        this._mask[n] = (byte)(this._mask[n] & ~(1 << index % 8));
    }

    public boolean isSet(int index) {
        return (this._mask[index / 8] & 1 << index % 8) != 0;
    }

    public void writeTo(ObjectOutputStream out) throws IOException {
        out.writeShort(this._mask.length);
        out.write(this._mask);
    }

    public void readFrom(ObjectInputStream in) throws IOException {
        short length = in.readShort();
        this._mask = new byte[length];
        in.read(this._mask);
    }
}

