/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.client;

import com.google.common.collect.Lists;
import com.samskivert.util.ObserverList;
import com.samskivert.util.ResultListener;
import com.threerings.crowd.Log;
import com.threerings.crowd.client.LocationDecoder;
import com.threerings.crowd.client.LocationObserver;
import com.threerings.crowd.client.LocationReceiver;
import com.threerings.crowd.client.LocationService;
import com.threerings.crowd.client.MoveFailedException;
import com.threerings.crowd.client.MoveVetoedException;
import com.threerings.crowd.client.PlaceController;
import com.threerings.crowd.data.BodyObject;
import com.threerings.crowd.data.LocationCodes;
import com.threerings.crowd.data.PlaceConfig;
import com.threerings.crowd.data.PlaceObject;
import com.threerings.crowd.util.CrowdContext;
import com.threerings.presents.client.BasicDirector;
import com.threerings.presents.client.Client;
import com.threerings.presents.dobj.ChangeListener;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.Subscriber;
import com.threerings.presents.util.SafeSubscriber;
import java.util.ArrayList;

public class LocationDirector
extends BasicDirector
implements LocationCodes,
LocationReceiver {
    protected CrowdContext _ctx;
    protected LocationService _lservice;
    protected ObserverList<LocationObserver> _observers = ObserverList.newSafeInOrder();
    protected SafeSubscriber<PlaceObject> _subber;
    protected int _placeId = -1;
    protected PlaceObject _plobj;
    protected PlaceController _controller;
    protected int _pendingPlaceId = -1;
    protected int _previousPlaceId = -1;
    protected long _lastRequestTime;
    protected FailureHandler _failureHandler;
    protected ResultListener<PlaceConfig> _moveListener;
    protected ArrayList<Runnable> _pendingForcedMoves = Lists.newArrayList();
    protected ObserverList.ObserverOp<LocationObserver> _didChangeOp = new ObserverList.ObserverOp<LocationObserver>(){

        public boolean apply(LocationObserver obs) {
            obs.locationDidChange(LocationDirector.this._plobj);
            return true;
        }
    };
    protected static final long STALE_REQUEST_DURATION = 60000L;

    public LocationDirector(CrowdContext ctx) {
        super(ctx);
        this._ctx = ctx;
        this._ctx.getClient().getInvocationDirector().registerReceiver(new LocationDecoder(this));
    }

    public void addLocationObserver(LocationObserver observer) {
        this._observers.add((Object)observer);
    }

    public void removeLocationObserver(LocationObserver observer) {
        this._observers.remove((Object)observer);
    }

    public PlaceObject getPlaceObject() {
        return this._plobj;
    }

    public boolean movePending() {
        return this._pendingPlaceId > 0;
    }

    public boolean moveTo(int placeId) {
        if (placeId < 0) {
            Log.log.warning((Object)("Refusing moveTo(): invalid placeId " + placeId + "."), new Object[0]);
            return false;
        }
        if (!this.mayMoveTo(placeId, null)) {
            return false;
        }
        boolean refuse = this.checkRepeatMove();
        if (this._pendingPlaceId != -1) {
            if (refuse) {
                Log.log.warning((Object)"Refusing moveTo; We have a request outstanding", new Object[]{"ppid", this._pendingPlaceId, "npid", placeId});
                return false;
            }
            Log.log.warning((Object)"Overriding stale moveTo request", new Object[]{"ppid", this._pendingPlaceId, "npid", placeId});
        }
        this._pendingPlaceId = placeId;
        Log.log.info((Object)("Issuing moveTo(" + placeId + ")."), new Object[0]);
        this._lservice.moveTo(placeId, new LocationService.MoveListener(){

            @Override
            public void moveSucceeded(PlaceConfig config) {
                LocationDirector.this.didMoveTo(LocationDirector.this._pendingPlaceId, config);
                LocationDirector.this._pendingPlaceId = -1;
                LocationDirector.this.handlePendingForcedMove();
            }

            @Override
            public void requestFailed(String reason) {
                int placeId = LocationDirector.this._pendingPlaceId;
                LocationDirector.this._pendingPlaceId = -1;
                Log.log.info((Object)"moveTo failed", new Object[]{"pid", placeId, "reason", reason});
                LocationDirector.this.handleFailure(placeId, reason);
                LocationDirector.this.handlePendingForcedMove();
            }
        });
        return true;
    }

    public boolean moveBack() {
        if (this._previousPlaceId == -1) {
            return false;
        }
        this.moveTo(this._previousPlaceId);
        return true;
    }

    public boolean leavePlace() {
        if (this._pendingPlaceId != -1) {
            return false;
        }
        this._lservice.leavePlace();
        this.didLeavePlace();
        this._observers.apply(this._didChangeOp);
        return true;
    }

    public boolean mayMoveTo(final int placeId, ResultListener<PlaceConfig> rl) {
        final boolean[] vetoed = new boolean[1];
        this._observers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<LocationObserver>(){

            public boolean apply(LocationObserver obs) {
                vetoed[0] = vetoed[0] || !obs.locationMayChange(placeId);
                return true;
            }
        });
        this.mayLeavePlace();
        if (rl != null) {
            if (vetoed[0]) {
                rl.requestFailed((Exception)new MoveVetoedException());
            } else {
                this._moveListener = rl;
            }
        }
        return !vetoed[0];
    }

    protected void mayLeavePlace() {
        if (this._controller != null) {
            try {
                this._controller.mayLeavePlace(this._plobj);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Place controller choked in mayLeavePlace", new Object[]{"plobj", this._plobj, e});
            }
        }
    }

    public void didMoveTo(int placeId, PlaceConfig config) {
        if (this._moveListener != null) {
            this._moveListener.requestCompleted((Object)config);
            this._moveListener = null;
        }
        this._previousPlaceId = this._placeId;
        this._lastRequestTime = 0L;
        this.didLeavePlace();
        this._placeId = placeId;
        try {
            this._controller = this.createController(config);
            if (this._controller == null) {
                Log.log.warning((Object)"Place config returned null controller", new Object[]{"config", config});
                return;
            }
            this._controller.init(this._ctx, config);
            this.subscribeToPlace();
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed to create place controller", new Object[]{"config", config, e});
            this.handleFailure(this._placeId, "e.internal_error");
        }
    }

    public void didLeavePlace() {
        if (this._subber != null) {
            this._subber.unsubscribe(this._ctx.getDObjectManager());
            this._subber = null;
        }
        if (this._plobj != null && this._controller != null) {
            try {
                this._controller.didLeavePlace(this._plobj);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Place controller choked in didLeavePlace", new Object[]{"plobj", this._plobj, e});
            }
        }
        this._plobj = null;
        this._controller = null;
        this._placeId = -1;
    }

    public void failedToMoveTo(int placeId, String reason) {
        if (this._moveListener != null) {
            this._moveListener.requestFailed((Exception)new MoveFailedException(reason));
            this._moveListener = null;
        }
        this._lastRequestTime = 0L;
        this.handleFailure(placeId, reason);
    }

    public boolean checkRepeatMove() {
        long now = System.currentTimeMillis();
        if (now - this._lastRequestTime < 60000L) {
            return true;
        }
        this._lastRequestTime = now;
        return false;
    }

    @Override
    public void clientDidLogon(Client client) {
        super.clientDidLogon(client);
        Subscriber<BodyObject> sub = new Subscriber<BodyObject>(){

            @Override
            public void objectAvailable(BodyObject object) {
                LocationDirector.this.gotBodyObject(object);
            }

            @Override
            public void requestFailed(int oid, ObjectAccessException cause) {
                Log.log.warning((Object)"Location director unable to fetch body object; all has gone horribly wrong", new Object[]{"cause", cause});
            }
        };
        int cloid = client.getClientOid();
        client.getDObjectManager().subscribeToObject(cloid, sub);
    }

    @Override
    public void clientDidLogoff(Client client) {
        super.clientDidLogoff(client);
        this.mayLeavePlace();
        this.didLeavePlace();
        this._observers.apply(this._didChangeOp);
        this._pendingPlaceId = -1;
        this._pendingForcedMoves.clear();
        this._previousPlaceId = -1;
        this._lastRequestTime = 0L;
        this._lservice = null;
    }

    @Override
    protected void registerServices(Client client) {
        client.addServiceGroup("crowd");
    }

    @Override
    protected void fetchServices(Client client) {
        this._lservice = client.requireService(LocationService.class);
    }

    protected void subscribeToPlace() {
        this._subber = new SafeSubscriber<PlaceObject>(this._placeId, new Subscriber<PlaceObject>(){

            @Override
            public void objectAvailable(PlaceObject object) {
                LocationDirector.this.gotPlaceObject(object);
            }

            @Override
            public void requestFailed(int oid, ObjectAccessException cause) {
                Log.log.warning((Object)"Aiya! Unable to fetch place object for new location", new Object[]{"plid", oid, "reason", cause});
                int placeId = LocationDirector.this._placeId;
                LocationDirector.this._placeId = -1;
                LocationDirector.this.handleFailure(placeId, "m.unable_to_fetch_place_object");
            }
        }, new ChangeListener[0]);
        this._subber.subscribe(this._ctx.getDObjectManager());
    }

    protected void gotPlaceObject(PlaceObject object) {
        this._plobj = object;
        this._plobj.initManagerCaller(this._ctx.getClient().getDObjectManager());
        if (this._controller != null) {
            try {
                this._controller.willEnterPlace(this._plobj);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Controller choked in willEnterPlace", new Object[]{"place", this._plobj, e});
            }
        }
        this._observers.apply(this._didChangeOp);
    }

    protected void gotBodyObject(BodyObject clobj) {
    }

    @Override
    public void forcedMove(final int placeId) {
        if (this.movePending()) {
            if (this._pendingPlaceId == placeId) {
                Log.log.info((Object)"Dropping forced move because we have a move pending", new Object[]{"pendId", this._pendingPlaceId, "reqId", placeId});
            } else {
                Log.log.info((Object)"Delaying forced move because we have a move pending", new Object[]{"pendId", this._pendingPlaceId, "reqId", placeId});
                this.addPendingForcedMove(new Runnable(){

                    @Override
                    public void run() {
                        LocationDirector.this.forcedMove(placeId);
                    }
                });
            }
            return;
        }
        Log.log.info((Object)"Moving at request of server", new Object[]{"placeId", placeId});
        this.mayLeavePlace();
        this.didLeavePlace();
        this.moveTo(placeId);
    }

    public void setFailureHandler(FailureHandler handler) {
        if (this._failureHandler != null) {
            Log.log.warning((Object)"Requested to set failure handler, but we've already got one. The conflicting entities will likely need to perform more sophisticated coordination to deal with failures.", new Object[]{"old", this._failureHandler, "new", handler});
        } else {
            this._failureHandler = handler;
        }
    }

    protected void handleFailure(final int placeId, final String reason) {
        this._observers.apply((ObserverList.ObserverOp)new ObserverList.ObserverOp<LocationObserver>(){

            public boolean apply(LocationObserver obs) {
                obs.locationChangeFailed(placeId, reason);
                return true;
            }
        });
        if (this._failureHandler != null) {
            this._failureHandler.recoverFailedMove(placeId);
        } else if (this._placeId <= 0 && this._previousPlaceId != -1 && this._previousPlaceId != placeId) {
            this.moveTo(this._previousPlaceId);
        }
    }

    protected PlaceController createController(PlaceConfig config) {
        return config.createController();
    }

    public void addPendingForcedMove(Runnable move) {
        this._pendingForcedMoves.add(move);
    }

    protected void handlePendingForcedMove() {
        if (!this._pendingForcedMoves.isEmpty()) {
            this._ctx.getClient().getRunQueue().postRunnable(this._pendingForcedMoves.remove(0));
        }
    }

    public static interface FailureHandler {
        public void recoverFailedMove(int var1);
    }
}

