/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.bureau.util;

import com.samskivert.io.StreamUtil;
import com.samskivert.util.Logger;
import com.threerings.bureau.Log;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.text.DateFormat;
import java.util.Date;

public class BureauLogRedirector {
    protected String _bureauId;
    protected BufferedReader _reader;
    protected int _limit;
    protected int _written;
    protected boolean _truncated;
    protected static Logger _target = Logger.getLogger(BureauLogRedirector.class);

    public BureauLogRedirector(String bureauId, InputStream input) {
        this(bureauId, input, 0);
    }

    public BureauLogRedirector(String bureauId, InputStream input, int limit) {
        this._bureauId = bureauId;
        this._reader = new BufferedReader(new InputStreamReader(input));
        this._limit = limit;
        Thread thread = new Thread(bureauId){

            @Override
            public void run() {
                BureauLogRedirector.this.copyLoop();
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public String getBureauId() {
        return this._bureauId;
    }

    public int getWritten() {
        return this._written;
    }

    public int getLimit() {
        return this._limit;
    }

    public synchronized void reset(int limit) {
        this._written = 0;
        this._truncated = false;
        this._limit = limit;
    }

    public boolean isTruncated() {
        return this._truncated;
    }

    public boolean isRunning() {
        return this._reader != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void copyLoop() {
        try {
            try {
                String line;
                while ((line = this._reader.readLine()) != null) {
                    int length = line.length();
                    boolean showTrunc = false;
                    BureauLogRedirector bureauLogRedirector = this;
                    synchronized (bureauLogRedirector) {
                        if (this._truncated) {
                            line = null;
                        } else if (this._limit > 0 && this._written + length > this._limit) {
                            this._truncated = true;
                            showTrunc = true;
                            line = null;
                        }
                    }
                    if (line != null) {
                        _target.info((Object)line, new Object[0]);
                        this._written += length;
                        continue;
                    }
                    if (!showTrunc) continue;
                    DateFormat format = DateFormat.getDateTimeInstance(0, 0);
                    _target.info((Object)(String.valueOf(format.format(new Date())) + ": Size limit reached, suppressing further output"), new Object[0]);
                }
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failed to read bureau output", new Object[]{"bureauId", this._bureauId, e});
                StreamUtil.close((Reader)this._reader);
                this._reader = null;
            }
        }
        finally {
            StreamUtil.close((Reader)this._reader);
            this._reader = null;
        }
    }
}

