/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.bureau.client;

import com.samskivert.util.IntMap;
import com.samskivert.util.IntMaps;
import com.threerings.bureau.Log;
import com.threerings.bureau.client.Agent;
import com.threerings.bureau.client.BureauDecoder;
import com.threerings.bureau.client.BureauReceiver;
import com.threerings.bureau.client.BureauService;
import com.threerings.bureau.data.AgentObject;
import com.threerings.bureau.util.BureauContext;
import com.threerings.presents.client.BasicDirector;
import com.threerings.presents.client.Client;
import com.threerings.presents.dobj.ChangeListener;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.Subscriber;
import com.threerings.presents.util.SafeSubscriber;

public abstract class BureauDirector
extends BasicDirector {
    protected BureauContext _ctx;
    protected BureauService _bureauService;
    protected IntMap<Agent> _agents = IntMaps.newHashIntMap();
    protected IntMap<SafeSubscriber<AgentObject>> _subscribers = IntMaps.newHashIntMap();

    public BureauDirector(BureauContext ctx) {
        super(ctx);
        this._ctx = ctx;
    }

    @Override
    public void clientDidLogon(Client client) {
        super.clientDidLogon(client);
        this._bureauService.bureauInitialized(this._ctx.getBureauId());
    }

    protected synchronized void createAgent(int agentId) {
        Subscriber<AgentObject> delegator = new Subscriber<AgentObject>(){

            @Override
            public void objectAvailable(AgentObject agentObject) {
                BureauDirector.this.objectAvailable(agentObject);
            }

            @Override
            public void requestFailed(int oid, ObjectAccessException cause) {
                BureauDirector.this.requestFailed(oid, cause);
            }
        };
        Log.log.info((Object)("Subscribing to object " + agentId), new Object[0]);
        SafeSubscriber<AgentObject> subscriber = new SafeSubscriber<AgentObject>(agentId, delegator, new ChangeListener[0]);
        this._subscribers.put(agentId, subscriber);
        subscriber.subscribe(this._ctx.getDObjectManager());
    }

    protected synchronized void destroyAgent(int agentId) {
        Agent agent = null;
        agent = (Agent)this._agents.remove(agentId);
        if (agent == null) {
            Log.log.warning((Object)("Lost an agent, id " + agentId), new Object[0]);
        } else {
            try {
                agent.stop();
            }
            catch (Throwable t) {
                Log.log.warning((Object)"Stopping an agent caused an exception", new Object[]{t});
            }
            SafeSubscriber subscriber = (SafeSubscriber)this._subscribers.remove(agentId);
            if (subscriber == null) {
                Log.log.warning((Object)("Lost a subscriber for agent " + agent), new Object[0]);
            } else {
                subscriber.unsubscribe(this._ctx.getDObjectManager());
            }
            this._bureauService.agentDestroyed(agentId);
        }
    }

    protected synchronized void objectAvailable(AgentObject agentObject) {
        Agent agent;
        int oid = agentObject.getOid();
        Log.log.info((Object)("Object " + oid + " now available"), new Object[0]);
        try {
            agent = this.createAgent(agentObject);
            agent.init(agentObject);
            agent.start();
        }
        catch (Throwable t) {
            Log.log.warning((Object)"Could not create agent", new Object[]{"obj", agentObject, t});
            this._bureauService.agentCreationFailed(oid);
            return;
        }
        this._agents.put(oid, (Object)agent);
        this._bureauService.agentCreated(oid);
    }

    protected synchronized void requestFailed(int oid, ObjectAccessException cause) {
        Log.log.warning((Object)"Could not subscribe to agent", new Object[]{"oid", oid, cause});
    }

    @Override
    protected void registerServices(Client client) {
        super.registerServices(client);
        client.addServiceGroup("bureau");
        BureauReceiver receiver = new BureauReceiver(){

            @Override
            public void createAgent(int agentId) {
                BureauDirector.this.createAgent(agentId);
            }

            @Override
            public void destroyAgent(int agentId) {
                BureauDirector.this.destroyAgent(agentId);
            }
        };
        client.getInvocationDirector().registerReceiver(new BureauDecoder(receiver));
    }

    @Override
    protected void fetchServices(Client client) {
        super.fetchServices(client);
        this._bureauService = client.getService(BureauService.class);
    }

    protected abstract Agent createAgent(AgentObject var1);
}

