/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.admin.web.client;

import com.google.common.collect.Lists;
import com.google.gwt.event.dom.client.HasClickHandlers;
import com.google.gwt.user.client.Command;
import com.google.gwt.user.client.rpc.AsyncCallback;
import com.google.gwt.user.client.ui.Button;
import com.google.gwt.user.client.ui.TextBox;
import com.google.gwt.user.client.ui.Widget;
import com.threerings.admin.web.client.ConfigFieldEditor;
import com.threerings.admin.web.gwt.ConfigField;
import com.threerings.admin.web.gwt.ConfigService;
import com.threerings.gwt.ui.InfoPopup;
import com.threerings.gwt.ui.SmartTable;
import com.threerings.gwt.util.ClickCallback;
import java.util.ArrayList;
import java.util.List;

public class ConfigEditorTab
extends SmartTable {
    protected List<ConfigFieldEditor> _editors = Lists.newArrayList();
    protected ConfigAccessor _parent;
    protected String _key;
    protected Button _submit;
    protected Command UPDATE_BUTTON = new Command(){

        public void execute() {
            for (ConfigFieldEditor editor : ConfigEditorTab.this._editors) {
                if (editor.getModifiedField() == null) continue;
                ConfigEditorTab.this._submit.setEnabled(true);
                return;
            }
            ConfigEditorTab.this._submit.setEnabled(false);
        }
    };

    public ConfigEditorTab(ConfigAccessor parent, String key, ConfigService.ConfigurationRecord record) {
        super("configEditorTab", 5, 5);
        this._parent = parent;
        this._key = key;
        this._submit = new Button("Submit Changes");
        new ClickCallback<ConfigService.ConfigurationRecord>((HasClickHandlers)this._submit, new TextBox[0]){

            protected boolean callService() {
                ArrayList modified = Lists.newArrayList();
                for (ConfigFieldEditor editor : ConfigEditorTab.this._editors) {
                    ConfigField field = editor.getModifiedField();
                    if (field == null) continue;
                    modified.add(field);
                }
                ConfigEditorTab.this._parent.submitChanges(ConfigEditorTab.this._key, modified.toArray(new ConfigField[modified.size()]), (AsyncCallback<ConfigService.ConfigurationRecord>)this);
                return true;
            }

            protected boolean gotResult(ConfigService.ConfigurationRecord result) {
                new InfoPopup("Updated " + result.updates + " fields.").show();
                ConfigEditorTab.this.updateTable(result);
                return false;
            }
        };
        this.cell(1, 1).alignRight().widget((Widget)this._submit);
        this.updateTable(record);
    }

    protected void updateTable(ConfigService.ConfigurationRecord record) {
        SmartTable table = new SmartTable(5, 5);
        table.setStyleName("configEditorTable");
        int row = 0;
        ConfigField[] configFieldArray = record.fields;
        int n = record.fields.length;
        int n2 = 0;
        while (n2 < n) {
            ConfigField field = configFieldArray[n2];
            ConfigFieldEditor editor = ConfigFieldEditor.getEditorFor(field, this.UPDATE_BUTTON);
            this._editors.add(editor);
            table.cell(row, 0).alignRight().widget(editor.getNameWidget());
            table.cell(row, 1).alignLeft().widget(editor.getValueWidget());
            table.cell(row, 2).alignLeft().widget(editor.getResetWidget());
            ++row;
            ++n2;
        }
        this.cell(0, 0).colSpan(2).widget((Widget)table);
        this.UPDATE_BUTTON.execute();
    }

    public static interface ConfigAccessor {
        public void submitChanges(String var1, ConfigField[] var2, AsyncCallback<ConfigService.ConfigurationRecord> var3);
    }
}

