/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.peer.server;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.samskivert.util.Tuple;
import com.threerings.presents.Log;
import com.threerings.presents.peer.data.NodeObject;
import com.threerings.presents.peer.server.PeerManager;
import java.net.MalformedURLException;
import java.rmi.Naming;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Ehcache;
import net.sf.ehcache.distribution.CacheManagerPeerProvider;
import net.sf.ehcache.distribution.CacheManagerPeerProviderFactory;
import net.sf.ehcache.distribution.CachePeer;

public class EHCachePeerCoordinator
extends CacheManagerPeerProviderFactory {
    public static final int RMI_PORT = 40001;
    protected static Provider _instance;

    public static void initWithPeers(PeerManager peerMan) {
        if (_instance == null) {
            Log.log.warning((Object)"No provider initialized -- not coordinating Presents and EHCache peers.", new Object[0]);
            return;
        }
        _instance.initWithPeers(peerMan);
    }

    public CacheManagerPeerProvider createCachePeerProvider(CacheManager cacheManager, Properties properties) {
        if (_instance == null) {
            _instance = new Provider(cacheManager);
        }
        return _instance;
    }

    protected static class Provider
    implements CacheManagerPeerProvider {
        protected Map<Tuple<String, String>, CachePeer> _peerCache = Maps.newHashMap();
        protected PeerManager _peerMan;
        protected CacheManager _cacheMan;

        public Provider(CacheManager cacheManager) {
            this._cacheMan = cacheManager;
        }

        public void initWithPeers(PeerManager peerMan) {
            this._peerMan = peerMan;
        }

        public void registerPeer(String rmiUrl) {
        }

        public void unregisterPeer(String rmiUrl) {
        }

        public List<?> listRemoteCachePeers(Ehcache cache) throws CacheException {
            if (this._peerMan == null) {
                return Collections.emptyList();
            }
            ArrayList result = Lists.newArrayList();
            HashSet nodes = Sets.newHashSet();
            for (NodeObject node : this._peerMan.getNodeObjects()) {
                if (node == this._peerMan.getNodeObject()) continue;
                this.addCacheForNode(result, node.nodeName, cache.getName());
                nodes.add(node.nodeName);
            }
            HashSet toRemove = Sets.newHashSet();
            for (Tuple<String, String> tuple : this._peerCache.keySet()) {
                if (nodes.contains(tuple.left)) continue;
                toRemove.add(tuple);
            }
            for (Tuple tuple : toRemove) {
                Log.log.info((Object)("Removing EHCache peer: " + tuple), new Object[0]);
                this._peerCache.remove(tuple);
            }
            return result;
        }

        public void init() {
        }

        public void dispose() throws CacheException {
        }

        public long getTimeForClusterToForm() {
            return 10000L;
        }

        public String getScheme() {
            return "RMI";
        }

        protected void addCacheForNode(List<CachePeer> result, String nodeName, String cacheName) {
            String nodeHost = this._peerMan.getPeerInternalHostName(nodeName);
            if (nodeHost == null) {
                Log.log.warning((Object)"Eek, couldn't find the public host name of peer", new Object[]{"node", nodeName});
                return;
            }
            try {
                String rmiBase = "//" + nodeHost + ":" + 40001 + "/";
                result.add(this.getCache(nodeName, String.valueOf(rmiBase) + cacheName));
            }
            catch (Exception e) {
                Log.log.warning((Object)"Could not resolve remote peer", new Object[]{"host", nodeHost, "cache", cacheName, e});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected CachePeer getCache(String nodeName, String url) throws MalformedURLException, RemoteException, NotBoundException {
            Tuple key = Tuple.newTuple((Object)nodeName, (Object)url);
            Map<Tuple<String, String>, CachePeer> map = this._peerCache;
            synchronized (map) {
                CachePeer peer = this._peerCache.get(key);
                if (peer == null) {
                    Log.log.info((Object)"RMI lookup of remote cache", new Object[]{"url", url});
                    peer = (CachePeer)Naming.lookup(url);
                    this._peerCache.put((Tuple<String, String>)key, peer);
                }
                return peer;
            }
        }
    }
}

