/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.dobj;

import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.NamedEvent;
import com.threerings.presents.dobj.ObjectAccessException;
import com.threerings.presents.dobj.OidList;
import com.threerings.presents.dobj.OidListListener;

public class ObjectAddedEvent
extends NamedEvent {
    protected int _oid;
    protected transient boolean _alreadyApplied;

    public ObjectAddedEvent(int targetOid, String name, int oid) {
        super(targetOid, name);
        this._oid = oid;
    }

    public int getOid() {
        return this._oid;
    }

    @Override
    public boolean alreadyApplied() {
        return this._alreadyApplied;
    }

    @Override
    public boolean applyToObject(DObject target) throws ObjectAccessException {
        if (!this._alreadyApplied) {
            OidList list = (OidList)target.getAttribute(this._name);
            list.add(this._oid);
        }
        return true;
    }

    @Override
    protected void notifyListener(Object listener) {
        if (listener instanceof OidListListener) {
            ((OidListListener)listener).objectAdded(this);
        }
    }

    @Override
    protected void toString(StringBuilder buf) {
        buf.append("OBJADD:");
        super.toString(buf);
        buf.append(", oid=").append(this._oid);
    }

    protected ObjectAddedEvent setAlreadyApplied(boolean alreadyApplied) {
        this._alreadyApplied = alreadyApplied;
        return this;
    }
}

