/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.io;

import com.google.common.base.Defaults;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.ByteEnum;
import com.samskivert.util.ByteEnumUtil;
import com.samskivert.util.ClassUtil;
import com.samskivert.util.QuickSort;
import com.threerings.NaryaLog;
import com.threerings.io.ArrayMask;
import com.threerings.io.BasicStreamers;
import com.threerings.io.FieldMarshaller;
import com.threerings.io.NotStreamable;
import com.threerings.io.ObjectInputStream;
import com.threerings.io.ObjectOutputStream;
import com.threerings.io.Streamable;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public abstract class Streamer {
    protected static Map<Class<?>, Streamer> _streamers;
    protected static final boolean SORT_FIELDS;
    protected static final EnumPolicy ENUM_POLICY;
    protected static final Comparator<Field> FIELD_NAME_ORDER;
    protected static final String READER_METHOD_NAME = "readObject";
    protected static final Class<?>[] READER_ARGS;
    protected static final String WRITER_METHOD_NAME = "writeObject";
    protected static final Class<?>[] WRITER_ARGS;
    protected static final Predicate<Field> IS_STREAMABLE;
    protected static final Predicate<Field> IS_STREAMCLOSURE;

    static {
        SORT_FIELDS = Boolean.getBoolean("com.threerings.io.streamFieldsAlphabetically");
        ENUM_POLICY = EnumPolicy.create();
        FIELD_NAME_ORDER = new Comparator<Field>(){

            @Override
            public int compare(Field arg0, Field arg1) {
                return arg0.getName().compareTo(arg1.getName());
            }
        };
        READER_ARGS = new Class[]{ObjectInputStream.class};
        WRITER_ARGS = new Class[]{ObjectOutputStream.class};
        IS_STREAMABLE = new Predicate<Field>(){

            public boolean apply(Field obj) {
                return obj.getAnnotation(NotStreamable.class) == null;
            }
        };
        IS_STREAMCLOSURE = new Predicate<Field>(){

            public boolean apply(Field obj) {
                return IS_STREAMABLE.apply((Object)obj) && (!obj.isSynthetic() || !obj.getName().startsWith("this$"));
            }
        };
    }

    public static synchronized boolean isStreamable(Class<?> target) {
        Streamer.maybeInit();
        if (_streamers.containsKey(target) || target.isEnum()) {
            return true;
        }
        if (target.isArray()) {
            return Streamer.isStreamable(target.getComponentType());
        }
        return Streamable.class.isAssignableFrom(target) || Iterable.class.isAssignableFrom(target) || Map.class.isAssignableFrom(target);
    }

    public static Class<?> getStreamerClass(Object object) {
        return object instanceof Enum ? ((Enum)object).getDeclaringClass() : object.getClass();
    }

    public static Class<?> getCollectionClass(Class<?> clazz) {
        if (Streamable.class.isAssignableFrom(clazz)) {
            return null;
        }
        for (Class<?> collClass : BasicStreamers.CollectionStreamer.SPECIFICITY_ORDER) {
            if (!collClass.isAssignableFrom(clazz)) continue;
            return collClass;
        }
        return null;
    }

    public static synchronized Streamer getStreamer(final Class<?> target) throws IOException {
        Streamer.maybeInit();
        Streamer stream = _streamers.get(target);
        if (stream == null) {
            Class<?> collClass = Streamer.getCollectionClass(target);
            if (collClass != null) {
                stream = Streamer.getStreamer(collClass);
            } else {
                if (!Streamer.isStreamable(target)) {
                    throw new IOException("Requested to stream invalid class '" + target.getName() + "'");
                }
                try {
                    stream = AccessController.doPrivileged(new PrivilegedExceptionAction<Streamer>(){

                        @Override
                        public Streamer run() throws IOException {
                            return Streamer.create(target);
                        }
                    });
                }
                catch (PrivilegedActionException pae) {
                    throw (IOException)pae.getCause();
                }
            }
            _streamers.put(target, stream);
        }
        return stream;
    }

    public abstract void writeObject(Object var1, ObjectOutputStream var2, boolean var3) throws IOException;

    public abstract Object createObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    public abstract void readObject(Object var1, ObjectInputStream var2, boolean var3) throws IOException, ClassNotFoundException;

    public final String toString() {
        return this.toStringHelper().toString();
    }

    protected Objects.ToStringHelper toStringHelper() {
        return Objects.toStringHelper((Object)this);
    }

    protected Streamer() {
    }

    protected static Streamer create(Class<?> target) throws IOException {
        boolean isInner = false;
        boolean isStatic = Modifier.isStatic(target.getModifiers());
        try {
            isInner = target.getDeclaringClass() != null;
        }
        catch (Throwable t) {
            NaryaLog.log.warning((Object)"Failure checking innerness of class", new Object[]{"class", target.getName(), "error", t});
        }
        if (isInner && !isStatic) {
            throw new IllegalArgumentException("Cannot stream non-static inner class: " + target.getName());
        }
        if (target.isArray()) {
            Class<?> componentType = target.getComponentType();
            if (Modifier.isFinal(componentType.getModifiers())) {
                Streamer delegate = Streamer.getStreamer(componentType);
                if (delegate != null) {
                    return new FinalArrayStreamer(componentType, delegate);
                }
            } else if (Streamer.isStreamable(componentType)) {
                return new ArrayStreamer(componentType);
            }
            String errmsg = "Aiya! Streamer created for array type but we have no registered streamer for the element type [type=" + target.getName() + "]";
            throw new RuntimeException(errmsg);
        }
        if (target.isEnum()) {
            switch (ENUM_POLICY) {
                case NAME_WITH_BYTE_ENUM: 
                case ORDINAL_WITH_BYTE_ENUM: {
                    if (!ByteEnum.class.isAssignableFrom(target)) break;
                    return new ByteEnumStreamer(target);
                }
            }
            switch (ENUM_POLICY) {
                case NAME: 
                case NAME_WITH_BYTE_ENUM: {
                    return new NameEnumStreamer(target);
                }
            }
            ImmutableList universe = ImmutableList.copyOf((Object[])target.getEnumConstants());
            int maxOrdinal = universe.size() - 1;
            if (maxOrdinal <= 127) {
                return new ByteOrdEnumStreamer(target, (List<?>)universe);
            }
            if (maxOrdinal <= Short.MAX_VALUE) {
                return new ShortOrdEnumStreamer(target, (List<?>)universe);
            }
            return new IntOrdEnumStreamer(target, (List<?>)universe);
        }
        Method reader = null;
        Method writer = null;
        try {
            reader = target.getMethod(READER_METHOD_NAME, READER_ARGS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        try {
            writer = target.getMethod(WRITER_METHOD_NAME, WRITER_ARGS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        if (reader == null && writer == null) {
            return new ClassStreamer(target);
        }
        return new CustomClassStreamer(target, reader, writer);
    }

    protected static synchronized void maybeInit() {
        if (_streamers == null) {
            _streamers = Maps.newHashMap(BasicStreamers.BSTREAMERS);
        }
    }

    protected static class ArrayStreamer
    extends Streamer {
        protected Class<?> _componentType;

        protected ArrayStreamer(Class<?> componentType) {
            this._componentType = componentType;
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            int length = Array.getLength(object);
            out.writeInt(length);
            Object[] objs = (Object[])object;
            int ii = 0;
            while (ii < length) {
                out.writeObject(objs[ii]);
                ++ii;
            }
        }

        @Override
        public Object createObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int length = in.readInt();
            return Array.newInstance(this._componentType, length);
        }

        @Override
        public void readObject(Object object, ObjectInputStream in, boolean useReader) throws IOException, ClassNotFoundException {
            int length = Array.getLength(object);
            Object[] objs = (Object[])object;
            int ii = 0;
            while (ii < length) {
                objs[ii] = in.readObject();
                ++ii;
            }
        }

        @Override
        protected Objects.ToStringHelper toStringHelper() {
            return super.toStringHelper().add("componentType", (Object)this._componentType.getName());
        }
    }

    protected static class ByteEnumStreamer
    extends EnumStreamer {
        protected ByteEnumStreamer(Class<?> target) {
            super(target);
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            out.writeByte(((ByteEnum)object).toByte());
        }

        @Override
        public Object createObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            return ByteEnumUtil.fromByte((Class)this._eclass, (byte)in.readByte());
        }
    }

    protected static class ByteOrdEnumStreamer
    extends OrdEnumStreamer {
        protected ByteOrdEnumStreamer(Class<?> target, List<?> universe) {
            super(target, universe);
        }

        @Override
        protected void writeCode(ObjectOutputStream out, int code) throws IOException {
            out.writeByte((byte)code);
        }

        @Override
        protected int readCode(ObjectInputStream in) throws IOException {
            return in.readByte();
        }
    }

    protected static class ClassStreamer
    extends Streamer {
        protected Class<?> _target;
        protected Constructor<?> _ctor;
        protected Object[] _ctorArgs;
        protected Field[] _fields;
        protected FieldMarshaller[] _marshallers;

        protected ClassStreamer(Class<?> target) {
            this._target = target;
            this.initConstructor();
            this._marshallers = this.createMarshallers();
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            int fcount = this._fields.length;
            int ii = 0;
            while (ii < fcount) {
                Field field = this._fields[ii];
                FieldMarshaller fm = this._marshallers[ii];
                try {
                    fm.writeField(field, object, out);
                }
                catch (Exception e) {
                    String errmsg = "Failure writing streamable field [class=" + this._target.getName() + ", field=" + field.getName() + "]";
                    throw (IOException)new IOException(errmsg).initCause(e);
                }
                ++ii;
            }
        }

        @Override
        public Object createObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            try {
                return this._ctor.newInstance(this._ctorArgs);
            }
            catch (InvocationTargetException ite) {
                String errmsg = "Error instantiating object [type=" + this._target.getName() + "]";
                throw (IOException)new IOException(errmsg).initCause(ite.getCause());
            }
            catch (InstantiationException ie) {
                String errmsg = "Error instantiating object [type=" + this._target.getName() + "]";
                throw (IOException)new IOException(errmsg).initCause(ie);
            }
            catch (IllegalAccessException iae) {
                String errmsg = "Error instantiating object [type=" + this._target.getName() + "]";
                throw (IOException)new IOException(errmsg).initCause(iae);
            }
        }

        @Override
        public void readObject(Object object, ObjectInputStream in, boolean useReader) throws IOException, ClassNotFoundException {
            int fcount = this._fields.length;
            int ii = 0;
            while (ii < fcount) {
                Field field = this._fields[ii];
                FieldMarshaller fm = this._marshallers[ii];
                try {
                    if (in.available() > 0) {
                        fm.readField(field, object, in);
                    } else {
                        NaryaLog.log.info((Object)"Streamed instance missing field (probably newly added)", new Object[]{"class", this._target.getName(), "field", field.getName()});
                    }
                }
                catch (Exception e) {
                    String errmsg = "Failure reading streamable field [class=" + this._target.getName() + ", field=" + field.getName() + ", error=" + e + "]";
                    throw (IOException)new IOException(errmsg).initCause(e);
                }
                ++ii;
            }
        }

        protected void initConstructor() {
            Constructor<?>[] constructorArray = this._target.getDeclaredConstructors();
            int n = constructorArray.length;
            int n2 = 0;
            while (n2 < n) {
                Constructor<?> ctor = constructorArray[n2];
                if (ctor.getParameterTypes().length == 0) {
                    this._ctor = ctor;
                    this._ctorArgs = ArrayUtil.EMPTY_OBJECT;
                    return;
                }
                ++n2;
            }
            Constructor<?>[] ctors = this._target.getDeclaredConstructors();
            if (ctors.length > 1) {
                throw new RuntimeException("Streamable closure classes must have either a zero-argument constructor or a single argument-taking constructor; multiple argument-taking constructors are not allowed [class=" + this._target.getName() + "]");
            }
            this._ctor = ctors[0];
            this._ctor.setAccessible(true);
            Class<?>[] ptypes = this._ctor.getParameterTypes();
            this._ctorArgs = new Object[ptypes.length];
            int ii = 0;
            while (ii < ptypes.length) {
                this._ctorArgs[ii] = Defaults.defaultValue(ptypes[ii]);
                ++ii;
            }
        }

        protected FieldMarshaller[] createMarshallers() {
            ArrayList fields = Lists.newArrayList();
            ClassUtil.getFields(this._target, (List)fields);
            if (SORT_FIELDS) {
                QuickSort.sort((List)fields, (Comparator)FIELD_NAME_ORDER);
            }
            Predicate filter = Streamable.Closure.class.isAssignableFrom(this._target) ? IS_STREAMCLOSURE : IS_STREAMABLE;
            this._fields = (Field[])Iterables.toArray((Iterable)Iterables.filter((Iterable)fields, (Predicate)filter), Field.class);
            Arrays.sort(this._fields, new Comparator<Field>(){

                @Override
                public int compare(Field o1, Field o2) {
                    return o1.getName().compareTo(o2.getName());
                }
            });
            int fcount = this._fields.length;
            FieldMarshaller[] marshallers = new FieldMarshaller[fcount];
            int ii = 0;
            while (ii < fcount) {
                marshallers[ii] = FieldMarshaller.getFieldMarshaller(this._fields[ii]);
                if (marshallers[ii] == null) {
                    String errmsg = "Unable to marshall field [class=" + this._target.getName() + ", field=" + this._fields[ii].getName() + ", type=" + this._fields[ii].getType().getName() + "]";
                    throw new RuntimeException(errmsg);
                }
                ++ii;
            }
            return marshallers;
        }

        @Override
        protected Objects.ToStringHelper toStringHelper() {
            return super.toStringHelper().add("target", (Object)this._target.getName()).add("fcount", this._fields == null ? 0 : this._fields.length);
        }
    }

    protected static class CustomClassStreamer
    extends ClassStreamer {
        protected Method _reader;
        protected Method _writer;

        protected CustomClassStreamer(Class<?> target, Method reader, Method writer) {
            super(target);
            this._reader = reader;
            this._writer = writer;
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            if (useWriter && this._writer != null) {
                try {
                    this._writer.invoke(object, out);
                }
                catch (Throwable t) {
                    if (t instanceof InvocationTargetException) {
                        t = ((InvocationTargetException)t).getTargetException();
                    }
                    if (t instanceof IOException) {
                        throw (IOException)t;
                    }
                    String errmsg = "Failure invoking streamable writer [class=" + this._target.getName() + "]";
                    throw (IOException)new IOException(errmsg).initCause(t);
                }
                return;
            }
            if (this._marshallers == null) {
                this._marshallers = super.createMarshallers();
            }
            super.writeObject(object, out, useWriter);
        }

        @Override
        public void readObject(Object object, ObjectInputStream in, boolean useReader) throws IOException, ClassNotFoundException {
            if (useReader && this._reader != null) {
                try {
                    this._reader.invoke(object, in);
                }
                catch (Throwable t) {
                    if (t instanceof InvocationTargetException) {
                        t = ((InvocationTargetException)t).getTargetException();
                    }
                    if (t instanceof IOException) {
                        throw (IOException)t;
                    }
                    String errmsg = "Failure invoking streamable reader [class=" + this._target.getName() + "]";
                    throw (IOException)new IOException(errmsg).initCause(t);
                }
                return;
            }
            if (this._marshallers == null) {
                this._marshallers = super.createMarshallers();
            }
            super.readObject(object, in, useReader);
        }

        @Override
        protected FieldMarshaller[] createMarshallers() {
            return null;
        }

        @Override
        protected Objects.ToStringHelper toStringHelper() {
            return super.toStringHelper().add("reader", (Object)this._reader).add("writer", (Object)this._writer);
        }
    }

    protected static enum EnumPolicy {
        NAME,
        NAME_WITH_BYTE_ENUM,
        ORDINAL,
        ORDINAL_WITH_BYTE_ENUM;


        public static EnumPolicy create() {
            String policy = System.getProperty("com.threerings.io.enumPolicy");
            try {
                return EnumPolicy.valueOf(policy);
            }
            catch (Exception e) {
                return NAME_WITH_BYTE_ENUM;
            }
        }
    }

    protected static abstract class EnumStreamer
    extends Streamer {
        protected Class<EnumReader> _eclass;

        protected EnumStreamer(Class<?> target) {
            Class<?> eclass = target;
            this._eclass = eclass;
        }

        @Override
        public void readObject(Object object, ObjectInputStream in, boolean useReader) throws IOException, ClassNotFoundException {
        }

        @Override
        public Objects.ToStringHelper toStringHelper() {
            return super.toStringHelper().add("eclass", (Object)this._eclass.getName());
        }

        protected static enum EnumReader implements ByteEnum
        {
            NOT_USED;


            public byte toByte() {
                return 0;
            }
        }
    }

    protected static class FinalArrayStreamer
    extends ArrayStreamer {
        protected Streamer _delegate;

        protected FinalArrayStreamer(Class<?> componentType, Streamer delegate) {
            super(componentType);
            this._delegate = delegate;
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            int length = Array.getLength(object);
            out.writeInt(length);
            ArrayMask mask = new ArrayMask(length);
            Object[] objs = (Object[])object;
            int ii = 0;
            while (ii < length) {
                if (objs[ii] != null) {
                    mask.set(ii);
                }
                ++ii;
            }
            mask.writeTo(out);
            ii = 0;
            while (ii < length) {
                Object element = objs[ii];
                if (element != null) {
                    out.writeBareObject(element, this._delegate, useWriter);
                }
                ++ii;
            }
        }

        @Override
        public void readObject(Object object, ObjectInputStream in, boolean useReader) throws IOException, ClassNotFoundException {
            int length = Array.getLength(object);
            ArrayMask mask = new ArrayMask();
            mask.readFrom(in);
            Object[] objs = (Object[])object;
            int ii = 0;
            while (ii < length) {
                if (mask.isSet(ii)) {
                    Object element = this._delegate.createObject(in);
                    in.readBareObject(element, this._delegate, useReader);
                    objs[ii] = element;
                }
                ++ii;
            }
        }

        @Override
        protected Objects.ToStringHelper toStringHelper() {
            return super.toStringHelper().add("delegate", (Object)this._delegate);
        }
    }

    protected static class IntOrdEnumStreamer
    extends OrdEnumStreamer {
        protected IntOrdEnumStreamer(Class<?> target, List<?> universe) {
            super(target, universe);
        }

        @Override
        protected void writeCode(ObjectOutputStream out, int code) throws IOException {
            out.writeInt(code);
        }

        @Override
        protected int readCode(ObjectInputStream in) throws IOException {
            return in.readInt();
        }
    }

    protected static class NameEnumStreamer
    extends EnumStreamer {
        protected NameEnumStreamer(Class<?> target) {
            super(target);
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            out.writeUTF(((Enum)object).name());
        }

        @Override
        public Object createObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            return Enum.valueOf(this._eclass, in.readUTF());
        }
    }

    protected static abstract class OrdEnumStreamer
    extends EnumStreamer {
        protected List<?> _universe;

        protected OrdEnumStreamer(Class<?> target, List<?> universe) {
            super(target);
            this._universe = universe;
        }

        @Override
        public void writeObject(Object object, ObjectOutputStream out, boolean useWriter) throws IOException {
            int code = object == null ? -1 : ((Enum)object).ordinal();
            this.writeCode(out, code);
        }

        @Override
        public Object createObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            int code = this.readCode(in);
            return code == -1 ? null : this._universe.get(code);
        }

        protected abstract void writeCode(ObjectOutputStream var1, int var2) throws IOException;

        protected abstract int readCode(ObjectInputStream var1) throws IOException;
    }

    protected static class ShortOrdEnumStreamer
    extends OrdEnumStreamer {
        protected ShortOrdEnumStreamer(Class<?> target, List<?> universe) {
            super(target, universe);
        }

        @Override
        protected void writeCode(ObjectOutputStream out, int code) throws IOException {
            out.writeShort((short)code);
        }

        @Override
        protected int readCode(ObjectInputStream in) throws IOException {
            return in.readShort();
        }
    }
}

