/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.crowd.data;

import com.threerings.crowd.Log;
import com.threerings.crowd.chat.data.SpeakMarshaller;
import com.threerings.crowd.chat.data.SpeakObject;
import com.threerings.crowd.data.OccupantInfo;
import com.threerings.presents.dobj.DObject;
import com.threerings.presents.dobj.DObjectManager;
import com.threerings.presents.dobj.DSet;
import com.threerings.presents.dobj.OidList;
import com.threerings.presents.dobj.ServerMessageEvent;
import com.threerings.util.Name;

public class PlaceObject
extends DObject
implements SpeakObject {
    public static final String OCCUPANTS = "occupants";
    public static final String OCCUPANT_INFO = "occupantInfo";
    public static final String SPEAK_SERVICE = "speakService";
    public transient ManagerCaller manager;
    public OidList occupants = new OidList();
    public DSet<OccupantInfo> occupantInfo = new DSet();
    public SpeakMarshaller speakService;

    public void initManagerCaller(DObjectManager omgr) {
        this.manager = new ManagerCaller(omgr);
    }

    public boolean shouldBroadcast() {
        return true;
    }

    public OccupantInfo getOccupantInfo(Name username) {
        try {
            for (OccupantInfo info : this.occupantInfo) {
                if (!info.username.equals(username)) continue;
                return info;
            }
        }
        catch (Throwable t) {
            Log.log.warning((Object)"PlaceObject.getOccupantInfo choked.", new Object[]{t});
        }
        return null;
    }

    @Override
    public void applyToListeners(SpeakObject.ListenerOp op) {
        int ii = 0;
        int ll = this.occupants.size();
        while (ii < ll) {
            op.apply(this.occupants.get(ii));
            ++ii;
        }
    }

    public void addToOccupants(int oid) {
        this.requestOidAdd(OCCUPANTS, this.occupants, oid);
    }

    public void removeFromOccupants(int oid) {
        this.requestOidRemove(OCCUPANTS, this.occupants, oid);
    }

    public void addToOccupantInfo(OccupantInfo elem) {
        this.requestEntryAdd(OCCUPANT_INFO, this.occupantInfo, elem);
    }

    public void removeFromOccupantInfo(Comparable<?> key) {
        this.requestEntryRemove(OCCUPANT_INFO, this.occupantInfo, key);
    }

    public void updateOccupantInfo(OccupantInfo elem) {
        this.requestEntryUpdate(OCCUPANT_INFO, this.occupantInfo, elem);
    }

    public void setOccupantInfo(DSet<OccupantInfo> value) {
        Object clone;
        this.requestAttributeChange(OCCUPANT_INFO, value, this.occupantInfo);
        this.occupantInfo = clone = value == null ? null : value.clone();
    }

    public void setSpeakService(SpeakMarshaller value) {
        SpeakMarshaller ovalue = this.speakService;
        this.requestAttributeChange(SPEAK_SERVICE, value, ovalue);
        this.speakService = value;
    }

    public class ManagerCaller {
        protected DObjectManager _omgr;

        public void invoke(String method, Object ... args) {
            this._omgr.postEvent(new ServerMessageEvent(PlaceObject.this._oid, method, args));
        }

        protected ManagerCaller(DObjectManager omgr) {
            this._omgr = omgr;
        }
    }
}

