/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.admin.client;

import com.samskivert.swing.VGroupLayout;
import com.samskivert.util.QuickSort;
import com.threerings.admin.Log;
import com.threerings.admin.client.AdminService;
import com.threerings.admin.client.ObjectEditorPanel;
import com.threerings.presents.util.PresentsContext;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.Comparator;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;

public class ConfigEditorPanel
extends JPanel
implements AdminService.ConfigInfoListener {
    protected PresentsContext _ctx;
    protected JTabbedPane _oeditors;
    protected String _defaultPane;

    public ConfigEditorPanel(PresentsContext ctx) {
        this(ctx, null);
    }

    public ConfigEditorPanel(PresentsContext ctx, String defaultPane) {
        this._ctx = ctx;
        this._defaultPane = defaultPane;
        this.setLayout((LayoutManager)new VGroupLayout(VGroupLayout.STRETCH, VGroupLayout.STRETCH, 5, VGroupLayout.CENTER));
        this._oeditors = new JTabbedPane(2);
        this.add(this._oeditors);
        this._oeditors.setTabLayoutPolicy(1);
        this.add((Component)new JLabel("Fields outline in red have been modified but not yet committed."), VGroupLayout.FIXED);
        this.add((Component)new JLabel("Press return in a modified field to commit the change."), VGroupLayout.FIXED);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        AdminService service = this._ctx.getClient().requireService(AdminService.class);
        service.getConfigInfo(this);
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        int ccount = this._oeditors.getComponentCount();
        int ii = 0;
        while (ii < ccount) {
            Component comp = this._oeditors.getComponent(ii);
            if (comp instanceof JScrollPane) {
                JScrollPane scrolly = (JScrollPane)comp;
                ObjectEditorPanel opanel = (ObjectEditorPanel)((Object)scrolly.getViewport().getView());
                opanel.cleanup();
            }
            ++ii;
        }
        this._oeditors.removeAll();
    }

    @Override
    public void gotConfigInfo(final String[] keys, int[] oids) {
        if (!this.isDisplayable()) {
            return;
        }
        Object[] indexes = new Integer[keys.length];
        int ii = 0;
        while (ii < indexes.length) {
            indexes[ii] = ii;
            ++ii;
        }
        QuickSort.sort((Object[])indexes, (Comparator)new Comparator<Integer>(){

            @Override
            public int compare(Integer i1, Integer i2) {
                return keys[i1].compareTo(keys[i2]);
            }
        });
        Object[] objectArray = indexes;
        int n = indexes.length;
        int n2 = 0;
        while (n2 < n) {
            Object ii2 = objectArray[n2];
            ObjectEditorPanel panel = new ObjectEditorPanel(this._ctx, keys[(Integer)ii2], oids[(Integer)ii2]);
            JScrollPane scrolly = new JScrollPane((Component)((Object)panel));
            this._oeditors.addTab(keys[(Integer)ii2], scrolly);
            if (keys[(Integer)ii2].equals(this._defaultPane)) {
                this._oeditors.setSelectedComponent(scrolly);
            }
            ++n2;
        }
    }

    @Override
    public void requestFailed(String reason) {
        Log.log.warning((Object)"Failed to get config info", new Object[]{"reason", reason});
    }
}

