/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.presents.server;

import com.threerings.presents.Log;
import com.threerings.presents.net.AuthResponse;
import com.threerings.presents.net.ServiceCreds;
import com.threerings.presents.server.Authenticator;
import com.threerings.presents.server.ChainedAuthenticator;
import com.threerings.presents.server.net.AuthingConnection;
import com.threerings.util.Name;
import java.lang.reflect.Constructor;

public abstract class ServiceAuthenticator<T extends ServiceCreds>
extends ChainedAuthenticator {
    protected Class<T> _credsClass;
    protected Constructor<? extends Name> _authNamer;

    public ServiceAuthenticator(Class<T> credsClass, Class<? extends Name> authNameClass) {
        this._credsClass = credsClass;
        try {
            this._authNamer = authNameClass.getConstructor(String.class);
        }
        catch (NoSuchMethodException nsme) {
            throw new IllegalArgumentException("AuthName must have AuthName(String) constructor.");
        }
    }

    @Override
    public boolean shouldHandleConnection(AuthingConnection conn) {
        return this._credsClass.isInstance(conn.getAuthRequest().getCredentials());
    }

    @Override
    protected void processAuthentication(AuthingConnection conn, AuthResponse rsp) throws Exception {
        ServiceCreds creds = (ServiceCreds)this._credsClass.cast(conn.getAuthRequest().getCredentials());
        if (!this.areValid(creds)) {
            Log.log.warning((Object)"Received invalid service auth request?", new Object[]{"creds", creds});
            throw new Authenticator.AuthException("m.server_error");
        }
        try {
            conn.setAuthName(this._authNamer.newInstance(creds.clientId));
            rsp.getData().code = "success";
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed to construct auth name", new Object[]{"namer", this._authNamer, e});
            throw new Authenticator.AuthException("m.server_error");
        }
    }

    protected abstract boolean areValid(T var1);
}

